/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts.gt2;

import javax.media.jai.ParameterList;
import org.cresques.impl.cts.gt2.CSDatum;
import org.cresques.impl.cts.gt2.CoordSys;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.measure.Angle;
import org.geotools.units.Unit;
import org.opengis.referencing.FactoryException;

public class CSGaussPt
extends CoordSys {
    public static CSGaussPt hgd73 = new CSGaussPt(CSDatum.d73);

    public CSGaussPt(CSDatum datum) {
        super(datum);
        this.geogCS = new GeographicCoordinateSystem((CharSequence)datum.getName(null), datum.getDatum());
        Unit linearUnit = Unit.METRE;
        ParameterList params = this.csFactory.createProjectionParameterList("Oblique_Stereographic");
        params.setParameter("semi_major", datum.getDatum().getEllipsoid().getSemiMajorAxis());
        params.setParameter("semi_minor", datum.getDatum().getEllipsoid().getSemiMinorAxis());
        params.setParameter("central_meridian", new Angle("8\u00b007'54.862\"W").degrees());
        params.setParameter("latitude_of_origin", new Angle("39\u00b040'N").degrees());
        params.setParameter("scale_factor", 1.0);
        params.setParameter("false_easting", 0.0);
        params.setParameter("false_northing", 0.0);
        try {
            Projection projection = this.csFactory.createProjection((CharSequence)"GAUSS", "Oblique_Stereographic", params);
            this.projCS = this.csFactory.createProjectedCoordinateSystem((CharSequence)projection.getName().toString(), this.geogCS, projection, linearUnit, AxisInfo.X, AxisInfo.Y);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.projCS.toString();
    }
}

