/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts.gt2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.cresques.impl.cts.gt2.CSDatum;
import org.cresques.impl.cts.gt2.CoordTrans;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.ProjectedCoordinateSystem;
import org.gvsig.fmap.crs.CRSFactory;
import org.opengis.referencing.FactoryException;

public class CoordSys
implements IProjection {
    private static final Color basicGridColor = new Color(64, 64, 64, 128);
    protected CoordinateSystemFactory csFactory = CoordinateSystemFactory.getDefault();
    protected CSDatum datum = null;
    protected GeographicCoordinateSystem geogCS = null;
    protected ProjectedCoordinateSystem projCS = null;
    protected String abrev = "";
    Color gridColor = basicGridColor;

    public CoordSys(CSDatum datum) {
        this.datum = datum;
        this.geogCS = new GeographicCoordinateSystem((CharSequence)datum.getName(null), datum.getDatum());
    }

    public CoordSys(String wkt) {
        try {
            CoordinateSystem cs = CoordinateSystemFactory.getDefault().createFromWKT(wkt);
            if (cs instanceof GeographicCoordinateSystem) {
                this.geogCS = (GeographicCoordinateSystem)cs;
            }
            if (cs instanceof ProjectedCoordinateSystem) {
                this.projCS = (ProjectedCoordinateSystem)cs;
                this.geogCS = this.projCS.getGeographicCoordinateSystem();
            }
            this.datum = new CSDatum(this.geogCS.getHorizontalDatum());
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    public CoordSys toGeo() {
        CoordSys coordSys = new CoordSys((CSDatum)this.getDatum());
        coordSys.geogCS = this.geogCS != null ? this.geogCS : this.projCS.getGeographicCoordinateSystem();
        return coordSys;
    }

    public IDatum getDatum() {
        return this.datum;
    }

    public CoordinateSystem getCS() {
        if (this.projCS != null) {
            return this.projCS;
        }
        return this.geogCS;
    }

    public CoordinateSystem getGeogCS() {
        if (this.geogCS != null) {
            return this.geogCS;
        }
        return this.projCS.getGeographicCoordinateSystem();
    }

    public Point2D createPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }

    public String toString() {
        if (this.projCS != null) {
            return this.projCS.toString();
        }
        return this.geogCS.toString();
    }

    public void setAbrev(String abrev) {
        this.abrev = abrev;
    }

    public String getAbrev() {
        return this.abrev;
    }

    public void drawGrid(Graphics2D g, ViewPortData vp) {
    }

    public void setGridColor(Color c) {
        this.gridColor = c;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Point2D toGeo(Point2D pt) {
        CoordTrans ct = new CoordTrans(this, this.toGeo());
        return ct.convert(pt, null);
    }

    public Point2D fromGeo(Point2D gPt, Point2D mPt) {
        return null;
    }

    public double getScale(double minX, double maxX, double w, double dpi) {
        double scale = 0.0;
        if (this.projCS == null) {
            scale = (maxX - minX) * (dpi / 2.54 * 100.0 * 1852.0 * 60.0) / w;
        }
        return scale;
    }

    public Rectangle2D getExtent(Rectangle2D extent, double scale, double wImage, double hImage, double mapUnits, double distanceUnits, double dpi) {
        double w = 0.0;
        double h = 0.0;
        double wExtent = 0.0;
        double hExtent = 0.0;
        if (this.projCS != null) {
            w = wImage / dpi * 2.54;
            h = hImage / dpi * 2.54;
            wExtent = w * scale * distanceUnits / mapUnits;
            hExtent = h * scale * distanceUnits / mapUnits;
        } else {
            w = wImage / dpi * 2.54;
            h = hImage / dpi * 2.54;
            wExtent = w * scale * distanceUnits / (mapUnits * 1852.0 * 60.0);
            hExtent = h * scale * distanceUnits / (mapUnits * 1852.0 * 60.0);
        }
        double xExtent = extent.getCenterX() - wExtent / 2.0;
        double yExtent = extent.getCenterY() - hExtent / 2.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(xExtent, yExtent, wExtent, hExtent);
        return rec;
    }

    public boolean isProjected() {
        return this.projCS != null;
    }

    public ICoordTrans getCT(IProjection dest) {
        return new CoordTrans(this, (CoordSys)dest);
    }

    public String getFullCode() {
        return this.getAbrev();
    }

    public Object clone() throws CloneNotSupportedException {
        return CRSFactory.getCRS((String)this.getFullCode());
    }

    public String export(String format) {
        return null;
    }
}

