/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.TreeMap;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.cresques.impl.geo.Ellipsoid;
import org.cresques.impl.geo.GeoPoint;
import org.cresques.impl.geo.Graticule;
import org.cresques.impl.geo.Projection;
import org.cresques.px.Extent;

public class Geodetic
extends Projection {
    private static TreeMap projList = new TreeMap();
    static String name = "Geodesica";
    static String abrev = "Geo";
    public static Geodetic hayford = new Geodetic(Ellipsoid.hayford);

    public Geodetic() {
        this.grid = new Graticule(this);
    }

    public Geodetic(Ellipsoid eli) {
        super(eli);
        this.grid = new Graticule(this);
    }

    @Override
    public String getAbrev() {
        return abrev;
    }

    public static IProjection getProjectionByName(IDatum eli, String name) {
        if (name.indexOf("GEO") < 0) {
            return null;
        }
        if (name.indexOf("WGS84") >= 0) {
            return Geodetic.getProjection(Ellipsoid.wgs84);
        }
        if (name.indexOf("ED50") >= 0) {
            return Geodetic.getProjection(Ellipsoid.wgs84);
        }
        return null;
    }

    public static Geodetic getProjection(Ellipsoid eli) {
        Geodetic ret = null;
        String key = eli.toString();
        if (projList.containsKey(key)) {
            ret = (Geodetic)projList.get(key);
        } else {
            ret = eli == Ellipsoid.hayford ? hayford : new Geodetic(eli);
            projList.put(key, ret);
        }
        return ret;
    }

    @Override
    public Point2D createPoint(double x, double y) {
        return new GeoPoint(this, x, y);
    }

    @Override
    public Point2D toGeo(Point2D gPt) {
        return (GeoPoint)gPt;
    }

    @Override
    public Point2D fromGeo(Point2D gPt, Point2D pPt) {
        return gPt;
    }

    private void generateGrid(Graphics2D g, Extent extent, AffineTransform mat) {
        Point2D pt1 = extent.getMin();
        double step = 1.0;
        double x = (int)pt1.getX();
        double dist = 0.0;
        GeoPoint gp1 = (GeoPoint)this.createPoint(x, (int)pt1.getY());
        mat.transform(gp1, gp1);
        GeoPoint gp2 = (GeoPoint)this.createPoint(gp1.getX() + 100.0, gp1.getY() - 100.0);
        try {
            mat.inverseTransform(gp2, gp2);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        dist = gp2.getX() - x;
        System.err.println("distX = " + dist);
        step = dist > 30.0 ? 30.0 : (dist > 15.0 ? 15.0 : (dist > 10.0 ? 10.0 : (dist > 5.0 ? 5.0 : (dist > 3.0 ? 3.0 : (dist > 2.0 ? 2.0 : (dist > 1.0 ? 1.0 : (dist > 0.5 ? 0.5 : (dist > 0.25 ? 0.25 : (dist > 0.08333333333333333 ? 0.08333333333333333 : 0.03333333333333333)))))))));
        this.generateGrid(g, extent, mat, step);
    }

    private void generateGrid(Graphics2D g, Extent extent, AffineTransform mat, double step) {
        GeoPoint gp2;
        GeoPoint gp1;
        this.grid = new Graticule(this);
        Point2D.Double ptx = new Point2D.Double(0.0, 0.0);
        Point2D pt1 = extent.getMin();
        Point2D pt2 = extent.getMax();
        System.err.println(name + ": ViewPort Extent = (" + pt1 + "," + pt2 + ")");
        FontMetrics fm = g.getFontMetrics();
        boolean fmWidth = false;
        int fmHeight = fm.getAscent();
        String tit = "";
        String fmt = "%G\u00ba%N";
        if (step < 1.0) {
            fmt = "%G\u00ba%M'%N";
        }
        double y1 = pt1.getY();
        double y2 = pt2.getY();
        double xIni = (int)pt1.getX() - 1;
        xIni -= xIni % step;
        double xFin = (int)pt2.getX() + 1;
        if (y1 < -90.0) {
            y1 = -90.0;
        }
        if (y2 > 90.0) {
            y2 = 90.0;
        }
        if (xIni < -180.0) {
            xIni = -180.0;
        }
        if (xFin > 180.0) {
            xFin = 180.0;
        }
        for (double x = xIni; x <= xFin; x += step) {
            gp1 = (GeoPoint)this.createPoint(x, y1);
            gp2 = (GeoPoint)this.createPoint(x, y2);
            mat.transform(gp1, gp1);
            mat.transform(gp2, gp2);
            this.grid.addLine(gp1, gp2);
            tit = Geodetic.coordToString(x, fmt, false);
            ptx.setLocation(gp2.getX() + 3.0, gp2.getY() + (double)fmHeight);
            this.grid.addText(tit, ptx);
        }
        double x1 = pt1.getX();
        double x2 = pt2.getX();
        double yIni = (int)pt1.getY() - 1;
        yIni -= yIni % step;
        double yFin = (int)pt2.getY() + 1;
        if (x1 < -180.0) {
            x1 = -180.0;
        }
        if (x2 > 180.0) {
            x2 = 180.0;
        }
        if (yIni < -90.0) {
            yIni = -90.0;
        }
        if (yFin > 90.0) {
            yFin = 90.0;
        }
        for (double y = yIni; y <= yFin; y += step) {
            gp1 = (GeoPoint)this.createPoint(x1, y);
            gp2 = (GeoPoint)this.createPoint(x2, y);
            mat.transform(gp1, gp1);
            mat.transform(gp2, gp2);
            this.grid.addLine(gp1, gp2);
            tit = Geodetic.coordToString(y, fmt, true);
            ptx.setLocation(gp1.getX() + 3.0, gp1.getY() - 2.0);
            this.grid.addText(tit, ptx);
        }
    }

    @Override
    public void drawGrid(Graphics2D g, ViewPortData vp) {
        this.generateGrid(g, vp.getExtent(), vp.getMat());
        this.grid.setColor(this.gridColor);
        this.grid.draw(g, vp);
    }

    public double getScale(double minX, double maxX, double width, double dpi) {
        double scale = (maxX - minX) * (dpi / 2.54 * 100.0 * 1852.0 * 60.0) / width;
        return scale;
    }

    public ICoordTrans getCT(IProjection dest) {
        return null;
    }

    public Rectangle2D getExtent(Rectangle2D extent, double scale, double wImage, double hImage, double mapUnits, double distanceUnits, double dpi) {
        double w = 0.0;
        double h = 0.0;
        double wExtent = 0.0;
        double hExtent = 0.0;
        w = wImage / dpi * 2.54;
        h = hImage / dpi * 2.54;
        wExtent = w * scale * distanceUnits / (mapUnits * 1852.0 * 60.0);
        hExtent = h * scale * distanceUnits / (mapUnits * 1852.0 * 60.0);
        double xExtent = extent.getCenterX() - wExtent / 2.0;
        double yExtent = extent.getCenterY() - hExtent / 2.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(xExtent, yExtent, wExtent, hExtent);
        return rec;
    }

    public String getFullCode() {
        return this.getAbrev();
    }
}

