/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.impl.geo.GeoPoint;
import org.cresques.impl.geo.Geodetic;
import org.cresques.impl.geo.Mercator;
import org.cresques.impl.geo.ProjPoint;
import org.cresques.impl.geo.Projection;
import org.cresques.impl.geo.UtmPoint;
import org.cresques.impl.geo.UtmZone;

public class ReProjection
implements ICoordTrans {
    Projection pOrig;
    Projection pDest;

    public ReProjection(Projection pOrig, Projection pDest) {
        this.pOrig = pOrig;
        this.pDest = pDest;
    }

    public ICoordTrans getInverted() {
        return new ReProjection(this.pDest, this.pOrig);
    }

    public IProjection getPOrig() {
        return this.pOrig;
    }

    public IProjection getPDest() {
        return this.pDest;
    }

    public Point2D convert(Point2D ptOrig, Point2D ptDest) {
        if (this.pOrig.getClass() == UtmZone.class) {
            GeoPoint pt1 = null;
            pt1 = (GeoPoint)((UtmZone)this.pOrig).toGeo((UtmPoint)ptOrig);
            if (this.pDest.getClass() == UtmZone.class) {
                ((UtmZone)this.pDest).fromGeo(pt1, (UtmPoint)ptDest, (UtmZone)this.pDest);
            } else if (this.pDest.getClass() == Geodetic.class) {
                ptDest.setLocation(pt1.getX(), pt1.getY());
                ((GeoPoint)ptDest).proj = pt1.proj;
            } else if (this.pDest.getClass() == Mercator.class) {
                ((Mercator)this.pDest).fromGeo(pt1, (ProjPoint)ptDest);
            }
        } else if (this.pOrig.getClass() == Geodetic.class) {
            if (this.pDest.getClass() == UtmZone.class) {
                ((UtmZone)this.pDest).fromGeo((GeoPoint)ptOrig, (UtmPoint)ptDest, (UtmZone)this.pDest);
            } else if (this.pDest.getClass() == Mercator.class) {
                ((Mercator)this.pDest).fromGeo((GeoPoint)ptOrig, (ProjPoint)ptDest);
            }
        } else if (this.pOrig.getClass() == Mercator.class) {
            GeoPoint pt1 = null;
            pt1 = (GeoPoint)((Mercator)this.pOrig).toGeo((ProjPoint)ptOrig);
            if (this.pDest.getClass() == UtmZone.class) {
                ((UtmZone)this.pDest).fromGeo(pt1, (UtmPoint)ptDest, (UtmZone)this.pDest);
            } else if (this.pDest.getClass() == Geodetic.class) {
                ptDest.setLocation(pt1.getX(), pt1.getY());
                ((ProjPoint)ptDest).proj = pt1.proj;
            }
        }
        return ptDest;
    }

    public Rectangle2D convert(Rectangle2D rect) {
        Point2D.Double pt1 = new Point2D.Double(rect.getMinX(), rect.getMinY());
        Point2D.Double pt2 = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
        Point2D.Double pt3 = new Point2D.Double(rect.getMinX(), rect.getMaxY());
        Point2D.Double pt4 = new Point2D.Double(rect.getMaxX(), rect.getMinY());
        this.convert(pt1, pt1);
        this.convert(pt2, pt2);
        this.convert(pt3, pt3);
        this.convert(pt4, pt4);
        double min_x = Math.min(Math.min(((Point2D)pt1).getX(), ((Point2D)pt2).getX()), Math.min(((Point2D)pt3).getX(), ((Point2D)pt4).getX()));
        double min_y = Math.min(Math.min(((Point2D)pt1).getY(), ((Point2D)pt2).getY()), Math.min(((Point2D)pt3).getY(), ((Point2D)pt4).getY()));
        double max_x = Math.max(Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX()), Math.max(((Point2D)pt3).getX(), ((Point2D)pt4).getX()));
        double max_y = Math.max(Math.max(((Point2D)pt1).getY(), ((Point2D)pt2).getY()), Math.max(((Point2D)pt3).getY(), ((Point2D)pt4).getY()));
        return new Rectangle2D.Double(min_x, min_y, max_x - min_x, max_y - min_y);
    }
}

