/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.reportfromlayout;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.reportfromlayout.ConfigureReportFromLayoutPanelView;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.report.LayoutReportAction;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionFactory;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.PositiveDoubleDocumentFilter;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureReportFromLayout
extends ConfigureReportFromLayoutPanelView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigureReportFromLayout.class);
    private static final int TO_RECORD_VALUE = 1;
    private static final int TO_EVERYTIHNG_EXCEPT_RECORD_VALUE = 2;
    private StoresRepositoryController treeSourceController;
    private FeatureStore source;
    private Dialog dialog;
    private ISymbol highlightSymbol;
    private PickerController<ISymbol> symbolPicker;

    public ConfigureReportFromLayout() {
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.translate();
        this.fillCboLayout();
        this.cboLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureReportFromLayout.this.doChangeLayout();
            }
        });
        this.treeSourceController = dataSwingManager.createStoresRepositoryController(this.treeSource);
        this.treeSource.addTreeSelectionListener(e -> {
            this.doChangeSource();
            this.doUpdateComponents();
        });
        this.cboReport.addActionListener(e -> this.doChangeReport());
        this.txtIdentifier.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConfigureReportFromLayout.this.doUpdateComponents();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConfigureReportFromLayout.this.doUpdateComponents();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConfigureReportFromLayout.this.doUpdateComponents();
            }
        });
        this.chkZoomToCurrentRow.addActionListener(e -> this.doUpdateComponents());
        this.chkHighlightRecord.addActionListener(e -> this.doUpdateComponents());
        this.fillCboApplyTo();
        this.symbolPicker = SymbologySwingLocator.getSwingManager().createSymbolPickerController(this.btnSelectSymbol, this.highlightSymbol);
        this.symbolPicker.addChangeListener(e -> {
            this.highlightSymbol = (ISymbol)this.symbolPicker.get();
        });
        PositiveDoubleDocumentFilter.install((JTextField)this.txtBufferSize);
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)this, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        SwingUtilities.invokeLater(this::doUpdateComponents);
    }

    private void doChangeSource() {
        FeatureStore theSource = this.treeSourceController.getSelectedFeatureStore();
        if (theSource == null) {
            return;
        }
        if (this.source != null) {
            DisposeUtils.disposeQuietly((Disposable)this.source);
        }
        this.source = theSource;
        this.fillCboReport();
        this.doUpdateComponents();
    }

    private void doChangeLayout() {
        this.fillCboView();
        this.doUpdateComponents();
    }

    private void doUpdateComponents() {
        this.treeSourceController.setEnabled(true);
        this.cboReport.setEnabled(this.source != null);
        this.txtBufferSize.setEnabled(this.chkZoomToCurrentRow.isSelected());
        this.btnSelectSymbol.setEnabled(this.chkHighlightRecord.isSelected());
        this.cboApplySymbolTo.setEnabled(this.chkHighlightRecord.isSelected());
        if (this.dialog != null) {
            boolean enabled = this.source != null && this.getLayoutDocument() != null && StringUtils.isNotBlank((CharSequence)this.txtIdentifier.getText());
            this.dialog.setButtonEnabled(1, enabled);
        }
    }

    private void fillCboReport() {
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        if (this.source == null) {
            this.cboReport.setModel(model);
            return;
        }
        List reports = dataSwingManager.getReportActions((DataStore)this.source, t -> LayoutReportActionFactory.isJsonApplicable(t));
        model.addElement(new LabeledValueImpl("", null));
        for (ReportAction report : reports) {
            model.addElement(new LabeledValueImpl(report.getReportLabel(), (Object)report));
        }
        this.cboReport.setModel(model);
    }

    List<Document> getLayouts() {
        List layouts = ApplicationLocator.getProjectManager().getCurrentProject().getDocuments(LayoutDocument.class);
        return layouts;
    }

    private void fillCboLayout() {
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        List<Document> layouts = this.getLayouts();
        for (Document layout : layouts) {
            if (!(layout instanceof LayoutDocument)) continue;
            model.addElement(new LabeledValueImpl(layout.getName(), (Object)((LayoutDocument)layout)));
        }
        this.cboLayout.setModel(model);
        this.fillCboView();
    }

    private void fillCboView() {
        LayoutDocument layout = this.getLayoutDocument();
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        if (layout != null) {
            int n = 1;
            for (IFFrame frame : layout.getLayoutContext().getAllFFrames()) {
                if (!(frame instanceof FFrameView)) continue;
                String tag = frame.getTag();
                if (StringUtils.startsWith((CharSequence)tag, (CharSequence)"#") && !StringUtils.equals((CharSequence)tag, (CharSequence)("#" + n))) {
                    model.addElement(new LabeledValueImpl(tag + " (invalid tag)", (Object)tag));
                } else {
                    if (StringUtils.isBlank((CharSequence)tag)) {
                        tag = "#" + n;
                    }
                    model.addElement(new LabeledValueImpl(tag, (Object)tag));
                }
                ++n;
            }
        }
        this.cboView.setModel(model);
    }

    private void fillCboApplyTo() {
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        I18nManager i18n = ToolsLocator.getI18nManager();
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_to_record"), (Object)1));
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_to_everything_except_record"), (Object)2));
        this.cboApplySymbolTo.setModel(model);
    }

    private LayoutReportAction getReportAction() {
        LabeledValue selected = (LabeledValue)this.cboReport.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return (LayoutReportAction)selected.getValue();
    }

    public LayoutDocument getLayoutDocument() {
        LabeledValue selected = (LabeledValue)this.cboLayout.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return (LayoutDocument)selected.getValue();
    }

    private String getViewTag() {
        LabeledValue selected = (LabeledValue)this.cboView.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return (String)selected.getValue();
    }

    public void fetch(LayoutReportActionParameters params) {
        params.setIdentifier(this.txtIdentifier.getText());
        params.setLabel(this.txtLabel.getText());
        params.setCenterToCurrentRow(this.chkCenterToCurrentRow.isSelected());
        params.setZoomToCurrentRow(this.chkZoomToCurrentRow.isSelected());
        double bufferSize = PositiveDoubleDocumentFilter.getValue((JTextField)this.txtBufferSize);
        params.setBufferSize(bufferSize);
        params.setViewTag(this.getViewTag());
        params.setUseInternalPdfViewer(this.chkUseInternalPdfViewer.isSelected());
        params.setHighlightRecord(this.chkHighlightRecord.isSelected());
        params.setHighlightSymbol(this.highlightSymbol);
        Object applyToItem = this.cboApplySymbolTo.getSelectedItem();
        if (applyToItem == null) {
            params.setApplySymbolToRecord(false);
            params.setApplySymbolToEverythingExceptRecord(false);
        } else {
            switch ((Integer)((LabeledValue)applyToItem).getValue()) {
                case 1: {
                    params.setApplySymbolToRecord(true);
                    params.setApplySymbolToEverythingExceptRecord(false);
                    break;
                }
                case 2: {
                    params.setApplySymbolToRecord(false);
                    params.setApplySymbolToEverythingExceptRecord(true);
                    break;
                }
                default: {
                    params.setApplySymbolToRecord(false);
                    params.setApplySymbolToEverythingExceptRecord(false);
                }
            }
        }
    }

    private void translate() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblLayout);
        manager.translate(this.lblSource);
        manager.translate(this.lblReport);
        manager.translate(this.lblIdentifier);
        manager.translate(this.lblLabel);
        manager.translate((JComponent)this.lblViewSeparator);
        manager.translate(this.lblView);
        manager.translate((AbstractButton)this.chkCenterToCurrentRow);
        manager.translate((AbstractButton)this.chkZoomToCurrentRow);
        manager.translate(this.lblBufferSize);
        manager.translate((AbstractButton)this.chkUseInternalPdfViewer);
        manager.translate((JComponent)this.txtBufferSize);
        manager.translate((AbstractButton)this.chkHighlightRecord);
        manager.translate((AbstractButton)this.btnSelectSymbol);
        manager.translate(this.lblAppySymbolTo);
        manager.translate((JComponent)this.cboApplySymbolTo);
    }

    public boolean doConfigureReportFromLayout(LayoutReportActionParameters params, LayoutDocument layout, FeatureStore source) {
        String identifier = params.getIdentifier();
        String label = params.getLabel();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (layout == null) {
            dialogs.messageDialog(i18n.getTranslation("_Layout_cant_be_null"), null, "_Configure_report_from_layout", 2);
            return false;
        }
        if (source == null) {
            dialogs.messageDialog(i18n.getTranslation("_Source_cant_be_null"), null, "_Configure_report_from_layout", 2);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)identifier)) {
            dialogs.messageDialog(i18n.getTranslation("_Identifier_cant_be_null"), null, "_Configure_report_from_layout", 2);
            return false;
        }
        boolean centerToCurrentRow = params.isCenterToCurrentRow();
        boolean zoomToCurrentRow = params.isZoomToCurrentRow();
        double bufferSize = params.getBufferSize();
        boolean highlightRecord = params.isHighlightRecord();
        ISymbol highlightSymbol = params.getHighlightSymbol(source);
        boolean applySymbolToRecord = params.isApplySymbolToRecord();
        boolean applySymbolToEverythingExceptRecord = params.isApplySymbolToEverythingExceptRecord();
        boolean useInternalPdfViewer = params.isUseInternalPdfViewer();
        String viewTag = params.getViewTag();
        return this.doConfigureReportFromLayout(source, layout, identifier, label, centerToCurrentRow, zoomToCurrentRow, bufferSize, highlightRecord, highlightSymbol, applySymbolToRecord, applySymbolToEverythingExceptRecord, viewTag, useInternalPdfViewer);
    }

    public boolean doConfigureReportFromLayout(FeatureStore store, LayoutDocument layout, String name, String label, boolean centerToCurrentRow, boolean zoomToCurrentRow, double bufferSize, boolean highlightRecord, ISymbol highlightSymbol, boolean applySymbolToRecord, boolean applySymbolToEverythingExceptRecord, String viewTag, boolean useInternalPdfViewer) {
        try {
            LayoutReportActionParameters reportParameters = LayoutReportActionParameters.create();
            reportParameters.setIdentifier(name);
            reportParameters.setLabel(label);
            reportParameters.setHighlightSymbol(highlightSymbol);
            reportParameters.setCenterToCurrentRow(centerToCurrentRow);
            reportParameters.setZoomToCurrentRow(zoomToCurrentRow);
            reportParameters.setBufferSize(bufferSize);
            reportParameters.setHighlightRecord(highlightRecord);
            reportParameters.setApplySymbolToRecord(applySymbolToRecord);
            reportParameters.setApplySymbolToEverythingExceptRecord(applySymbolToEverythingExceptRecord);
            reportParameters.setViewTag(viewTag);
            reportParameters.setUseInternalPdfViewer(useInternalPdfViewer);
            reportParameters.save(store, layout);
            ((JComponent)this.dialog).setVisible(false);
            return true;
        }
        catch (Exception ex) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_configure_report_from_layout"), null, "_Configure_report_from_layout", 2);
            return false;
        }
    }

    private void doChangeReport() {
        LayoutReportAction report = this.getReportAction();
        if (report == null) {
            this.txtIdentifier.setText("");
            this.txtLabel.setText("");
        } else {
            this.txtIdentifier.setText(report.getReportName());
            this.txtLabel.setText(report.getReportLabel());
            LayoutReportActionParameters reportParameters = report.getParameters();
            this.chkCenterToCurrentRow.setSelected(reportParameters.isCenterToCurrentRow());
            this.chkZoomToCurrentRow.setSelected(report.getParameters().isZoomToCurrentRow());
            PositiveDoubleDocumentFilter.setValue((JTextField)this.txtBufferSize, (double)report.getParameters().getBufferSize());
            this.chkHighlightRecord.setSelected(report.getParameters().isHighlightRecord());
            this.highlightSymbol = report.getParameters().getHighlightSymbol(this.source);
            ListElement.setSelected((JComboBox)this.cboView, (Object)report.getParameters().getViewTag());
            this.chkUseInternalPdfViewer.setSelected(report.getParameters().isUseInternalPdfViewer());
            DefaultComboBoxModel modelApplyTo = (DefaultComboBoxModel)this.cboApplySymbolTo.getModel();
            if (reportParameters.isApplySymbolToRecord()) {
                this.selectApplyTo(1);
            } else if (reportParameters.isApplySymbolToEverythingExceptRecord()) {
                this.selectApplyTo(2);
            }
            this.symbolPicker.set((Object)this.highlightSymbol);
        }
        this.doUpdateComponents();
    }

    private void selectApplyTo(int value) {
        DefaultComboBoxModel modelApplyTo = (DefaultComboBoxModel)this.cboApplySymbolTo.getModel();
        for (int i = 0; i < modelApplyTo.getSize(); ++i) {
            LabeledValue element = (LabeledValue)modelApplyTo.getElementAt(i);
            if (!element.getValue().equals(value)) continue;
            modelApplyTo.setSelectedItem(element);
        }
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public FeatureStore getStore() {
        return this.source;
    }
}

