/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.util.Iterator;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.layout.DefaultLayoutContext;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultLayoutDocument
extends AbstractDocument
implements LayoutDocument {
    private static final long serialVersionUID = 7320640550072493414L;
    public static final String PERSISTENCE_DEFINITION_NAME = "DefaultLayoutDocument";
    static final String LAYOUT_CONTEXT_OBJECT = "layoutContext";
    private LayoutContext layoutContext = new DefaultLayoutContext();
    private boolean persistIndependent;

    public DefaultLayoutDocument(DocumentManager factory) {
        super(factory);
    }

    public DefaultLayoutDocument() {
        this(null);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.layoutContext = (LayoutContext)state.get(LAYOUT_CONTEXT_OBJECT);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(LAYOUT_CONTEXT_OBJECT, (Persistent)this.layoutContext);
    }

    @Override
    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    @Override
    public Iterator deepiterator() {
        return this.layoutContext.deepiterator();
    }

    @Override
    public Iterator iterator() {
        return this.layoutContext.iterator();
    }

    @Override
    public void setPersistIndependent(boolean b) {
        this.persistIndependent = b;
        for (IFFrame frame : this.layoutContext.getAllFFrames()) {
            if (!(frame instanceof FFrameView)) continue;
            FFrameView view = (FFrameView)frame;
            view.setPersistIndependent(b);
        }
    }

    @Override
    public boolean isPersistIndependent() {
        return this.persistIndependent;
    }
}

