/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.geom.AffineTransform;
import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.AbstractDocumentManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentAction;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.actions.CopyDocumentAction;
import org.gvsig.app.project.documents.actions.CutDocumentAction;
import org.gvsig.app.project.documents.actions.PasteDocumentAction;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.app.project.documents.layout.DefaultLayoutContext;
import org.gvsig.app.project.documents.layout.DefaultLayoutDocument;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.contextmenu.gui.AbstractLayoutContextMenuAction;
import org.gvsig.app.project.documents.layout.fframes.FrameFactory;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFramePanel;
import org.gvsig.app.project.documents.layout.gui.DefaultLayoutPanel;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.gui.LayoutPanelImpl;
import org.gvsig.app.project.documents.layout.gui.MapProperties;
import org.gvsig.app.project.documents.view.IContextMenuAction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.utils.XMLEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayoutManager
extends AbstractDocumentManager
implements LayoutManager {
    static final Logger LOG = LoggerFactory.getLogger(DefaultLayoutManager.class);
    static final String KEY_LAYOUT_FFRAMEDIALOG = "app.project.documents.layout.fframes.gui";
    static final String KEY_LAYOUT_FFRAME = "app.project.documents.layout.fframes";
    public static final String PERSISTENCE_LAYOUT_DOCUMENT_DEFINITION_NAME = "LayoutDocument";
    private static final String LAYOUT_CONTEXT_MENUS = "Layout_ContextMenus";
    ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
    private Boolean defaultShowGrid = null;
    private Boolean defaultAdjustToGrid = null;
    private Boolean defaultShowRulers = null;
    private DynStruct persistenceDefinition;

    public ImageIcon getIcon() {
        return ToolsSwingLocator.getIconThemeManager().getCurrent().get("document-map-icon");
    }

    public ImageIcon getIconSelected() {
        return ToolsSwingLocator.getIconThemeManager().getCurrent().get("document-map-icon-sel");
    }

    public String getTypeName() {
        return "project.document.layout";
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"Mapa");
    }

    public AbstractDocument createDocument() {
        return new DefaultLayoutDocument(this);
    }

    public Class getMainWindowClass() {
        return LayoutPanelImpl.class;
    }

    public IWindow getMainWindow(Document doc, WindowLayout layout) {
        LayoutPanel layoutPanel = (LayoutPanel)super.getMainWindow(doc, layout);
        if (layoutPanel == null) {
            layoutPanel = (LayoutPanel)this.createDocumentWindow(doc);
            if (layout != null) {
                layoutPanel.setWindowLayout(layout);
                layoutPanel.setLayoutManager(this);
                layoutPanel.getLayoutControl().fullRect();
                layoutPanel.getWindowInfo().setTitle(PluginServices.getText((Object)this, (String)"Mapa") + " : " + layoutPanel.getName());
            }
        }
        ((AbstractDocument)doc).raiseEventCreateWindow((IWindow)layoutPanel);
        return layoutPanel;
    }

    @Override
    public IFFramePanel createFFrameDialog(IFFrame fframe, LayoutPanel layoutPanel, AffineTransform affineTransform) {
        ExtensionPoint ep = this.extensionPoints.add(KEY_LAYOUT_FFRAMEDIALOG);
        try {
            Object[] args = new Object[]{layoutPanel, fframe};
            Object obj = ep.create(fframe.getName(), args);
            if (obj != null) {
                IFFramePanel fframedialog = (IFFramePanel)obj;
                fframedialog.setRectangle(fframe.getBoundingBox(affineTransform));
                return fframedialog;
            }
        }
        catch (Exception e) {
            LOG.error("Error creating a FFrameDialog", (Throwable)e);
        }
        return null;
    }

    @Override
    public IFFramePanel createFFrameDialog(IFFrame fframe, LayoutPanel layoutPanel) {
        return this.createFFrameDialog(fframe, layoutPanel, layoutPanel.getLayoutControl().getAT());
    }

    @Override
    public void registerFrameFactory(FrameFactory frameFactory, String alias) {
        ExtensionPoint ep = ToolsLocator.getExtensionPointManager().add(KEY_LAYOUT_FFRAME);
        ep.append(frameFactory.getRegisterName(), "", (ExtensionBuilder)frameFactory);
        if (alias != null) {
            ep.addAlias(frameFactory.getRegisterName(), alias);
        }
    }

    @Override
    public void registerFrameFactory(FrameFactory frameFactory) {
        this.registerFrameFactory(frameFactory, null);
    }

    @Override
    public IFFrame createFrame(String frameName) {
        Iterator iterator = ToolsLocator.getExtensionPointManager().get(KEY_LAYOUT_FFRAME).iterator();
        while (iterator.hasNext()) {
            try {
                FrameFactory frameFactory = (FrameFactory)((ExtensionPoint.Extension)iterator.next()).create();
                if (!frameFactory.getRegisterName().equals(frameName)) continue;
                IFFrame frame = frameFactory.createFrame();
                if (frame == null) {
                    return null;
                }
                frame.setFrameFactory(frameFactory);
                return frame;
            }
            catch (Exception e) {
                NotificationManager.addError((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void registerFFrameDialog(String name, Class clazz) {
        if (!IFFramePanel.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " must implement the IFFrameDialog interface");
        }
        ExtensionPoint extensionPoint = this.extensionPoints.add(KEY_LAYOUT_FFRAMEDIALOG, "");
        extensionPoint.append(name, name, clazz);
    }

    public IWindow getPropertiesWindow(Document doc) {
        IWindow win = super.getPropertiesWindow(doc);
        if (win == null) {
            win = new MapProperties((LayoutDocument)doc);
        }
        return win;
    }

    public static void register() {
        DefaultLayoutManager factory = new DefaultLayoutManager();
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        manager.registerFactory((PersistenceFactory)factory);
        ProjectManager.getInstance().registerDocumentFactory((DocumentManager)factory);
        ProjectManager.getInstance().registerDocumentAction("project.document.layout", (DocumentAction)new CopyDocumentAction());
        ProjectManager.getInstance().registerDocumentAction("project.document.layout", (DocumentAction)new CutDocumentAction());
        ProjectManager.getInstance().registerDocumentAction("project.document.layout", (DocumentAction)new PasteDocumentAction());
        if (factory.persistenceDefinition == null) {
            factory.persistenceDefinition = manager.addDefinition(LayoutDocument.class, PERSISTENCE_LAYOUT_DOCUMENT_DEFINITION_NAME, "Layout document Persistence definition", null, null);
            factory.persistenceDefinition.extend(manager.getDefinition("AbstractDocument"));
            factory.persistenceDefinition.addDynFieldObject("layoutContext").setClassOfValue(LayoutContext.class).setMandatory(false);
            DefaultLayoutPanel.registerPersistent();
            DefaultLayoutContext.registerPersistent();
        }
    }

    public int getPriority() {
        return 2;
    }

    public void setDefaultShowGrid(boolean showGrid) {
        this.defaultShowGrid = showGrid;
    }

    public void setDefaultAdjustToGrid(boolean gridEnabled) {
        this.defaultAdjustToGrid = gridEnabled;
    }

    public void setDefaultShowRulers(boolean showRules) {
        this.defaultShowRulers = showRules;
    }

    public boolean getDefaultShowGrid() {
        if (this.defaultShowGrid == null) {
            XMLEntity xml = PluginsLocator.getManager().getPlugin((Object)this).getPersistentXML();
            this.defaultShowGrid = xml.contains("DefaultShowLayoutGrid") ? Boolean.valueOf(xml.getBooleanProperty("DefaultShowLayoutGrid")) : Boolean.valueOf(true);
        }
        return this.defaultShowGrid;
    }

    public boolean getDefaultAdjustToGrid() {
        if (this.defaultAdjustToGrid == null) {
            XMLEntity xml = PluginsLocator.getManager().getPlugin((Object)this).getPersistentXML();
            this.defaultAdjustToGrid = xml.contains("DefaultEnableLayoutGrid") ? Boolean.valueOf(xml.getBooleanProperty("DefaultEnableLayoutGrid")) : Boolean.valueOf(false);
        }
        return this.defaultAdjustToGrid;
    }

    public boolean getDefaultShowRulers() {
        if (this.defaultShowRulers == null) {
            XMLEntity xml = PluginsLocator.getManager().getPlugin((Object)this).getPersistentXML();
            this.defaultShowRulers = xml.contains("DefaultShowLayoutRules") ? Boolean.valueOf(xml.getBooleanProperty("DefaultShowLayoutRules")) : Boolean.valueOf(true);
        }
        return this.defaultShowRulers;
    }

    public boolean getDefaultShowInitialPageConfigDialog() {
        XMLEntity xml = PluginsLocator.getManager().getPlugin((Object)this).getPersistentXML();
        boolean value = xml.contains("DefaulShowInitialPageConfigLayout") ? xml.getBooleanProperty("DefaulShowInitialPageConfigLayout") : true;
        return value;
    }

    public DynStruct getDefinition(String className) {
        if (this.persistenceDefinition.getName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.persistenceDefinition.getFullName().equalsIgnoreCase(className)) {
            return this.persistenceDefinition;
        }
        if (this.getDocumentClass().getName().equals(className)) {
            return this.persistenceDefinition;
        }
        return null;
    }

    protected Class getDocumentClass() {
        return DefaultLayoutDocument.class;
    }

    public boolean manages(Object object) {
        return object instanceof LayoutDocument;
    }

    @Override
    public void registerLayoutMenuAction(String name, Class<? extends IContextMenuAction> clazz) {
        ExtensionPoint extensionPoint = ToolsLocator.getExtensionPointManager().add(LAYOUT_CONTEXT_MENUS);
        extensionPoint.append(name, "", clazz);
    }

    @Override
    public IContextMenuAction[] createLayoutMenuActions(LayoutPanel layoutPanel) {
        ArrayList<AbstractLayoutContextMenuAction> actionArrayList = new ArrayList<AbstractLayoutContextMenuAction>();
        Iterator iter = ToolsLocator.getExtensionPointManager().get(LAYOUT_CONTEXT_MENUS).iterator();
        while (iter.hasNext()) {
            AbstractLayoutContextMenuAction action = null;
            try {
                action = (AbstractLayoutContextMenuAction)((Object)((ExtensionPoint.Extension)iter.next()).create());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Error creating the context menu", (Throwable)e);
            }
            if (action == null) continue;
            action.setLayout(layoutPanel);
            if (!action.isVisible(null, layoutPanel.getLayoutContext().getSelectedFFrames())) continue;
            actionArrayList.add(action);
        }
        IContextMenuAction[] result = (IContextMenuAction[])Array.newInstance(IContextMenuAction.class, actionArrayList.size());
        System.arraycopy(actionArrayList.toArray(), 0, result, 0, actionArrayList.size());
        Arrays.sort(result, new CompareAction());
        return result;
    }

    private class CompareAction
    implements Comparator<IContextMenuAction> {
        private CompareAction() {
        }

        @Override
        public int compare(IContextMenuAction o1, IContextMenuAction o2) {
            NumberFormat formater = NumberFormat.getInstance();
            formater.setMinimumIntegerDigits(3);
            String key1 = "" + formater.format(o1.getGroupOrder()) + o1.getGroup() + formater.format(o1.getOrder());
            String key2 = "" + formater.format(o2.getGroupOrder()) + o2.getGroup() + formater.format(o2.getOrder());
            return key1.compareTo(key2);
        }
    }
}

