/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.app.project.documents.layout.FLayoutFunctions;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.compat.CompatLocator;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLayoutZooms
implements Observable {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FLayoutZooms.class);
    private LayoutPanel layout = null;
    private ObservableHelper observers;

    public FLayoutZooms(LayoutPanel layoutPanel) {
        this.layout = layoutPanel;
        this.observers = new ObservableHelper();
        this.observers.addObserver((Observer)layoutPanel.getLayoutControl());
    }

    public void setZoomIn(Point p1, Point p2) {
        if (Math.abs(this.layout.getLayoutControl().getFirstPoint().x - p2.x) < 4) {
            double difw = 2.0;
            this.setZoom(difw, p2);
        } else {
            double ymin;
            double xmax;
            double xmin;
            int aux;
            if (p1.getX() > p2.getX()) {
                aux = p2.x;
                p2.x = p1.x;
                p1.x = aux;
            }
            if (p1.getY() > p2.getY()) {
                aux = p2.y;
                p2.y = p1.y;
                p1.y = aux;
            }
            Point2D.Double pSheet1 = FLayoutUtilities.toSheetPoint(new Point2D.Double(p1.getX(), p1.getY()), this.layout.getLayoutControl().getAT());
            Point2D.Double pSheet2 = FLayoutUtilities.toSheetPoint(new Point2D.Double(p2.getX(), p2.getY()), this.layout.getLayoutControl().getAT());
            double ymax = 0.0;
            if (pSheet1.x > pSheet2.x) {
                xmin = pSheet2.x;
                xmax = pSheet1.x;
            } else {
                xmin = pSheet1.x;
                xmax = pSheet2.x;
            }
            if (pSheet1.y > pSheet2.y) {
                ymin = pSheet2.y;
                ymax = pSheet1.y;
            } else {
                ymin = pSheet1.y;
                ymax = pSheet2.y;
            }
            Rectangle2D.Double rScreen = new Rectangle2D.Double();
            Rectangle2D.Double rSheet = new Rectangle2D.Double();
            double x = FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getX(), this.layout.getLayoutControl().getAT());
            double y = FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getY(), this.layout.getLayoutControl().getAT());
            double w = FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getWidth(), this.layout.getLayoutControl().getAT());
            double h = FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getHeight(), this.layout.getLayoutControl().getAT());
            double wv = FLayoutUtilities.toSheetDistance(this.layout.getVisibleRect().getWidth(), this.layout.getLayoutControl().getAT());
            double hv = FLayoutUtilities.toSheetDistance(this.layout.getVisibleRect().getHeight(), this.layout.getLayoutControl().getAT());
            double mw = xmax - xmin;
            double mh = ymax - ymin;
            double difw = wv / mw;
            double difh = hv / mh;
            if (difw < difh) {
                rSheet.x = -xmin * difw - x + (wv - (pSheet2.getX() - pSheet1.getX()) * difw) / 2.0;
                rSheet.y = -ymin * difw - y + (hv - (pSheet2.getY() - pSheet1.getY()) * difw) / 2.0;
                rSheet.width = w * difw;
                rSheet.height = h * difw;
            } else {
                rSheet.x = -xmin * difh - x + (wv - (pSheet2.getX() - pSheet1.getX()) * difh) / 2.0;
                rSheet.y = -ymin * difh - y + (hv - (pSheet2.getY() - pSheet1.getY()) * difh) / 2.0;
                rSheet.width = w * difh;
                rSheet.height = h * difh;
            }
            this.setPointsToZoom(p1, p2);
            rScreen.setRect(FLayoutUtilities.fromSheetRect(rSheet, this.layout.getLayoutControl().getAT()));
            if (FLayoutUtilities.isPosible(rScreen)) {
                this.layout.getLayoutControl().setRect(rScreen);
            }
        }
    }

    public void setZoomOut(Point p2) {
        double difw = 0.5;
        this.setZoom(difw, p2);
    }

    public void setZoom(double dif, Point p2) {
        Point2D.Double pSheet2 = FLayoutUtilities.toSheetPoint(new Point2D.Double(p2.getX(), p2.getY()), this.layout.getLayoutControl().getAT());
        Rectangle2D.Double rScreen = new Rectangle2D.Double();
        Rectangle2D.Double rSheet = new Rectangle2D.Double();
        double difw = dif;
        rSheet.x = -pSheet2.getX() * difw - FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getX(), this.layout.getLayoutControl().getAT()) + FLayoutUtilities.toSheetDistance(this.layout.getWidth() / 2, this.layout.getLayoutControl().getAT());
        rSheet.y = -pSheet2.getY() * difw - FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getY(), this.layout.getLayoutControl().getAT()) + FLayoutUtilities.toSheetDistance(this.layout.getHeight() / 2, this.layout.getLayoutControl().getAT());
        rSheet.width = FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getWidth(), this.layout.getLayoutControl().getAT()) * difw;
        rSheet.height = FLayoutUtilities.toSheetDistance(this.layout.getLayoutControl().getRect().getHeight(), this.layout.getLayoutControl().getAT()) * difw;
        rScreen.setRect(FLayoutUtilities.fromSheetRect(rSheet, this.layout.getLayoutControl().getAT()));
        if (FLayoutUtilities.isPosible(rScreen)) {
            this.layout.getLayoutControl().setRect(rScreen);
        }
        Point p1 = new Point((int)(p2.getX() - (double)this.layout.getWidth() / (difw * 2.0)), (int)(p2.getY() - (double)this.layout.getHeight() / (difw * 2.0)));
        p2 = new Point((int)(p2.getX() + (double)this.layout.getWidth() / (difw * 2.0)), (int)(p2.getY() + (double)this.layout.getHeight() / (difw * 2.0)));
        this.setPointsToZoom(p1, p2);
    }

    private void setPointsToZoom(Point p1, Point p2) {
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            IFFrameUseFMap fframe;
            if (!(fframes[i] instanceof IFFrameUseFMap) || (fframe = (IFFrameUseFMap)fframes[i]).getATMap() == null) continue;
            Point2D vppo1 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(p1, fframes[i]);
            Point2D vppo2 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(p2, fframes[i]);
            Point2D.Double px1 = FLayoutFunctions.toMapPoint(vppo1, fframe.getATMap());
            Point2D.Double px2 = FLayoutFunctions.toMapPoint(vppo2, fframe.getATMap());
            fframe.setPointsToZoom(px1, px2);
        }
    }

    public void realZoom() {
        double cm = this.layout.getLayoutContext().getAttributes().getPixXCm(this.layout.getLayoutControl().getRect());
        double dpi = CompatLocator.getGraphicsUtils().getScreenDPI();
        double dif = cm * 2.54 / dpi;
        this.setZoom(1.0 / dif, new Point(this.layout.getWidth() / 2, this.layout.getHeight() / 2));
        this.layout.getLayoutControl().refresh();
    }

    public void zoomIn() {
        this.setZoom(2.0, new Point(this.layout.getWidth() / 2, this.layout.getHeight() / 2));
        this.layout.getLayoutControl().refresh();
    }

    public void zoomOut() {
        this.setZoom(0.5, new Point(this.layout.getWidth() / 2, this.layout.getHeight() / 2));
        this.layout.getLayoutControl().refresh();
    }

    public void zoomSelect() {
        Rectangle2D.Double recaux = null;
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            if (fframes[i].getSelected() == 0) continue;
            if (recaux == null) {
                recaux = fframes[i].getBoundingBox(this.layout.getLayoutControl().getAT());
                continue;
            }
            recaux.add(fframes[i].getBoundingBox(this.layout.getLayoutControl().getAT()));
        }
        if (recaux != null) {
            Point p1 = new Point((int)recaux.x, (int)recaux.y);
            Point p2 = new Point((int)recaux.getMaxX(), (int)recaux.getMaxY());
            this.setZoomIn(p1, p2);
            this.layout.getLayoutControl().refresh();
        }
    }

    public void zoomAllFrames() {
        Rectangle2D.Double recaux = null;
        IFFrame[] fframes = this.layout.getLayoutControl().getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            if (recaux == null) {
                recaux = fframes[i].getBoundingBox(this.layout.getLayoutControl().getAT());
                continue;
            }
            recaux.add(fframes[i].getBoundingBox(this.layout.getLayoutControl().getAT()));
        }
        if (recaux != null) {
            Point p1 = new Point((int)recaux.x, (int)recaux.y);
            Point p2 = new Point((int)recaux.getMaxX(), (int)recaux.getMaxY());
            this.setZoomIn(p1, p2);
            this.layout.getLayoutControl().refresh();
        }
    }

    public void setViewZoomIn(Point2D poi1, Point2D poi2) {
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            IFFrameUseFMap fframe;
            if (!(fframes[i] instanceof IFFrameUseFMap) || !(fframe = (IFFrameUseFMap)fframes[i]).isSelected() || fframe.getMapContext() == null) continue;
            Point2D vppo1 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(poi1, fframes[i]);
            Point2D vppo2 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(poi2, fframes[i]);
            Point2D.Double mapp1 = FLayoutFunctions.toMapPoint(vppo1, fframe.getATMap());
            Point2D.Double mapp2 = FLayoutFunctions.toMapPoint(vppo2, fframe.getATMap());
            Rectangle2D.Double r = new Rectangle2D.Double();
            if (Math.abs(poi1.getX() - poi2.getX()) <= 3.0) {
                double cX = mapp2.getX();
                double cY = mapp2.getY();
                double factor = 1.0 / MapContext.ZOOMINFACTOR;
                Rectangle2D extent = fframe.getMapContext().getViewPort().getExtent();
                if (extent != null) {
                    double nuevoX = cX - extent.getWidth() * factor / 2.0;
                    double nuevoY = cY - extent.getHeight() * factor / 2.0;
                    r.x = nuevoX;
                    r.y = nuevoY;
                    r.width = extent.getWidth() * factor;
                    r.height = extent.getHeight() * factor;
                }
            } else {
                r.setFrameFromDiagonal(mapp1, mapp2);
            }
            try {
                fframe.setNewEnvelope(geomManager.createEnvelope(r.getX(), r.getY(), r.getMaxX(), r.getMaxY(), 0));
                continue;
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
    }

    public void setViewZoomOut(Point p2) {
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            IFFrameUseFMap fframe;
            if (!(fframes[i] instanceof IFFrameUseFMap) || !(fframe = (IFFrameUseFMap)fframes[i]).isSelected() || fframe.getMapContext() == null) continue;
            Point pScreen = new Point((int)p2.getX(), (int)p2.getY());
            Point2D vppo1 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(pScreen, fframes[i]);
            Point2D.Double pWorld = FLayoutFunctions.toMapPoint(vppo1, fframe.getATMap());
            double cX = pWorld.getX();
            double cY = pWorld.getY();
            double factor = 1.0 / MapContext.ZOOMOUTFACTOR;
            Rectangle2D extent = fframe.getMapContext().getViewPort().getExtent();
            if (extent == null) continue;
            double nuevoX = cX - extent.getWidth() * factor / 2.0;
            double nuevoY = cY - extent.getHeight() * factor / 2.0;
            double x = nuevoX;
            double y = nuevoY;
            double width = extent.getWidth() * factor;
            double height = extent.getHeight() * factor;
            try {
                fframe.setNewEnvelope(geomManager.createEnvelope(x, y, x + width, y + height, 0));
                continue;
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
    }

    public void setPan(Point p1, Point p2) {
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = 0; i < fframes.length; ++i) {
            AffineTransform at;
            IFFrameUseFMap fframe;
            if (!(fframes[i] instanceof IFFrameUseFMap) || (fframe = (IFFrameUseFMap)fframes[i]).getMapContext() == null || (at = fframe.getATMap()) == null) continue;
            Point2D vppo1 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(p1, fframes[i]);
            Point2D vppo2 = FLayoutUtilities.screenCoordinatesToViewportImageCoordinates(p2, fframes[i]);
            Point2D.Double px1 = FLayoutFunctions.toMapPoint(vppo1, at);
            Point2D.Double px2 = FLayoutFunctions.toMapPoint(vppo2, at);
            fframe.movePoints(px1, px2);
        }
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }
}

