/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.i18n.Messages;
import org.slf4j.LoggerFactory;

public class EnvelopePanel
extends JPanel {
    private static final long serialVersionUID = -1828624765045725544L;
    private JTextField fldTop = null;
    private JTextField fldLeft = null;
    private JTextField fldRight = null;
    private JTextField fldBottom = null;
    private static final GeometryManager geoMgr = GeometryLocator.getGeometryManager();
    private int fieldWidth;
    private DecimalFormat formatLatLon = new DecimalFormat("0.######");
    private DecimalFormat formatMetres = new DecimalFormat("0.##");

    public EnvelopePanel() {
        this(8);
    }

    public EnvelopePanel(int fieldWidth) {
        super(new GridBagLayout());
        this.fieldWidth = fieldWidth;
        this.initComponents();
    }

    protected void initComponents() {
        int row = 0;
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = row++;
        c.gridx = 1;
        c.anchor = 22;
        c.insets = new Insets(0, 5, 5, 5);
        JLabel label = new JLabel(Messages.getText((String)"Top_extent_lbl"));
        this.add((Component)label, c);
        c.gridx = 2;
        c.anchor = 21;
        this.add((Component)this.getFldTop(), c);
        c.gridy = row++;
        c.gridx = 0;
        c.insets = new Insets(5, 0, 5, 5);
        c.anchor = 22;
        label = new JLabel(Messages.getText((String)"Left_extent_lbl"));
        this.add((Component)label, c);
        c.gridx = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 21;
        this.add((Component)this.getFldLeft(), c);
        c.gridx = 3;
        c.anchor = 22;
        label = new JLabel(Messages.getText((String)"Right_extent_lbl"));
        this.add((Component)label, c);
        c.gridx = 4;
        c.anchor = 21;
        c.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.getFldRight(), c);
        c.gridy = row++;
        c.gridx = 1;
        c.anchor = 22;
        label = new JLabel(Messages.getText((String)"Bottom_extent_lbl"));
        c.insets = new Insets(5, 5, 0, 5);
        this.add((Component)label, c);
        c.gridx = 2;
        c.anchor = 21;
        this.add((Component)this.getFldBottom(), c);
    }

    private JTextField getFldTop() {
        if (this.fldTop == null) {
            this.fldTop = new JTextField(this.fieldWidth);
        }
        return this.fldTop;
    }

    private JTextField getFldLeft() {
        if (this.fldLeft == null) {
            this.fldLeft = new JTextField(this.fieldWidth);
        }
        return this.fldLeft;
    }

    private JTextField getFldRight() {
        if (this.fldRight == null) {
            this.fldRight = new JTextField(this.fieldWidth);
        }
        return this.fldRight;
    }

    private JTextField getFldBottom() {
        if (this.fldBottom == null) {
            this.fldBottom = new JTextField(this.fieldWidth);
        }
        return this.fldBottom;
    }

    public Envelope getEnvelope() {
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        try {
            maxY = this.formatMetres.parse(this.getFldTop().getText()).doubleValue();
            maxX = this.formatMetres.parse(this.getFldRight().getText()).doubleValue();
            minY = this.formatMetres.parse(this.getFldBottom().getText()).doubleValue();
            minX = this.formatMetres.parse(this.getFldLeft().getText()).doubleValue();
        }
        catch (ParseException e1) {
            try {
                maxY = Double.parseDouble(this.getFldTop().getText().replaceAll(",", "."));
                maxX = Double.parseDouble(this.getFldRight().getText().replaceAll(",", "."));
                minY = Double.parseDouble(this.getFldBottom().getText().replaceAll(",", "."));
                minX = Double.parseDouble(this.getFldLeft().getText().replaceAll(",", "."));
            }
            catch (NumberFormatException e2) {
                LoggerFactory.getLogger(EnvelopePanel.class).error("Error parsing envelope", (Throwable)e1);
                return null;
            }
        }
        try {
            return geoMgr.createEnvelope(minX, minY, maxX, maxY, 0);
        }
        catch (CreateEnvelopeException e) {
            LoggerFactory.getLogger(EnvelopePanel.class).error("Error creating envelope", (Throwable)e);
            return null;
        }
    }

    public void setEnvelope(Envelope envelope) {
        double top = envelope.getMaximum(1);
        double left = envelope.getMinimum(0);
        double right = envelope.getMaximum(0);
        double bottom = envelope.getMinimum(1);
        DecimalFormat format = top > Math.abs(90.0) || left > Math.abs(180.0) || right > Math.abs(180.0) || bottom > Math.abs(90.0) ? this.formatMetres : this.formatLatLon;
        String topStr = format.format(top);
        this.getFldTop().setText(topStr);
        String leftStr = format.format(left);
        this.getFldLeft().setText(leftStr);
        String rightStr = format.format(right);
        this.getFldRight().setText(rightStr);
        String bottomStr = format.format(bottom);
        this.getFldBottom().setText(bottomStr);
    }

    public void setEditable(boolean editable) {
        this.getFldTop().setEditable(editable);
        this.getFldLeft().setEditable(editable);
        this.getFldRight().setEditable(editable);
        this.getFldBottom().setEditable(editable);
    }
}

