/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.Attributes;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.Size;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.ListViewModel;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;

public class FConfigLayoutDialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -425263925680280142L;
    private JLabel lTamPag = null;
    private JComboBox cbTipoFolio = null;
    private JComboBox cbUnidades = null;
    private JLabel lAnchura = null;
    private JLabel lAltura = null;
    private JTextField tAncho = null;
    private JTextField tAlto = null;
    private JLabel lOrientacion = null;
    private JLabel lMargenes = null;
    private JCheckBox chbMargenes = null;
    private JLabel lSuperior = null;
    private JTextField tSuperior = null;
    private JLabel lIzquierdo = null;
    private JTextField tIzquierdo = null;
    private JLabel lInferior = null;
    private JTextField tInferior = null;
    private JLabel lDerecho = null;
    private JTextField tDerecho = null;
    private JLabel lResolucion = null;
    private JComboBox cbResolucion = null;
    protected LayoutPanel m_layout = null;
    private JPanel pOrientation = null;
    private JRadioButton rbHorizontal = null;
    private JRadioButton rbVertical = null;
    private int unit = 2;
    private int type = 0;
    private boolean isLand = true;
    private boolean margin = false;
    private int resolution = 1;
    private double der = 2.54;
    private double izq = 2.54;
    private double sup = 2.54;
    private double inf = 2.54;
    private NumberFormat nf = NumberFormat.getInstance();
    protected Attributes temporaryAttributes;
    private JList liViews = null;
    private boolean showViewList;
    private JCheckBox chbViews = null;
    private JButton btConfigView = null;
    private ViewDocument createdView = null;
    private JScrollPane jViewScrollPane = null;
    private WindowInfo windowInfo = null;
    private JLabel lblUnitsTop = null;
    private JLabel lblUnitsBottom = null;
    private JLabel lblUnitsLeft = null;
    private JLabel lblUnitsRight = null;
    private JPanel pnlMargin = null;
    private AcceptCancelPanel pnlAcceptCancel = null;

    public FConfigLayoutDialog(LayoutPanel layout) {
        this(layout, false);
    }

    public FConfigLayoutDialog(LayoutPanel layout, boolean showViewList) {
        this.m_layout = layout;
        this.temporaryAttributes = (Attributes)layout.getLayoutContext().getAttributes().clone();
        this.showViewList = showViewList;
        this.initialize();
    }

    private void initialize() {
        int row = 0;
        this.nf.setMaximumFractionDigits(2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.type = this.temporaryAttributes.getType();
        this.unit = this.temporaryAttributes.getUnit();
        this.isLand = this.temporaryAttributes.isLandscape();
        this.sup = this.temporaryAttributes.getAreaInsets()[0];
        this.inf = this.temporaryAttributes.getAreaInsets()[1];
        this.izq = this.temporaryAttributes.getAreaInsets()[2];
        this.der = this.temporaryAttributes.getAreaInsets()[3];
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        this.add((Component)this.getLTamPag(), c);
        c.gridx = -1;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.getCbTipoFolio(), c);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        c.fill = 0;
        this.add((Component)this.getLAnchura(), c);
        c.gridx = 1;
        this.add((Component)this.getTAncho(), c);
        c.gridx = 2;
        this.add((Component)this.getLAltura(), c);
        c.gridx = 3;
        this.add((Component)this.getTAlto(), c);
        c.gridx = 4;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)this.getCbUnidades(), c);
        c.gridx = 0;
        c.gridy = row++;
        c.gridwidth = 1;
        this.add((Component)this.getLOrientacion(), c);
        c.gridx = -1;
        c.gridwidth = 0;
        this.add((Component)this.getOrientationPanel(), c);
        c.gridy = row++;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)this.getLResolucion(), c);
        c.gridx = -1;
        c.gridwidth = 0;
        this.add((Component)this.getCbResolucion(), c);
        if (this.showViewList) {
            c.gridy = row++;
            c.gridx = 0;
            c.gridwidth = 1;
            this.add((Component)this.getChbViews(), c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.fill = 1;
            this.add((Component)this.getViewScrollPane(), c);
            c.weighty = 0.0;
            c.fill = 2;
            c.gridy = row++;
            c.gridx = 1;
            c.gridwidth = 1;
            this.add((Component)this.getBtConfigView(), c);
        }
        c.gridy = row++;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)this.getChbMargenes(), c);
        c.gridy = row++;
        c.gridx = 1;
        c.gridwidth = 0;
        this.add((Component)this.getPnlMargin(), c);
        c.gridy = row++;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)this.getPnlAcceptCancel(), c);
        if (!this.showViewList) {
            c.gridy = row++;
            c.gridx = 0;
            c.gridwidth = 0;
            c.weighty = 1.0;
            this.add((Component)new JLabel(""), c);
        }
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)16, (int)80, (int)24, (int)120);
    }

    public AcceptCancelPanel getPnlAcceptCancel() {
        if (this.pnlAcceptCancel == null) {
            this.pnlAcceptCancel = new AcceptCancelPanel((ActionListener)this, (ActionListener)this);
        }
        return this.pnlAcceptCancel;
    }

    private JPanel getPnlMargin() {
        if (this.pnlMargin == null) {
            this.pnlMargin = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            Insets leftInsets = new Insets(0, 0, 4, 4);
            Insets leftInsets2 = new Insets(0, 20, 4, 4);
            Insets rightInsets = new Insets(0, 4, 4, 0);
            Insets centerInsets = new Insets(0, 4, 4, 4);
            c.anchor = 21;
            c.fill = 0;
            int row = 0;
            c.gridy = row++;
            c.gridx = 0;
            c.insets = leftInsets;
            this.pnlMargin.add((Component)this.getLSuperior(), c);
            c.gridx = -1;
            c.insets = centerInsets;
            this.pnlMargin.add((Component)this.getTSuperior(), c);
            this.pnlMargin.add((Component)this.getLbUnitsTop(), c);
            c.insets = leftInsets2;
            this.pnlMargin.add((Component)this.getLIzquierdo(), c);
            c.insets = centerInsets;
            this.pnlMargin.add((Component)this.getTIzquierdo(), c);
            c.insets = rightInsets;
            this.pnlMargin.add((Component)this.getLbUnitsLeft(), c);
            leftInsets = new Insets(4, 0, 0, 4);
            leftInsets2 = new Insets(4, 20, 0, 4);
            rightInsets = new Insets(4, 4, 0, 0);
            centerInsets = new Insets(4, 4, 0, 4);
            c.gridy = row++;
            c.gridx = 0;
            c.insets = leftInsets;
            this.pnlMargin.add((Component)this.getLInferior(), c);
            c.insets = centerInsets;
            c.gridx = -1;
            this.pnlMargin.add((Component)this.getTInferior(), c);
            this.pnlMargin.add((Component)this.getLbUnitsBottom(), c);
            c.insets = leftInsets2;
            this.pnlMargin.add((Component)this.getLDerecho(), c);
            c.insets = centerInsets;
            this.pnlMargin.add((Component)this.getTDerecho(), c);
            c.insets = rightInsets;
            this.pnlMargin.add((Component)this.getLbUnitsRight(), c);
        }
        return this.pnlMargin;
    }

    private JLabel getLTamPag() {
        if (this.lTamPag == null) {
            this.lTamPag = new JLabel();
            this.lTamPag.setText(PluginServices.getText((Object)this, (String)"tamano_pagina"));
        }
        return this.lTamPag;
    }

    private JComboBox getCbTipoFolio() {
        if (this.cbTipoFolio == null) {
            this.cbTipoFolio = new JComboBox();
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"Igual_que_la_impresora"));
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"A4"));
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"A3"));
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"A2"));
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"A1"));
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"A0"));
            this.cbTipoFolio.addItem(PluginServices.getText((Object)this, (String)"Personalizado"));
            this.cbTipoFolio.setSelectedIndex(this.m_layout.getLayoutContext().getAttributes().getType());
            this.cbTipoFolio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FConfigLayoutDialog.this.type = FConfigLayoutDialog.this.cbTipoFolio.getSelectedIndex();
                    FConfigLayoutDialog.this.temporaryAttributes.setType(FConfigLayoutDialog.this.type);
                    Size size = FConfigLayoutDialog.this.temporaryAttributes.getPaperSizeInUnits();
                    FConfigLayoutDialog.this.getTAlto().setText(String.valueOf(FConfigLayoutDialog.this.nf.format(size.getHeight())));
                    FConfigLayoutDialog.this.getTAncho().setText(String.valueOf(FConfigLayoutDialog.this.nf.format(size.getWidth())));
                    FConfigLayoutDialog.this.setMargin(FConfigLayoutDialog.this.margin);
                    if (FConfigLayoutDialog.this.cbTipoFolio.getSelectedItem().equals(PluginServices.getText((Object)this, (String)"Personalizado"))) {
                        FConfigLayoutDialog.this.getTAlto().setEnabled(true);
                        FConfigLayoutDialog.this.getTAncho().setEnabled(true);
                        FConfigLayoutDialog.this.getRbVertical().setSelected(true);
                        FConfigLayoutDialog.this.isLand = false;
                        FConfigLayoutDialog.this.getRbVertical().setEnabled(false);
                        FConfigLayoutDialog.this.getRbHorizontal().setEnabled(false);
                    } else {
                        FConfigLayoutDialog.this.getTAlto().setEnabled(false);
                        FConfigLayoutDialog.this.getTAncho().setEnabled(false);
                        FConfigLayoutDialog.this.getRbVertical().setEnabled(true);
                        FConfigLayoutDialog.this.getRbHorizontal().setEnabled(true);
                    }
                }
            });
        }
        return this.cbTipoFolio;
    }

    private JComboBox getCbUnidades() {
        if (this.cbUnidades == null) {
            this.cbUnidades = new JComboBox();
            String[] names = MapContext.getDistanceNames();
            for (int i = 0; i < names.length; ++i) {
                this.cbUnidades.addItem(PluginServices.getText((Object)this, (String)names[i]));
            }
            this.cbUnidades.setSelectedIndex(this.m_layout.getLayoutContext().getAttributes().getUnit());
            this.cbUnidades.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FConfigLayoutDialog.this.onUnitsChange();
                }
            });
        }
        return this.cbUnidades;
    }

    protected void onUnitsChange() {
        this.unit = this.cbUnidades.getSelectedIndex();
        this.temporaryAttributes.setUnit(this.unit);
        Size size = this.temporaryAttributes.getPaperSizeInUnits();
        this.getTAlto().setText(String.valueOf(this.nf.format(size.getWidth())));
        this.getTAncho().setText(String.valueOf(this.nf.format(size.getHeight())));
        String units = Messages.getText((String)MapContext.getDistanceAbbr()[this.getCbUnidades().getSelectedIndex()]);
        this.getLbUnitsTop().setText(units);
        this.getLbUnitsBottom().setText(units);
        this.getLbUnitsLeft().setText(units);
        this.getLbUnitsRight().setText(units);
        this.setMargin(this.margin);
    }

    private JLabel getLAnchura() {
        if (this.lAnchura == null) {
            this.lAnchura = new JLabel();
            this.lAnchura.setText(PluginServices.getText((Object)this, (String)"anchura"));
        }
        return this.lAnchura;
    }

    private JLabel getLAltura() {
        if (this.lAltura == null) {
            this.lAltura = new JLabel();
            this.lAltura.setText(PluginServices.getText((Object)this, (String)"altura"));
        }
        return this.lAltura;
    }

    private JTextField getTAncho() {
        if (this.tAncho == null) {
            this.tAncho = new JTextField(4);
            Size size = this.temporaryAttributes.getPaperSizeInUnits();
            String s = String.valueOf(this.nf.format(size.getWidth()));
            this.tAncho.setText(s);
            if (this.getCbTipoFolio().getSelectedItem().equals(PluginServices.getText((Object)this, (String)"Personalizado"))) {
                this.tAncho.setEnabled(true);
            } else {
                this.tAncho.setEnabled(false);
            }
        }
        return this.tAncho;
    }

    private JTextField getTAlto() {
        if (this.tAlto == null) {
            this.tAlto = new JTextField(4);
            Size size = this.temporaryAttributes.getPaperSizeInUnits();
            String s = String.valueOf(this.nf.format(size.getHeight()));
            this.tAlto.setText(s);
            if (this.getCbTipoFolio().getSelectedItem().equals(PluginServices.getText((Object)this, (String)"Personalizado"))) {
                this.tAlto.setEnabled(true);
            } else {
                this.tAlto.setEnabled(false);
            }
        }
        return this.tAlto;
    }

    private JLabel getLOrientacion() {
        if (this.lOrientacion == null) {
            this.lOrientacion = new JLabel();
            this.lOrientacion.setText(PluginServices.getText((Object)this, (String)"orientacion"));
        }
        return this.lOrientacion;
    }

    private JLabel getLMargenes() {
        if (this.lMargenes == null) {
            this.lMargenes = new JLabel();
            this.lMargenes.setText(PluginServices.getText((Object)this, (String)"margenes"));
        }
        return this.lMargenes;
    }

    private void setMargin(boolean b) {
        this.margin = b;
        if (b) {
            this.getTSuperior().setText(String.valueOf(this.nf.format(this.temporaryAttributes.toUnits(this.sup))));
            this.getTIzquierdo().setText(String.valueOf(this.nf.format(this.temporaryAttributes.toUnits(this.izq))));
            this.getTInferior().setText(String.valueOf(this.nf.format(this.temporaryAttributes.toUnits(this.inf))));
            this.getTDerecho().setText(String.valueOf(this.nf.format(this.temporaryAttributes.toUnits(this.der))));
            this.getTSuperior().setEnabled(true);
            this.getTIzquierdo().setEnabled(true);
            this.getTInferior().setEnabled(true);
            this.getTDerecho().setEnabled(true);
        } else {
            this.getTSuperior().setText("");
            this.getTIzquierdo().setText("");
            this.getTInferior().setText("");
            this.getTDerecho().setText("");
            this.getTSuperior().setEnabled(false);
            this.getTIzquierdo().setEnabled(false);
            this.getTInferior().setEnabled(false);
            this.getTDerecho().setEnabled(false);
        }
    }

    private JCheckBox getChbMargenes() {
        if (this.chbMargenes == null) {
            this.chbMargenes = new JCheckBox();
            this.chbMargenes.setText(PluginServices.getText((Object)this, (String)"personalizar_margenes"));
            this.chbMargenes.setSelected(this.temporaryAttributes.isMargin());
            this.setMargin(this.temporaryAttributes.isMargin());
            this.chbMargenes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FConfigLayoutDialog.this.chbMargenes.isSelected()) {
                        FConfigLayoutDialog.this.margin = true;
                    } else {
                        FConfigLayoutDialog.this.margin = false;
                    }
                    FConfigLayoutDialog.this.setMargin(FConfigLayoutDialog.this.margin);
                }
            });
        }
        return this.chbMargenes;
    }

    private JLabel getLSuperior() {
        if (this.lSuperior == null) {
            this.lSuperior = new JLabel();
            this.lSuperior.setText(PluginServices.getText((Object)this, (String)"Superior"));
        }
        return this.lSuperior;
    }

    private JTextField getTSuperior() {
        if (this.tSuperior == null) {
            this.tSuperior = new JTextField(4);
            if (this.m_layout.getLayoutContext().getAttributes().isMargin()) {
                this.tSuperior.setText(String.valueOf(this.nf.format(this.m_layout.getLayoutContext().getAttributes().toUnits(this.sup))));
            }
        }
        return this.tSuperior;
    }

    private JLabel getLIzquierdo() {
        if (this.lIzquierdo == null) {
            this.lIzquierdo = new JLabel();
            this.lIzquierdo.setText(PluginServices.getText((Object)this, (String)"Izquierdo"));
        }
        return this.lIzquierdo;
    }

    private JTextField getTIzquierdo() {
        if (this.tIzquierdo == null) {
            this.tIzquierdo = new JTextField(4);
            if (this.m_layout.getLayoutContext().getAttributes().isMargin()) {
                this.tIzquierdo.setText(String.valueOf(this.nf.format(this.m_layout.getLayoutContext().getAttributes().toUnits(this.izq))));
            }
        }
        return this.tIzquierdo;
    }

    private JLabel getLInferior() {
        if (this.lInferior == null) {
            this.lInferior = new JLabel();
            this.lInferior.setText(PluginServices.getText((Object)this, (String)"Inferior"));
        }
        return this.lInferior;
    }

    private JTextField getTInferior() {
        if (this.tInferior == null) {
            this.tInferior = new JTextField(4);
            if (this.m_layout.getLayoutContext().getAttributes().isMargin()) {
                this.tInferior.setText(String.valueOf(this.nf.format(this.m_layout.getLayoutContext().getAttributes().toUnits(this.inf))));
            }
        }
        return this.tInferior;
    }

    private JLabel getLDerecho() {
        if (this.lDerecho == null) {
            this.lDerecho = new JLabel();
            this.lDerecho.setText(PluginServices.getText((Object)this, (String)"Derecho"));
        }
        return this.lDerecho;
    }

    private JTextField getTDerecho() {
        if (this.tDerecho == null) {
            this.tDerecho = new JTextField(4);
            if (this.m_layout.getLayoutContext().getAttributes().isMargin()) {
                this.tDerecho.setText(String.valueOf(this.nf.format(this.m_layout.getLayoutContext().getAttributes().toUnits(this.der))));
            }
        }
        return this.tDerecho;
    }

    private JLabel getLbUnitsTop() {
        if (this.lblUnitsTop == null) {
            String unit = Messages.getText((String)MapContext.getDistanceAbbr()[this.getCbUnidades().getSelectedIndex()]);
            this.lblUnitsTop = new JLabel(unit);
        }
        return this.lblUnitsTop;
    }

    private JLabel getLbUnitsBottom() {
        if (this.lblUnitsBottom == null) {
            String unit = Messages.getText((String)MapContext.getDistanceAbbr()[this.getCbUnidades().getSelectedIndex()]);
            this.lblUnitsBottom = new JLabel(unit);
        }
        return this.lblUnitsBottom;
    }

    private JLabel getLbUnitsLeft() {
        if (this.lblUnitsLeft == null) {
            String unit = Messages.getText((String)MapContext.getDistanceAbbr()[this.getCbUnidades().getSelectedIndex()]);
            this.lblUnitsLeft = new JLabel(unit);
        }
        return this.lblUnitsLeft;
    }

    private JLabel getLbUnitsRight() {
        if (this.lblUnitsRight == null) {
            String unit = Messages.getText((String)MapContext.getDistanceAbbr()[this.getCbUnidades().getSelectedIndex()]);
            this.lblUnitsRight = new JLabel(unit);
        }
        return this.lblUnitsRight;
    }

    private JLabel getLResolucion() {
        if (this.lResolucion == null) {
            this.lResolucion = new JLabel();
            this.lResolucion.setText(PluginServices.getText((Object)this, (String)"resolucion_resultado"));
        }
        return this.lResolucion;
    }

    private JComboBox getCbResolucion() {
        if (this.cbResolucion == null) {
            this.cbResolucion = new JComboBox();
            this.cbResolucion.addItem(PluginServices.getText((Object)this, (String)"High_600_dpi"));
            this.cbResolucion.addItem(PluginServices.getText((Object)this, (String)"Normal_300_dpi"));
            this.cbResolucion.addItem(PluginServices.getText((Object)this, (String)"Low_72_dpi"));
            this.cbResolucion.setSelectedIndex(this.m_layout.getLayoutContext().getAttributes().getResolution());
            this.cbResolucion.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FConfigLayoutDialog.this.resolution = FConfigLayoutDialog.this.cbResolucion.getSelectedIndex();
                    FConfigLayoutDialog.this.temporaryAttributes.setResolution(FConfigLayoutDialog.this.resolution);
                }
            });
        }
        return this.cbResolucion;
    }

    public void addOkButtonActionListener(ActionListener l) {
        this.getPnlAcceptCancel().addOkButtonActionListener(l);
    }

    public void addCancelButtonActionListener(ActionListener l) {
        this.getPnlAcceptCancel().addCancelButtonActionListener(l);
    }

    private JPanel getOrientationPanel() {
        if (this.pOrientation == null) {
            this.pOrientation = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(0, 0, 0, 10);
            this.pOrientation.add((Component)this.getRbHorizontal(), c);
            c.gridx = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 1.0;
            c.fill = 2;
            this.pOrientation.add((Component)this.getRbVertical(), c);
            ButtonGroup bgOrientation = new ButtonGroup();
            bgOrientation.add(this.getRbHorizontal());
            bgOrientation.add(this.getRbVertical());
            if (this.isLand) {
                this.getRbHorizontal().setSelected(true);
            } else {
                this.getRbVertical().setSelected(true);
            }
            if (this.getCbTipoFolio().getSelectedItem().equals(PluginServices.getText((Object)this, (String)"Personalizado"))) {
                this.rbHorizontal.setEnabled(false);
                this.rbVertical.setEnabled(false);
                this.rbVertical.setSelected(true);
                this.isLand = false;
            }
        }
        return this.pOrientation;
    }

    private JRadioButton getRbHorizontal() {
        if (this.rbHorizontal == null) {
            this.rbHorizontal = new JRadioButton();
            this.rbHorizontal.setText(PluginServices.getText((Object)this, (String)"horizontal"));
            this.rbHorizontal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FConfigLayoutDialog.this.isLand = true;
                    double iz = FConfigLayoutDialog.this.izq;
                    FConfigLayoutDialog.this.izq = FConfigLayoutDialog.this.inf;
                    FConfigLayoutDialog.this.inf = FConfigLayoutDialog.this.der;
                    FConfigLayoutDialog.this.der = FConfigLayoutDialog.this.sup;
                    FConfigLayoutDialog.this.sup = iz;
                    Attributes attr = FConfigLayoutDialog.this.temporaryAttributes;
                    attr.setIsLandScape(FConfigLayoutDialog.this.isLand);
                    FConfigLayoutDialog.this.setMargin(FConfigLayoutDialog.this.margin);
                    Size size = attr.getPaperSizeInUnits();
                    FConfigLayoutDialog.this.getTAncho().setText(String.valueOf(FConfigLayoutDialog.this.nf.format(size.getWidth())));
                    FConfigLayoutDialog.this.getTAlto().setText(String.valueOf(FConfigLayoutDialog.this.nf.format(size.getHeight())));
                }
            });
        }
        return this.rbHorizontal;
    }

    private JRadioButton getRbVertical() {
        if (this.rbVertical == null) {
            this.rbVertical = new JRadioButton();
            this.rbVertical.setText(PluginServices.getText((Object)this, (String)"vertical"));
            this.rbVertical.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FConfigLayoutDialog.this.isLand = false;
                    double in = FConfigLayoutDialog.this.inf;
                    FConfigLayoutDialog.this.inf = FConfigLayoutDialog.this.izq;
                    FConfigLayoutDialog.this.izq = FConfigLayoutDialog.this.sup;
                    FConfigLayoutDialog.this.sup = FConfigLayoutDialog.this.der;
                    FConfigLayoutDialog.this.der = in;
                    Attributes attr = FConfigLayoutDialog.this.temporaryAttributes;
                    attr.setIsLandScape(FConfigLayoutDialog.this.isLand);
                    FConfigLayoutDialog.this.setMargin(FConfigLayoutDialog.this.margin);
                    Size size = attr.getPaperSizeInUnits();
                    FConfigLayoutDialog.this.getTAncho().setText(String.valueOf(FConfigLayoutDialog.this.nf.format(size.getWidth())));
                    FConfigLayoutDialog.this.getTAlto().setText(String.valueOf(FConfigLayoutDialog.this.nf.format(size.getHeight())));
                }
            });
        }
        return this.rbVertical;
    }

    private JList getViewList() {
        if (this.liViews == null) {
            ListViewModel listModel = new ListViewModel();
            listModel.addCreateNewViewObj();
            if (listModel.addViews()) {
                JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Some_views_excluded_from_list_because_have_editing_layers"), Messages.getText((String)"Preparar_pagina"), 2);
            }
            this.liViews = new JList(listModel);
            this.liViews.setSelectedIndex(0);
        }
        return this.liViews;
    }

    private JScrollPane getViewScrollPane() {
        if (this.jViewScrollPane == null) {
            this.jViewScrollPane = new JScrollPane();
            this.jViewScrollPane.setViewportView(this.getViewList());
            this.jViewScrollPane.setPreferredSize(new Dimension(300, 100));
        }
        return this.jViewScrollPane;
    }

    private JButton getBtConfigView() {
        if (this.btConfigView == null) {
            UsabilitySwingManager manager = ToolsSwingLocator.getUsabilitySwingManager();
            this.btConfigView = manager.createJButton(Messages.getText((String)"Configure_view"));
            this.btConfigView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewDocument view = FConfigLayoutDialog.this.getSelectedView();
                    if (view != null) {
                        IWindow propWin = view.getPropertiesWindow();
                        ApplicationManager manager = ApplicationLocator.getManager();
                        manager.getUIManager().addWindow(propWin);
                    }
                }
            });
        }
        return this.btConfigView;
    }

    protected ViewDocument getSelectedView() {
        Object selected = this.getViewList().getSelectedValue();
        ViewDocument view = null;
        if (selected instanceof ViewDocument) {
            view = (ViewDocument)selected;
        } else if (selected == ListViewModel.CREATE_NEW_VIEW_OBJECT) {
            view = this.createdView == null ? this.createView() : this.createdView;
        }
        return view;
    }

    private ViewDocument createView() {
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        this.createdView = (ViewDocument)viewManager.createDocument();
        ProjectManager.getInstance().getCurrentProject().addDocument((Document)this.createdView);
        return this.createdView;
    }

    private void deleteView() {
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ProjectManager.getInstance().getCurrentProject().removeDocument((Document)this.createdView);
        this.createdView = null;
    }

    private JCheckBox getChbViews() {
        if (this.chbViews == null) {
            this.chbViews = new JCheckBox(PluginServices.getText((Object)this, (String)"Insert_view"));
            this.chbViews.setSelected(true);
        }
        return this.chbViews;
    }

    private void obtainArea() {
        String s = this.getTSuperior().getText();
        if ((s = s.replace(',', '.')).length() == 0) {
            s = "0";
        }
        this.sup = this.temporaryAttributes.fromUnits(Double.valueOf(s));
        s = this.getTIzquierdo().getText();
        if ((s = s.replace(',', '.')).length() == 0) {
            s = "0";
        }
        this.izq = this.temporaryAttributes.fromUnits(Double.valueOf(s));
        s = this.getTInferior().getText();
        if ((s = s.replace(',', '.')).length() == 0) {
            s = "0";
        }
        this.inf = this.temporaryAttributes.fromUnits(Double.valueOf(s));
        s = this.getTDerecho().getText();
        if ((s = s.replace(',', '.')).length() == 0) {
            s = "0";
        }
        this.der = this.temporaryAttributes.fromUnits(Double.valueOf(s));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            this.onAcceptPressed();
        } else {
            this.onCancelPressed();
        }
    }

    private void onCancelPressed() {
        if (this.createdView != null) {
            this.deleteView();
        }
        this.setVisible(false);
    }

    private void onAcceptPressed() {
        this.obtainArea();
        double[] area = new double[]{this.sup, this.inf, this.izq, this.der};
        if (this.type == 6) {
            String width = this.getTAncho().getText().replace(',', '.');
            String height = this.getTAlto().getText().replace(',', '.');
            this.temporaryAttributes.setPaperSize(new Size(Double.valueOf(height), Double.valueOf(width)));
        } else if (this.isLand) {
            this.temporaryAttributes.setIsLandScape(true);
        } else {
            this.temporaryAttributes.setIsLandScape(false);
        }
        this.temporaryAttributes.setType(this.type);
        this.m_layout.getLayoutContext().setAtributes(this.temporaryAttributes);
        this.temporaryAttributes.setSelectedOptions(this.type, this.unit, this.isLand, this.margin, this.resolution, area);
        this.m_layout.obtainRect(false);
        if (this.showViewList && this.getChbViews().isSelected()) {
            ViewDocument vd = this.getSelectedView();
            ProjectManager projectManager = ApplicationLocator.getProjectManager();
            LayoutManager layoutManager = (LayoutManager)projectManager.getDocumentManager("project.document.layout");
            FFrameView ffv = (FFrameView)layoutManager.createFrame("FFrameView");
            ffv.setDocument(this.m_layout.getDocument());
            LayoutContext lctxt = this.m_layout.getLayoutContext();
            ffv.setLayoutContext(lctxt);
            ffv.setBoundBox(new Rectangle2D.Double(this.izq, this.sup, this.temporaryAttributes.getPaperSize().getWidth() - (this.izq + this.der), this.temporaryAttributes.getPaperSize().getHeight() - (this.sup + this.inf)));
            ffv.setView(vd);
            lctxt.addFFrame(ffv, true, true);
            this.m_layout.getLayoutControl().setDefaultTool();
        }
        if (this.createdView != null && this.createdView != this.getSelectedView()) {
            this.deleteView();
        }
        this.m_layout.getLayoutControl().fullRect();
        this.setVisible(false);
    }
}

