/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.tools.listener;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.FFrameGraphics;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.tools.AbstractLayoutToolListener;
import org.gvsig.app.project.documents.layout.tools.listener.LayoutRectangleListener;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;

public class LayoutAddRectangleListener
extends AbstractLayoutToolListener
implements LayoutRectangleListener {
    private final Image img = PluginServices.getIconTheme().get("cursor-selection-by-rectangle").getImage();
    protected static int TOLERANCE = 15;

    public LayoutAddRectangleListener(LayoutPanel layoutPanel) {
        super(layoutPanel);
    }

    @Override
    public void rectangle(EnvelopeEvent event) throws BehaviorException {
        FFrameGraphics fframe = (FFrameGraphics)this.layoutManager.createFrame("FFrameGraphics");
        fframe.setGeometryAdapter(this.layoutPanel.getLayoutControl().getGeometryAdapter());
        fframe.update(3, this.layoutPanel.getLayoutControl().getAT());
        fframe.setBoundBox(this.layoutPanel.getLayoutControl().getGeometryAdapter().getBounds2D());
        this.layoutPanel.getLayoutContext().addFFrame(fframe, true, true);
        PluginServices.getMainFrame().enableControls();
        this.layoutPanel.getLayoutControl().refresh();
    }

    @Override
    public Image getImageCursor() {
        return this.img;
    }

    @Override
    public boolean cancelDrawing() {
        return false;
    }

    protected Rectangle2D getRectangle(int tolerance) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        if (this.isCorrectSize(tolerance, this.layoutPanel.getLayoutControl().getFirstPoint(), this.layoutPanel.getLayoutControl().getLastPoint())) {
            Point fp = this.layoutPanel.getLayoutControl().getFirstPoint();
            Point lp = this.layoutPanel.getLayoutControl().getLastPoint();
            if (((Point2D)fp).getX() < ((Point2D)lp).getX()) {
                if (((Point2D)fp).getY() < ((Point2D)lp).getY()) {
                    ((Rectangle2D)r).setRect(((Point2D)fp).getX(), ((Point2D)fp).getY(), ((Point2D)lp).getX() - ((Point2D)fp).getX(), ((Point2D)lp).getY() - ((Point2D)fp).getY());
                } else {
                    ((Rectangle2D)r).setRect(((Point2D)fp).getX(), ((Point2D)lp).getY(), ((Point2D)lp).getX() - ((Point2D)fp).getX(), ((Point2D)fp).getY() - ((Point2D)lp).getY());
                }
            } else if (((Point2D)fp).getY() > ((Point2D)lp).getY()) {
                ((Rectangle2D)r).setRect(((Point2D)lp).getX(), ((Point2D)lp).getY(), ((Point2D)fp).getX() - ((Point2D)lp).getX(), ((Point2D)fp).getY() - ((Point2D)lp).getY());
            } else {
                ((Rectangle2D)r).setRect(((Point2D)lp).getX(), ((Point2D)fp).getY(), ((Point2D)lp).getX() - ((Point2D)fp).getX(), ((Point2D)lp).getY() - ((Point2D)fp).getY());
            }
        } else {
            Point2D p1 = this.layoutPanel.getLayoutControl().getFirstPoint();
            p1 = new Point2D.Double(((Point2D)p1).getX() + (double)tolerance, ((Point2D)p1).getY() + (double)tolerance);
            r.setFrameFromDiagonal(this.layoutPanel.getLayoutControl().getFirstPoint(), p1);
        }
        return r;
    }

    private boolean isCorrectSize(int tolerance, Point2D p1, Point2D p2) {
        if (Math.abs(p2.getX() - p1.getX()) < (double)tolerance) {
            return false;
        }
        return !(Math.abs(p2.getY() - p1.getY()) < (double)tolerance);
    }
}

