/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.model;

import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.layout.mapbox.model.Cell;
import org.gvsig.layout.mapbox.model.CellImpl;
import org.gvsig.layout.mapbox.model.Dimension2DDouble;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.IsEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBoxModel
implements IsEmpty,
Persistent,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBoxModel.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "MapBoxModel";
    public static final int POSITION_OUT_OF_MAPBOX = -1;
    public static final int POSITION_IN_CELL = 0;
    public static final int POSITION_AT_TOP_OF_CELL = 1;
    public static final int POSITION_AT_BOTOM_OF_CELL = 2;
    public static final int POSITION_ON_LEFT_EDGE_OF_CELL = 3;
    public static final int POSITION_ON_RIGHT_EDGE_OF_CELL = 4;
    private List<Cell> cells = new ArrayList<Cell>();
    private Dimension2D dimension;

    public MapBoxModel() {
    }

    public MapBoxModel(Dimension2D dimension, int columns, int rows) {
        this();
        this.dimension = dimension;
        double cellWidth = dimension.getWidth() / (double)columns;
        double cellHeight = dimension.getHeight() / (double)rows;
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                this.cells.add(new CellImpl((double)i * cellWidth, (double)j * cellHeight, cellWidth, cellHeight));
            }
        }
    }

    public MapBoxModel(Dimension2D dimension, List<Cell> cells) {
        this();
        this.dimension = dimension;
        for (Cell cell : cells) {
            this.cells.add(cell);
        }
    }

    public Cell getCell(double x, double y) {
        for (Cell cell : this.cells) {
            if (!cell.contains(x, y)) continue;
            return cell;
        }
        return null;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public List<Cell> getCells(Rectangle2D r) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!cell.isContained(r)) continue;
            res.add(cell);
        }
        return res;
    }

    public void add(Cell c) {
        this.cells.add(c);
    }

    public void insertRow(Cell cell) {
        try {
            Dimension2D oldDimension = (Dimension2D)this.dimension.clone();
            double y = cell.getY();
            List<Cell> sameRowCells = this.getRowCells(y);
            double rowHeight = Double.POSITIVE_INFINITY;
            for (Cell sameRowCell : sameRowCells) {
                if (!(sameRowCell.getHeight() < rowHeight)) continue;
                rowHeight = sameRowCell.getHeight();
            }
            List<Cell> nextRowsCells = this.getNextRowsCells(y);
            List<Cell> rowTraversedCells = this.getTraversedRowCells(y);
            ArrayList<Cell> visited = new ArrayList<Cell>();
            for (Cell curCell : sameRowCells) {
                Cell c = curCell.clone();
                c.setY(y);
                c.setHeight(rowHeight);
                this.add(c);
                visited.add(curCell);
            }
            for (Cell curCell : nextRowsCells) {
                curCell.setY(curCell.getY() + rowHeight);
                visited.add(curCell);
            }
            for (Cell curCell : rowTraversedCells) {
                if (visited.contains(curCell)) continue;
                curCell.setHeight(curCell.getHeight() + rowHeight);
            }
            this.dimension.setSize(this.dimension.getWidth(), this.dimension.getHeight() + rowHeight);
            this.resize(oldDimension);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't insert row before cell " + Objects.toString(cell), (Throwable)ex);
        }
    }

    public void insertColumn(Cell cell) {
        try {
            Dimension2D oldDimension = (Dimension2D)this.dimension.clone();
            double x = cell.getX();
            List<Cell> sameColumnCells = this.getColumnCells(x);
            double rowWidth = Double.POSITIVE_INFINITY;
            for (Cell sameColumnCell : sameColumnCells) {
                if (!(sameColumnCell.getWidth() < rowWidth)) continue;
                rowWidth = sameColumnCell.getWidth();
            }
            List<Cell> nextColumnsCells = this.getNextColumnsCells(x);
            List<Cell> columnTraversedCells = this.getTraversedColumnCells(x);
            ArrayList<Cell> visited = new ArrayList<Cell>();
            for (Cell curCell : sameColumnCells) {
                Cell c = (Cell)CloneableUtils.cloneQuietly((Cloneable)curCell);
                c.setX(x);
                c.setWidth(rowWidth);
                this.add(c);
                visited.add(curCell);
            }
            for (Cell curCell : nextColumnsCells) {
                curCell.setX(curCell.getX() + rowWidth);
                visited.add(curCell);
            }
            for (Cell curCell : columnTraversedCells) {
                if (visited.contains(curCell)) continue;
                curCell.setWidth(curCell.getWidth() + rowWidth);
            }
            this.dimension.setSize(this.dimension.getWidth() + rowWidth, this.dimension.getHeight());
            this.resize(oldDimension);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't insert column before cell " + Objects.toString(cell), (Throwable)ex);
        }
    }

    public void addRow(Cell cell) {
        try {
            Dimension2D oldDimension = (Dimension2D)this.dimension.clone();
            double y = cell.getY() + cell.getHeight();
            List<Cell> previousRowCells = this.getPreviousRowCells(y);
            double rowHeight = Double.POSITIVE_INFINITY;
            for (Cell previousRowCell : previousRowCells) {
                if (!(previousRowCell.getHeight() < rowHeight)) continue;
                rowHeight = previousRowCell.getHeight();
            }
            List<Cell> nextRowsCells = this.getNextRowsCells(y);
            List<Cell> rowTraversedCells = this.getTraversedRowCells(y);
            ArrayList<Cell> visited = new ArrayList<Cell>();
            for (Cell curCell : previousRowCells) {
                Cell c = (Cell)CloneableUtils.cloneQuietly((Cloneable)curCell);
                c.setY(y);
                c.setHeight(rowHeight);
                this.add(c);
                visited.add(curCell);
            }
            for (Cell curCell : nextRowsCells) {
                if (visited.contains(curCell)) continue;
                curCell.setY(curCell.getY() + rowHeight);
                visited.add(curCell);
            }
            for (Cell curCell : rowTraversedCells) {
                if (visited.contains(curCell)) continue;
                curCell.setHeight(curCell.getHeight() + rowHeight);
            }
            this.dimension.setSize(this.dimension.getWidth(), this.dimension.getHeight() + rowHeight);
            this.resize(oldDimension);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add row after cell " + Objects.toString(cell), (Throwable)ex);
        }
    }

    public void addColumn(Cell cell) {
        try {
            Dimension2D oldDimension = (Dimension2D)this.dimension.clone();
            double x = cell.getX() + cell.getWidth();
            List<Cell> previousColumnCells = this.getPreviousColumnCells(x);
            double columnWidth = Double.POSITIVE_INFINITY;
            for (Cell previousColumnCell : previousColumnCells) {
                if (!(previousColumnCell.getWidth() < columnWidth)) continue;
                columnWidth = previousColumnCell.getWidth();
            }
            List<Cell> nextColumnsCells = this.getNextColumnsCells(x);
            List<Cell> columnTraversedCells = this.getTraversedColumnCells(cell.getX() + cell.getWidth());
            ArrayList<Cell> visited = new ArrayList<Cell>();
            for (Cell curCell : previousColumnCells) {
                Cell c = (Cell)CloneableUtils.cloneQuietly((Cloneable)curCell);
                c.setX(x);
                c.setWidth(columnWidth);
                this.add(c);
                visited.add(curCell);
            }
            for (Cell curCell : nextColumnsCells) {
                if (visited.contains(curCell)) continue;
                curCell.setX(curCell.getX() + columnWidth);
                visited.add(curCell);
            }
            for (Cell curCell : columnTraversedCells) {
                if (visited.contains(curCell)) continue;
                curCell.setWidth(curCell.getWidth() + columnWidth);
            }
            this.dimension.setSize(this.dimension.getWidth() + columnWidth, this.dimension.getHeight());
            this.resize(oldDimension);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't insert column after cell " + Objects.toString(cell), (Throwable)ex);
        }
    }

    private List<Cell> getRowCells(double y) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!MathUtils.equals((double)cell.getY(), (double)y, (double)0.001)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getRowCellsBetween(double y, double y1) {
        HashSet<Cell> res = new HashSet<Cell>();
        for (Cell cell : this.cells) {
            if (MathUtils.equals((double)cell.getY(), (double)y, (double)0.001) && MathUtils.equals((double)(cell.getY() + cell.getHeight()), (double)y1, (double)0.001)) {
                res.add(cell);
            }
            if (MathUtils.equals((double)cell.getY(), (double)y, (double)0.001) && cell.getY() + cell.getHeight() < y1) {
                res.add(cell);
            }
            if (MathUtils.equals((double)(cell.getY() + cell.getHeight()), (double)y1, (double)0.001) && cell.getY() > y) {
                res.add(cell);
            }
            if (!(cell.getY() > y) || !(cell.getY() + cell.getHeight() < y1)) continue;
            res.add(cell);
        }
        return new ArrayList<Cell>(res);
    }

    private List<Cell> getNextRowsCells(double y) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!(cell.getY() >= y) && !MathUtils.equals((double)cell.getY(), (double)y, (double)0.001)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getPreviousRowCells(double y) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!MathUtils.equals((double)(cell.getY() + cell.getHeight()), (double)y, (double)0.001)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getTraversedRowCells(double y) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!(cell.getY() < y) || !(cell.getY() + cell.getHeight() > y)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getColumnCells(double x) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!MathUtils.equals((double)cell.getX(), (double)x, (double)0.001)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getColumnCellsBetween(double x, double x1) {
        HashSet<Cell> res = new HashSet<Cell>();
        for (Cell cell : this.cells) {
            if (MathUtils.equals((double)cell.getX(), (double)x, (double)0.001) && MathUtils.equals((double)(cell.getX() + cell.getWidth()), (double)x1, (double)0.001)) {
                res.add(cell);
            }
            if (MathUtils.equals((double)cell.getX(), (double)x, (double)0.001) && cell.getX() + cell.getWidth() < x1) {
                res.add(cell);
            }
            if (MathUtils.equals((double)(cell.getX() + cell.getWidth()), (double)x1, (double)0.001) && cell.getX() > x) {
                res.add(cell);
            }
            if (!(cell.getX() > x) || !(cell.getX() + cell.getWidth() < x1)) continue;
            res.add(cell);
        }
        return new ArrayList<Cell>(res);
    }

    private List<Cell> getNextColumnsCells(double x) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!(cell.getX() >= x) && !MathUtils.equals((double)cell.getX(), (double)x, (double)0.001)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getPreviousColumnCells(double x) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!MathUtils.equals((double)(cell.getX() + cell.getWidth()), (double)x, (double)0.001)) continue;
            res.add(cell);
        }
        return res;
    }

    private List<Cell> getTraversedColumnCells(double x) {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (!(cell.getX() < x) || !(cell.getX() + cell.getWidth() > x)) continue;
            res.add(cell);
        }
        return res;
    }

    public void dump(List<Cell> theCells) {
        if (theCells == null) {
            theCells = this.cells;
        }
        for (Cell cell : theCells) {
            System.out.println(cell.toString());
        }
    }

    public void sort() {
        Collections.sort(this.cells, (o1, o2) -> {
            int res = Double.compare(o1.getY(), o2.getY());
            if (res == 0) {
                res = Double.compare(o1.getX(), o2.getX());
            }
            return res;
        });
    }

    public Cell join(List<Cell> theCells) {
        Cell join = (Cell)CloneableUtils.cloneQuietly((Cloneable)theCells.get(0));
        for (Cell theCell : theCells) {
            join.join(theCell);
        }
        return join;
    }

    public void combine(List<Cell> theCells) {
        Cell join = this.join(theCells);
        if (join == null) {
            return;
        }
        this.removeCells(theCells);
        this.cells.add(join);
    }

    public void splitCellHorizontally(Cell theCell) {
        double h = theCell.getHeight() / 2.0;
        theCell.setHeight(h);
        Cell cloned = (Cell)CloneableUtils.cloneQuietly((Cloneable)theCell);
        cloned.setY(theCell.getY() + h);
        this.cells.add(cloned);
    }

    public void splitCellsHorizontally(List<Cell> theCells) {
        for (Cell theCell : theCells) {
            this.splitCellHorizontally(theCell);
        }
    }

    public void splitCellVertically(Cell theCell) {
        double w = theCell.getWidth() / 2.0;
        theCell.setWidth(w);
        Cell cloned = (Cell)CloneableUtils.cloneQuietly((Cloneable)theCell);
        cloned.setX(theCell.getX() + w);
        this.cells.add(cloned);
    }

    public void splitCellsVertically(List<Cell> theCells) {
        for (Cell theCell : theCells) {
            this.splitCellVertically(theCell);
        }
    }

    public void removeCells(List<Cell> theCells) {
        this.cells.removeAll(theCells);
    }

    public void removeCells(Rectangle r) {
        Iterator<Cell> iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (!cell.isContained(r)) continue;
            iterator.remove();
        }
    }

    public void removeColumn(Cell cell) {
        Dimension2D oldDimension = (Dimension2D)this.dimension.clone();
        double x = cell.getX();
        double columnWidth = cell.getWidth();
        List<Cell> columnCells = this.getColumnCellsBetween(x, x + columnWidth);
        List<Cell> nextColumnsCells = this.getNextColumnsCells(cell.getX() + cell.getWidth());
        List<Cell> leftTraversedColumnsCells = this.getTraversedColumnCells(cell.getX());
        List<Cell> rightTraversedColumnsCells = this.getTraversedColumnCells(cell.getX() + cell.getWidth());
        ArrayList<Cell> visited = new ArrayList<Cell>();
        for (Cell columnCell : columnCells) {
            this.cells.remove(columnCell);
            visited.add(columnCell);
        }
        for (Cell nextColumnsCell : nextColumnsCells) {
            if (visited.contains(nextColumnsCell)) continue;
            nextColumnsCell.setX(nextColumnsCell.getX() - columnWidth);
            visited.add(nextColumnsCell);
        }
        for (Cell leftTraversedColumnsCell : leftTraversedColumnsCells) {
            if (visited.contains(leftTraversedColumnsCell)) continue;
            if (rightTraversedColumnsCells.contains(leftTraversedColumnsCell)) {
                leftTraversedColumnsCell.setWidth(leftTraversedColumnsCell.getWidth() - columnWidth);
            } else {
                leftTraversedColumnsCell.setWidth(x - leftTraversedColumnsCell.getX());
            }
            visited.add(leftTraversedColumnsCell);
        }
        for (Cell rightTraversedColumnsCell : rightTraversedColumnsCells) {
            if (visited.contains(rightTraversedColumnsCell)) continue;
            rightTraversedColumnsCell.setWidth(rightTraversedColumnsCell.getX() + rightTraversedColumnsCell.getWidth() - (x + columnWidth));
            rightTraversedColumnsCell.setY(x + columnWidth);
        }
        this.dimension.setSize(this.dimension.getWidth() - columnWidth, this.dimension.getHeight());
        this.resize(oldDimension);
    }

    public void removeRow(Cell cell) {
        Dimension2D oldDimension = (Dimension2D)this.dimension.clone();
        double y = cell.getY();
        double rowHeight = cell.getHeight();
        List<Cell> rowCells = this.getRowCellsBetween(y, y + rowHeight);
        List<Cell> nextRowsCells = this.getNextRowsCells(cell.getY() + cell.getHeight());
        List<Cell> upTraversedRowsCells = this.getTraversedRowCells(cell.getY());
        List<Cell> downTraversedRowsCells = this.getTraversedRowCells(cell.getY() + cell.getHeight());
        ArrayList<Cell> visited = new ArrayList<Cell>();
        for (Cell rowCell : rowCells) {
            this.cells.remove(rowCell);
            visited.add(rowCell);
        }
        for (Cell nextRowsCell : nextRowsCells) {
            if (visited.contains(nextRowsCell)) continue;
            nextRowsCell.setY(nextRowsCell.getY() - rowHeight);
            visited.add(nextRowsCell);
        }
        for (Cell upTraversedRowsCell : upTraversedRowsCells) {
            if (visited.contains(upTraversedRowsCell)) continue;
            if (downTraversedRowsCells.contains(upTraversedRowsCell)) {
                upTraversedRowsCell.setHeight(upTraversedRowsCell.getHeight() - rowHeight);
            } else {
                upTraversedRowsCell.setHeight(y - upTraversedRowsCell.getY());
            }
            visited.add(upTraversedRowsCell);
        }
        for (Cell downTraversedRowsCell : downTraversedRowsCells) {
            if (visited.contains(downTraversedRowsCell)) continue;
            downTraversedRowsCell.setHeight(downTraversedRowsCell.getY() + downTraversedRowsCell.getHeight() - (y + rowHeight));
            downTraversedRowsCell.setY(y + rowHeight);
        }
        this.dimension.setSize(this.dimension.getWidth(), this.dimension.getHeight() - rowHeight);
        this.resize(oldDimension);
    }

    public void resize(Dimension2D dimension) {
        if (this.dimension != null) {
            double scaleX = dimension.getWidth() / this.dimension.getWidth();
            double scaleY = dimension.getHeight() / this.dimension.getHeight();
            for (Cell cell : this.cells) {
                cell.setWidth(cell.getWidth() * scaleX);
                cell.setHeight(cell.getHeight() * scaleY);
                cell.setX(cell.getX() * scaleX);
                cell.setY(cell.getY() * scaleY);
            }
        }
        this.dimension = dimension;
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public Pair<Integer, Cell> getRelativePosition(Point2D p, double tolerance) {
        for (Cell cell : this.cells) {
            if (Math.abs(cell.getX() - p.getX()) <= tolerance) {
                return new ImmutablePair((Object)3, (Object)cell);
            }
            if (Math.abs(cell.getY() - p.getY()) <= tolerance) {
                return new ImmutablePair((Object)1, (Object)cell);
            }
            if (Math.abs(cell.getX() + cell.getWidth() - p.getX()) <= tolerance) {
                return new ImmutablePair((Object)4, (Object)cell);
            }
            if (Math.abs(cell.getY() + cell.getHeight() - p.getY()) <= tolerance) {
                return new ImmutablePair((Object)2, (Object)cell);
            }
            if (!cell.getRectangle().contains(p)) continue;
            return new ImmutablePair((Object)0, (Object)cell);
        }
        return new ImmutablePair((Object)-1, null);
    }

    public void moveVerticalLine(double x0, double x1) {
        List<Cell> columnCells = this.getColumnCells(x0);
        double maxX = Double.POSITIVE_INFINITY;
        for (Cell columnCell : columnCells) {
            maxX = Math.min(columnCell.getX() + columnCell.getWidth(), maxX);
        }
        List<Cell> previousColumnCells = this.getPreviousColumnCells(x0);
        double minX = Double.NEGATIVE_INFINITY;
        for (Cell previousColumnCell : previousColumnCells) {
            minX = Math.max(previousColumnCell.getX(), minX);
        }
        if (x1 < minX) {
            throw new IllegalArgumentException("The line cannot be moved beyond the previous cell");
        }
        if (x1 > maxX) {
            throw new IllegalArgumentException("The line cannot be moved beyond the next cell");
        }
        if (MathUtils.equals((double)x0, (double)0.0, (double)0.001)) {
            for (Cell cell : this.cells) {
                if (cell.getX() == 0.0) {
                    cell.setWidth(cell.getWidth() - x1);
                    continue;
                }
                cell.setX(cell.getX() - x1);
            }
            this.dimension.setSize(this.dimension.getWidth() - (x1 - x0), this.dimension.getHeight());
        } else if (MathUtils.equals((double)x0, (double)this.dimension.getWidth(), (double)0.001)) {
            for (Cell previousColumnCell : previousColumnCells) {
                previousColumnCell.setWidth(x1 - previousColumnCell.getX());
            }
            this.dimension.setSize(this.dimension.getWidth() + (x1 - x0), this.dimension.getHeight());
        } else {
            for (Cell previousColumnCell : previousColumnCells) {
                previousColumnCell.setWidth(x1 - previousColumnCell.getX());
            }
            for (Cell columnCell : columnCells) {
                columnCell.setX(x1);
                columnCell.setWidth(columnCell.getWidth() - (x1 - x0));
            }
        }
    }

    public void moveHorizontalLine(double y0, double y1) {
        List<Cell> rowCells = this.getRowCells(y0);
        double maxY = Double.POSITIVE_INFINITY;
        for (Cell rowCell : rowCells) {
            maxY = Math.min(rowCell.getY() + rowCell.getHeight(), maxY);
        }
        List<Cell> previousRowCells = this.getPreviousRowCells(y0);
        double minY = Double.NEGATIVE_INFINITY;
        for (Cell previousRowCell : previousRowCells) {
            minY = Math.max(previousRowCell.getY(), minY);
        }
        if (y1 < minY) {
            throw new IllegalArgumentException("The line cannot be moved beyond the previous cell");
        }
        if (y1 > maxY) {
            throw new IllegalArgumentException("The line cannot be moved beyond the next cell");
        }
        if (MathUtils.equals((double)y0, (double)0.0, (double)0.001)) {
            for (Cell cell : this.cells) {
                if (cell.getY() == 0.0) {
                    cell.setHeight(cell.getHeight() - y1);
                    continue;
                }
                cell.setY(cell.getY() - y1);
            }
            this.dimension.setSize(this.dimension.getWidth(), this.dimension.getHeight() - (y1 - y0));
        } else if (MathUtils.equals((double)y0, (double)this.dimension.getHeight(), (double)0.001)) {
            for (Cell previousRowCell : previousRowCells) {
                previousRowCell.setHeight(y1 - previousRowCell.getY());
            }
            this.dimension.setSize(this.dimension.getWidth(), this.dimension.getHeight() + (y1 - y0));
        } else {
            for (Cell previousRowCell : previousRowCells) {
                previousRowCell.setHeight(y1 - previousRowCell.getY());
            }
            for (Cell rowCell : rowCells) {
                rowCell.setY(y1);
                rowCell.setHeight(rowCell.getHeight() - (y1 - y0));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MapBoxModel other = (MapBoxModel)super.clone();
        ArrayList<Cell> clonedCells = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            clonedCells.add(cell.clone());
        }
        other.cells = clonedCells;
        if (this.dimension != null) {
            other.dimension = (Dimension2D)this.dimension.clone();
        }
        return other;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(MapBoxModel.class, PERSISTENCE_DEFINITION_NAME, "FFrameMapBox persistence definition", null, null);
            definition.addDynFieldList("cells").setClassOfItems(Cell.class).setMandatory(true);
            definition.addDynFieldDouble("width").setMandatory(true);
            definition.addDynFieldDouble("height").setMandatory(true);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List c = state.getList("cells");
        if (c != null) {
            this.cells = new ArrayList<Cell>(c);
        }
        double width = state.getDouble("width");
        double height = state.getDouble("height");
        this.dimension = new Dimension2DDouble(width, height);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("cells", this.cells);
        state.set("width", this.dimension.getWidth());
        state.set("height", this.dimension.getHeight());
    }
}

