/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.panel;

import java.awt.geom.Rectangle2D;
import javax.swing.SpinnerNumberModel;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.layout.mapbox.fframe.FFrameMapBox;
import org.gvsig.layout.mapbox.model.Dimension2DDouble;
import org.gvsig.layout.mapbox.model.MapBoxModel;
import org.gvsig.layout.mapbox.panel.FFrameMapBoxPanelView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class FFrameMapBoxPanel
extends FFrameMapBoxPanelView {
    private MapBoxModel model;
    private Rectangle2D rectangle;
    private FFrameMapBox baseFrame;
    private Rectangle2D.Double fframebbox;

    public FFrameMapBoxPanel(LayoutPanel layoutPanel, IFFrame fframe) {
        this.initComponents();
        this.translate();
        this.put((FFrameMapBox)fframe);
    }

    private void initComponents() {
        this.spnColumns.setModel(new SpinnerNumberModel(3, 1, Integer.MAX_VALUE, 1));
        this.spnRows.setModel(new SpinnerNumberModel(3, 1, Integer.MAX_VALUE, 1));
        this.spnDegrees.setModel(new SpinnerNumberModel(0.0, -179.0, 180.0, 1.0));
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblRows);
        toolsSwingManager.translate(this.lblColumns);
        toolsSwingManager.translate(this.lblDegrees);
        toolsSwingManager.translate(this.lblPreview);
    }

    public FFrameMapBox fetch(FFrameMapBox output) {
        if (output == null) {
            output = (FFrameMapBox)CloneableUtils.cloneQuietly((Cloneable)this.baseFrame);
            if (output == null) {
                return null;
            }
            output.setBoundBox(this.fframebbox);
        }
        output.setRotation((Double)this.spnDegrees.getValue());
        if (this.model == null || this.model.isEmpty()) {
            Dimension2DDouble dimension = new Dimension2DDouble(this.fframebbox.getWidth(), this.fframebbox.getHeight());
            this.model = new MapBoxModel(dimension, (Integer)this.spnColumns.getValue(), (Integer)this.spnRows.getValue());
        }
        output.setModel(this.model);
        return output;
    }

    public void put(FFrameMapBox fframeMapBox) {
        if (fframeMapBox != null) {
            this.baseFrame = fframeMapBox;
            this.model = fframeMapBox.getModel();
            this.spnDegrees.setValue(fframeMapBox.getRotation());
            boolean enabled = this.model == null || this.model.isEmpty();
            this.spnColumns.setEnabled(enabled);
            this.spnRows.setEnabled(enabled);
            this.fframebbox = fframeMapBox.getBoundBox();
        }
    }

    @Override
    public IFFrame getFFrame() {
        return this.fetch(null);
    }

    @Override
    public void setRectangle(Rectangle2D r) {
        this.rectangle = r;
    }

    @Override
    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Mapbox_properties");
    }
}

