/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.layout.mapbox.panel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.AbstractFFramePanel;

public abstract class FFrameMapBoxPanelView
extends AbstractFFramePanel {
    JLabel lblRows = new JLabel();
    JLabel lblColumns = new JLabel();
    JLabel lblDegrees = new JLabel();
    JSpinner spnRows = new JSpinner();
    JSpinner spnColumns = new JSpinner();
    JSpinner spnDegrees = new JSpinner();
    JLabel lblPreview = new JLabel();

    public FFrameMapBoxPanelView() {
        this.initializePanel();
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Unable to load image: " + imageName);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation orientation) {
        super.applyComponentOrientation(orientation);
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE", "CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.lblRows.setName("lblRows");
        this.lblRows.setText("_Num_rows");
        jpanel1.add((Component)this.lblRows, cc.xy(2, 2));
        this.lblColumns.setName("lblColumns");
        this.lblColumns.setText("_Num_columns");
        jpanel1.add((Component)this.lblColumns, cc.xy(2, 4));
        this.lblDegrees.setName("lblDegrees");
        this.lblDegrees.setText("_Degrees");
        jpanel1.add((Component)this.lblDegrees, cc.xy(2, 6));
        this.spnRows.setName("spnRows");
        jpanel1.add((Component)this.spnRows, cc.xy(4, 2));
        this.spnColumns.setName("spnColumns");
        jpanel1.add((Component)this.spnColumns, cc.xy(4, 4));
        this.spnDegrees.setName("spnDegrees");
        jpanel1.add((Component)this.spnDegrees, cc.xy(4, 6));
        this.lblPreview.setName("lblPreview");
        jpanel1.add((Component)this.lblPreview, cc.xywh(2, 8, 5, 1));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        return jpanel1;
    }

    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(), "Center");
    }
}

