/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.simpleprovider;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class AutomaticDetectionOfTypes {
    private final String filename;

    public AutomaticDetectionOfTypes() {
        this("(unknown)");
    }

    public AutomaticDetectionOfTypes(String filename) {
        this.filename = filename;
    }

    private String getFullFileName() {
        return this.filename;
    }

    public int[] detect(int columns, Rows rows, boolean isFirstLineHeader, Locale locale) throws IOException {
        int[] types = null;
        int lineno = 0;
        try {
            if (isFirstLineHeader) {
                rows.read();
                ++lineno;
            }
            ArrayList<PossibleDataType> possibleDataTypes = new ArrayList<PossibleDataType>(columns);
            for (int i = 0; i < columns; ++i) {
                possibleDataTypes.add(new PossibleDataType());
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            DataTypesManager typeManager = ToolsLocator.getDataTypesManager();
            Coercion toDecimal = typeManager.getCoercion(19);
            Coercion toDouble = typeManager.getCoercion(7);
            Coercion toFloat = typeManager.getCoercion(6);
            Coercion toDate = typeManager.getCoercion(9);
            Coercion toInt = typeManager.getCoercion(4);
            Coercion toLong = typeManager.getCoercion(5);
            Coercion toGeom = typeManager.getCoercion(66);
            CoercionContextLocale coercionContext = DataTypeUtils.coerceContextLocale((Locale)locale);
            List<Object> row = rows.read();
            ++lineno;
            while (row != null) {
                for (int i = 0; i < row.size(); ++i) {
                    while (possibleDataTypes.size() < row.size()) {
                        possibleDataTypes.add(new PossibleDataType());
                    }
                    String rawvalue = Objects.toString(row.get(i), null);
                    PossibleDataType possibleDataType = (PossibleDataType)possibleDataTypes.get(i);
                    if (possibleDataType.possibleDecimal) {
                        try {
                            toDecimal.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleDecimal = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleDecimal = false;
                        }
                    }
                    if (possibleDataType.possibleDouble) {
                        try {
                            toDouble.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleDouble = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleDouble = false;
                        }
                    }
                    if (possibleDataType.possibleFloat) {
                        try {
                            toFloat.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleFloat = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleFloat = false;
                        }
                    }
                    if (possibleDataType.possibleLong) {
                        possibleDataType.possibleLong = this.isValidLong(rawvalue);
                    }
                    if (possibleDataType.possibleInt) {
                        possibleDataType.possibleInt = this.isValidInteger(rawvalue);
                    }
                    if (possibleDataType.possibleDate) {
                        try {
                            toDate.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleDate = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleDate = false;
                        }
                    }
                    if (possibleDataType.possibleURL) {
                        try {
                            new URL(rawvalue);
                            possibleDataType.possibleURL = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleURL = false;
                        }
                    }
                    if (!possibleDataType.possibleGeometry) continue;
                    try {
                        toGeom.coerce((Object)rawvalue);
                        possibleDataType.possibleGeometry = true;
                        continue;
                    }
                    catch (Exception ex) {
                        possibleDataType.possibleGeometry = false;
                    }
                }
                row = rows.read();
            }
            int n = 0;
            types = new int[possibleDataTypes.size()];
            for (PossibleDataType possibleDataType : possibleDataTypes) {
                if (possibleDataType.possibleInt) {
                    types[n++] = 4;
                    continue;
                }
                if (possibleDataType.possibleLong) {
                    types[n++] = 5;
                    continue;
                }
                if (possibleDataType.possibleDecimal) {
                    types[n++] = 19;
                    continue;
                }
                if (possibleDataType.possibleFloat) {
                    types[n++] = 7;
                    continue;
                }
                if (possibleDataType.possibleDouble) {
                    types[n++] = 7;
                    continue;
                }
                if (possibleDataType.possibleURL) {
                    types[n++] = 16;
                    continue;
                }
                if (possibleDataType.possibleDate) {
                    types[n++] = 9;
                    continue;
                }
                if (possibleDataType.possibleGeometry) {
                    types[n++] = 66;
                    continue;
                }
                types[n++] = 8;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems reading file '" + this.getFullFileName() + "' near line " + lineno + ".", ex);
        }
        return types;
    }

    private boolean isValidLong(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        try {
            if (s.startsWith("0x")) {
                Long.valueOf(s.substring(2), 16);
            } else {
                Long.valueOf(s);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isValidInteger(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        try {
            if (s.startsWith("0x")) {
                Integer.valueOf(s.substring(2), 16);
            } else {
                Integer.valueOf(s);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static class PossibleDataType {
        public boolean possibleInt = true;
        public boolean possibleFloat = true;
        public boolean possibleDouble = true;
        public boolean possibleDecimal = true;
        public boolean possibleLong = true;
        public boolean possibleURL = true;
        public boolean possibleDate = true;
        public boolean possibleGeometry = true;

        private PossibleDataType() {
        }
    }

    public static interface Rows {
        public List<Object> read();
    }
}

