/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.fmap.dal.store.simplereader.AutomaticDetectionOfTypes;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTypeParser.class);
    public String name = null;
    public int type = 0;
    public int size = 0;
    public int geomType = 0;
    public int geomSubtype = 0;
    public Map<String, String> tags = new HashMap<String, String>();
    public Map<String, String> typetags = new HashMap<String, String>();
    public Map<String, String> assignments = new HashMap<String, String>();
    public Map<String, String> typeAssignments = new HashMap<String, String>();
    public AutomaticDetectionOfTypes.DetectedValue detectedValue = null;
    private String typename = "string";
    private final String fullFileName;
    private final String providerName;

    public FieldTypeParser(String providerName, String fullFileName) {
        this.providerName = providerName;
        this.fullFileName = fullFileName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public void clear() {
        this.name = null;
        this.type = 0;
        this.size = 0;
        this.tags = new HashMap<String, String>();
        this.typetags = new HashMap<String, String>();
        this.assignments = new HashMap<String, String>();
        this.typeAssignments = new HashMap<String, String>();
    }

    public void copyFrom(FieldTypeParser other) {
        this.name = other.name;
        this.type = other.type;
        this.size = other.size;
        this.tags = new HashMap<String, String>();
        this.tags.putAll(other.tags);
        this.typetags = new HashMap<String, String>();
        this.typetags.putAll(other.typetags);
        this.assignments = new HashMap<String, String>();
        this.assignments.putAll(other.assignments);
        this.typeAssignments = new HashMap<String, String>();
        this.typeAssignments.putAll(other.typeAssignments);
    }

    private int getType(String value) {
        DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
        return dataTypesManager.getType(this.typename);
    }

    private String[] split(String value, String separators) {
        int firstSeparatorPosition = 1000000;
        Character sep = null;
        for (char ch : separators.toCharArray()) {
            int pos = value.indexOf(ch);
            if (pos <= 0 || pos >= firstSeparatorPosition) continue;
            sep = Character.valueOf(ch);
            firstSeparatorPosition = pos;
        }
        if (sep == null) {
            return new String[]{value};
        }
        return value.split("[" + sep + "]");
    }

    public boolean parse(String value) {
        String[] args;
        if (value.contains("__")) {
            args = value.split("__");
        } else {
            args = this.split(value, ":/#@!;-");
            if (args.length == 1) {
                this.name = value;
                return true;
            }
        }
        int n = 0;
        this.name = StringUtils.trim((String)args[n++]);
        if (n >= args.length) {
            return true;
        }
        this.typename = StringUtils.trim((String)args[n++]);
        this.type = this.getType(this.typename);
        if (this.type == 0) {
            this.geomType = GeometryUtils.getGeometryType((String)this.typename);
            if (this.geomType == -1) {
                this.type = 8;
                LOGGER.info("Type '" + this.typename + "' not valid for attribute '" + value + "' in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.");
            } else {
                this.typename = "GEOMETRY";
                this.type = 66;
            }
        }
        this.size = 0;
        block26: while (n < args.length) {
            String option;
            String escMode = null;
            switch (option = StringUtils.trim((String)args[n++].toLowerCase())) {
                case "size": {
                    try {
                        this.size = Integer.parseInt(args[n++]);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Ignore incorrect field size for field " + value + " in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)ex);
                    }
                    continue block26;
                }
                case "tagesc": {
                    escMode = StringUtils.trim((String)args[n++]);
                }
                case "tag": {
                    String x = StringUtils.trim((String)args[n++]);
                    int pos = x.indexOf("=");
                    if (pos < 0) {
                        this.tags.put(x, null);
                        continue block26;
                    }
                    String v = StringUtils.trim((String)StringUtils.substring((String)x, (int)(pos + 1)));
                    if (escMode != null) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)escMode, (CharSequence)"html")) {
                            v = StringEscapeUtils.unescapeHtml3((String)v);
                        } else {
                            LOGGER.warn("Illegal escape mode for argument '" + option + "' for field '" + this.name + "' in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "' (" + value + ").");
                        }
                    }
                    this.tags.put(StringUtils.trim((String)StringUtils.substring((String)x, (int)0, (int)pos)), v);
                    continue block26;
                }
                case "typetagesc": {
                    escMode = StringUtils.trim((String)args[n++]);
                }
                case "typetag": {
                    String x = StringUtils.trim((String)args[n++]);
                    int pos = x.indexOf("=");
                    if (pos < 0) {
                        this.typetags.put(x, null);
                        continue block26;
                    }
                    String v = StringUtils.trim((String)StringUtils.substring((String)x, (int)(pos + 1)));
                    if (escMode != null) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)escMode, (CharSequence)"html")) {
                            v = StringEscapeUtils.unescapeHtml3((String)v);
                        } else {
                            LOGGER.warn("Illegal escape mode for argument '" + option + "' for field '" + this.name + "' in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "' (" + value + ").");
                        }
                    }
                    this.typetags.put(StringUtils.trim((String)StringUtils.substring((String)x, (int)0, (int)pos)), v);
                    continue block26;
                }
                case "setesc": {
                    escMode = StringUtils.trim((String)args[n++]);
                }
                case "set": {
                    String x = StringUtils.trim((String)args[n++]);
                    int pos = x.indexOf("=");
                    if (pos < 0) {
                        this.assignments.put(x, null);
                        continue block26;
                    }
                    String v = StringUtils.trim((String)StringUtils.substring((String)x, (int)(pos + 1)));
                    if (escMode != null) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)escMode, (CharSequence)"html")) {
                            v = StringEscapeUtils.unescapeHtml3((String)v);
                        } else {
                            LOGGER.warn("Illegal escape mode for argument '" + option + "' for field '" + this.name + "' in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "' (" + value + ").");
                        }
                    }
                    this.assignments.put(StringUtils.trim((String)StringUtils.substring((String)x, (int)0, (int)pos)), v);
                    continue block26;
                }
                case "typesetesc": {
                    escMode = StringUtils.trim((String)args[n++]);
                }
                case "typeset": {
                    String x = StringUtils.trim((String)args[n++]);
                    int pos = x.indexOf("=");
                    if (pos < 0) {
                        this.typeAssignments.put(x, null);
                        continue block26;
                    }
                    String v = StringUtils.trim((String)StringUtils.substring((String)x, (int)(pos + 1)));
                    if (escMode != null) {
                        if (StringUtils.equalsIgnoreCase((CharSequence)escMode, (CharSequence)"html")) {
                            v = StringEscapeUtils.unescapeHtml3((String)v);
                        } else {
                            LOGGER.warn("Illegal escape mode for argument '" + option + "' for field '" + this.name + "' in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "' (" + value + ").");
                        }
                    }
                    this.typeAssignments.put(StringUtils.trim((String)StringUtils.substring((String)x, (int)0, (int)pos)), v);
                    continue block26;
                }
            }
            if (StringUtils.isNumeric((CharSequence)option) && this.size == 0) {
                try {
                    this.size = Integer.parseInt(option);
                }
                catch (Exception ex) {
                    LOGGER.warn("Ignore incorrect field size for field " + value + " in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)ex);
                }
                continue;
            }
            LOGGER.warn("Illegal argument '" + option + "' for field '" + this.name + "' in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "' (" + value + ").");
        }
        return true;
    }
}

