/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleReaderUtils.class);

    public static InputStreamReader openFile(File f, String charsetName) throws FileNotFoundException {
        String fullFileName = f == null ? "NULL" : f.getAbsolutePath();
        Charset charset = Charset.defaultCharset();
        BOMInputStream fis = new BOMInputStream((InputStream)new FileInputStream(f));
        if (StringUtils.isNotBlank((CharSequence)charsetName)) {
            if (Charset.isSupported(charsetName)) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (Throwable th) {
                    LOGGER.warn("Can't use charset '" + charsetName + "' for read csv '" + fullFileName + "'.", th);
                }
            } else {
                LOGGER.warn("charset '" + charsetName + "' not supported for read csv '" + fullFileName + "'.");
            }
        }
        InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
        return isr;
    }

    public static boolean isFileNewer(File file, File fileReference) {
        if (file == null || fileReference == null) {
            return false;
        }
        long lastModified = fileReference.lastModified();
        long now = System.currentTimeMillis();
        if (now < lastModified) {
            LOGGER.warn("The file date is future " + Objects.toString(fileReference));
            lastModified = now;
        }
        return FileUtils.isFileNewer((File)file, (long)lastModified);
    }

    public static boolean isFileNewer(File file, long reference) {
        if (file == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now < reference) {
            LOGGER.warn("The reference file date is future " + Objects.toString(file));
            reference = now;
        }
        return FileUtils.isFileNewer((File)file, (long)reference);
    }
}

