/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader.virtualrows;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gvsig.fmap.dal.store.simplereader.virtualrows.RecordsFile;

public class RecordsFileImpl
extends AbstractList<RecordsFile.Record>
implements RecordsFile {
    private static final int HEADER_SIZE = 1024;
    private RandomAccessFile raf;
    private MappedByteBuffer fileByteBuffer;
    private long sz;
    private int header_size;
    private int type_size;
    private RecordsFile.RecordType recordType;

    public RecordsFileImpl() {
    }

    public RecordsFileImpl(File f) throws IOException {
        this.open(f);
    }

    public RecordsFileImpl(RandomAccessFile raf) throws IOException {
        this.open(raf);
    }

    @Override
    public RecordsFile.RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    public void open(File f) throws IOException {
        RandomAccessFile theRaf = new RandomAccessFile(f, "r");
        this.open(theRaf);
    }

    @Override
    public void open(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.closeByteBuffer();
        this.raf.seek(0L);
        this.raf.readLong();
        this.raf.readLong();
        this.header_size = (int)this.raf.readLong();
        this.type_size = (int)this.raf.readLong();
        byte[] recordTypeBytes = new byte[this.type_size];
        this.raf.read(recordTypeBytes);
        this.recordType = RecordsFile.RecordType.from(recordTypeBytes);
        this.sz = (this.raf.length() - (long)this.header_size) / (long)this.recordType.getSize();
    }

    @Override
    public void create(File f, RecordsFile.RecordType recordType) throws IOException {
        RandomAccessFile theRaf = new RandomAccessFile(f, "rw");
        this.create(theRaf, recordType);
    }

    @Override
    public void create(RandomAccessFile raf, RecordsFile.RecordType recordType) throws IOException {
        this.raf = raf;
        this.recordType = recordType;
        this.header_size = 1024;
        this.closeByteBuffer();
        this.sz = 0L;
        byte[] recordTypeBytes = this.recordType.toBytes();
        this.raf.seek(0L);
        this.raf.writeLong(0L);
        this.raf.writeLong(0L);
        this.raf.writeLong(this.header_size);
        this.raf.writeLong(recordTypeBytes.length);
        this.raf.write(recordTypeBytes);
        this.raf.setLength(this.header_size);
    }

    @Override
    public void close() throws IOException {
        this.closeByteBuffer();
        IOUtils.closeQuietly((Closeable)this.raf);
        this.raf = null;
        this.sz = -1L;
    }

    @Override
    public boolean isOpen() {
        return this.raf != null;
    }

    @Override
    public RecordsFile.Record get(int position) {
        position = this.checkIndex(position);
        RecordsFile.Record record = this.recordType.createRecord();
        this.getByteBuffer().position(this.header_size + position * this.recordType.getSize());
        this.getByteBuffer().get(record.getBytes());
        return record;
    }

    public RecordsFile.Record get64(long position) {
        position = this.checkIndex(position);
        RecordsFile.Record record = this.recordType.createRecord();
        this.getByteBuffer().position((int)((long)this.header_size + position * (long)this.recordType.getSize()));
        this.getByteBuffer().get(record.getBytes());
        return record;
    }

    @Override
    public int size() {
        return (int)this.sz;
    }

    public long size64() {
        return this.sz;
    }

    @Override
    public RecordsFile.Record set(int position, RecordsFile.Record record) {
        try {
            this.closeByteBuffer();
            position = this.checkIndex(position);
            this.raf.seek(this.header_size + position * this.recordType.getSize());
            this.raf.write(record.getBytes());
            return record;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't add record", ex);
        }
    }

    private int checkIndex(long index) {
        if (this.raf == null) {
            throw new IllegalStateException("Index not open");
        }
        if (index < 0L) {
            index = (long)((int)this.sz) + index;
        }
        if (index < 0L || index >= this.sz) {
            throw new IllegalArgumentException("Index out of range (" + index + ")");
        }
        return (int)index;
    }

    private MappedByteBuffer getByteBuffer() {
        try {
            if (this.fileByteBuffer == null) {
                this.fileByteBuffer = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
            }
            return this.fileByteBuffer;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't add record", ex);
        }
    }

    private void closeByteBuffer() {
        if (this.fileByteBuffer != null) {
            this.fileByteBuffer.force();
            this.fileByteBuffer = null;
        }
    }

    @Override
    public boolean add(RecordsFile.Record record) {
        try {
            this.raf.seek(this.raf.length());
            this.raf.write(record.getBytes());
            this.closeByteBuffer();
            ++this.sz;
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't add record", ex);
        }
    }

    public static class RecordTypeBuilderImpl
    implements RecordsFile.RecordTypeBuilder {
        private final RecordTypeImpl recordType = new RecordTypeImpl();

        @Override
        public RecordsFile.RecordTypeBuilder addbyte() {
            this.recordType.add(0, 0);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addShort() {
            this.recordType.add(1, 0);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addInteger() {
            this.recordType.add(2, 0);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addLong() {
            this.recordType.add(3, 0);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addDouble() {
            this.recordType.add(4, 0);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addTimestamp() {
            this.recordType.add(5, 0);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addString(int size) {
            this.recordType.add(6, size);
            return this;
        }

        @Override
        public RecordsFile.RecordTypeBuilder addBytes(int size) {
            this.recordType.add(7, size);
            return this;
        }

        @Override
        public RecordsFile.RecordType build() {
            return this.recordType;
        }

        public static RecordsFile.RecordTypeBuilder recordTypeBuilder() {
            return new RecordTypeBuilderImpl();
        }
    }

    public static class RecordTypeImpl
    implements RecordsFile.RecordType {
        private final List<FieldType> fields = new ArrayList<FieldType>();
        private int size = -1;

        public void add(int type, int size) {
            FieldType field = new FieldType();
            field.size = size;
            field.type = (byte)type;
            this.size = -1;
            field.offset = this.getSize();
            this.fields.add(field);
            this.size = -1;
            this.size = this.getSize();
        }

        @Override
        public int getSize() {
            if (this.size < 0) {
                int sz = 0;
                for (FieldType field : this.fields) {
                    switch (field.type) {
                        case 0: {
                            ++sz;
                            break;
                        }
                        case 1: {
                            sz += 2;
                            break;
                        }
                        case 2: {
                            sz += 4;
                            break;
                        }
                        case 3: 
                        case 5: {
                            sz += 8;
                            break;
                        }
                        case 4: {
                            sz += 8;
                            break;
                        }
                        case 6: {
                            sz += 2 + field.size * 2;
                            break;
                        }
                        case 7: {
                            sz += 4 + field.size;
                        }
                    }
                }
                this.size = sz;
            }
            return this.size;
        }

        @Override
        public int getFieldCount() {
            return this.fields.size();
        }

        @Override
        public int getFieldType(int n) {
            return this.fields.get((int)n).type;
        }

        @Override
        public int getFieldSize(int n) {
            return this.fields.get((int)n).size;
        }

        @Override
        public int getFieldOffset(int n) {
            return this.fields.get((int)n).offset;
        }

        @Override
        public RecordsFile.Record createRecord() {
            this.size = -1;
            this.size = this.getSize();
            return new RecordImpl(this);
        }

        @Override
        public byte[] toBytes() {
            ByteBuffer buffer = ByteBuffer.allocate(this.fields.size() * 5);
            for (FieldType field : this.fields) {
                buffer.put(field.type);
                buffer.putInt(field.size);
            }
            return buffer.array();
        }

        public static RecordsFile.RecordType from(ByteBuffer bytes) {
            RecordTypeImpl recordType = new RecordTypeImpl();
            bytes.position(0);
            int len = bytes.limit() / 5;
            for (int i = 0; i < len; ++i) {
                byte type = bytes.get();
                int size = bytes.getInt();
                recordType.add(type, size);
            }
            return recordType;
        }

        public static RecordsFile.RecordType from(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
            buffer.put(bytes);
            return RecordTypeImpl.from(buffer);
        }

        private static class FieldType {
            public byte type;
            public int size;
            public int offset;

            private FieldType() {
            }
        }
    }

    public static class RecordImpl
    implements RecordsFile.Record {
        private final RecordsFile.RecordType type;
        private final ByteBuffer buffer;

        public RecordImpl(RecordsFile.RecordType type) {
            this.type = type;
            this.buffer = ByteBuffer.allocate(this.type.getSize());
        }

        @Override
        public RecordsFile.RecordType getType() {
            return this.type;
        }

        @Override
        public byte[] getBytes() {
            return this.buffer.array();
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void setBytes(byte[] bytes) {
            this.buffer.position(0);
            this.buffer.put(bytes);
        }

        @Override
        public int getInt(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            return this.buffer.getInt();
        }

        @Override
        public long getLong(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            return this.buffer.getLong();
        }

        @Override
        public double getDouble(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            return this.buffer.getDouble();
        }

        @Override
        public Timestamp getTimestamp(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            long l = this.buffer.getLong();
            return new Timestamp(l);
        }

        @Override
        public String getString(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            int sz = this.buffer.getShort();
            char[] chars = new char[sz];
            for (int i = 0; i < sz; ++i) {
                chars[i] = this.buffer.getChar(i);
            }
            return new String(chars);
        }

        @Override
        public byte[] getBytes(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            int sz = this.buffer.getInt();
            byte[] bytes = new byte[sz];
            for (int i = 0; i < sz; ++i) {
                bytes[i] = this.buffer.get(i);
            }
            return bytes;
        }

        @Override
        public int getByte(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            return this.buffer.get();
        }

        @Override
        public int getShort(int n) {
            this.buffer.position(this.type.getFieldOffset(n));
            return this.buffer.getShort();
        }

        @Override
        public void setByte(int n, byte v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.put(v);
        }

        @Override
        public void setShort(int n, short v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putShort(v);
        }

        @Override
        public void setInt(int n, int v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putInt(v);
        }

        @Override
        public void setLong(int n, long v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putLong(v);
        }

        @Override
        public void setDouble(int n, double v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putDouble(v);
        }

        @Override
        public void setTimestamp(int n, Timestamp v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putLong(v.getTime());
        }

        @Override
        public void setString(int n, String v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putShort((short)v.length());
            for (int i = 0; i < v.length(); ++i) {
                this.buffer.putChar(v.charAt(i));
            }
        }

        @Override
        public void setBytes(int n, byte[] v) {
            this.buffer.position(this.type.getFieldOffset(n));
            this.buffer.putInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.buffer.put(v[i]);
            }
        }
    }
}

