/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.pdf.lib.impl;

import java.io.File;
import org.gvsig.fmap.dal.feature.AbstractDataProfile;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynobject.Tags;

public class PDFProfile
extends AbstractDataProfile {
    PDFProfile() {
        super("PDF", File.class);
    }

    protected Object doCreateData(Object pdf, Tags tags) {
        PDFManager manager = PDFLocator.getPDFManager();
        PDFDocument pdfdoc = manager.createPDFDocument();
        pdfdoc.setSource(pdf);
        return pdfdoc;
    }

    protected Object doCoerce(DataType dataType, Object data, Tags tags) throws CoercionException {
        try {
            switch (dataType.getType()) {
                case 12: {
                    PDFDocument document = PDFLocator.getPDFManager().createPDFDocument();
                    document.setSource(data);
                    return document.toByteArray();
                }
                case 13: {
                    if (data instanceof File) {
                        return data;
                    }
                }
                case 8: {
                    PDFDocument document = PDFLocator.getPDFManager().createPDFDocument();
                    document.setSource(data);
                    return document.toHexString();
                }
            }
        }
        catch (Exception ex) {
            throw new CoercionException("Can't convert pdf to " + dataType.getName(), (Throwable)ex);
        }
        throw new CoercionException("Can't convert pdf to " + dataType.getName());
    }
}

