/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFormAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyFormAction.class);
    private final DALActionFactory.DALActionContext context;

    public CopyFormAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "CopyForm");
        this.putValue("ShortDescription", i18n.getTranslation("_Copy_form"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("common-form-copy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            JFeaturesForm featuresForm = (JFeaturesForm)this.context.get("featuresform");
            if (featuresForm == null) {
                return;
            }
            this.setEnabled(false);
            JDynForm form = featuresForm.getFormset().getForm();
            String html = form.toHtml();
            toolsSwingManager.putInClipboard(html, "text/html");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't copy form", (Throwable)ex);
        }
        finally {
            this.setEnabled(true);
        }
    }

    public static class CopyFormActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "CopyForm";

        public CopyFormActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new CopyFormAction(context);
        }

        public boolean isApplicable(Object ... args) {
            if (!(args[0] instanceof DALActionFactory.DALActionContext)) {
                return false;
            }
            DALActionFactory.DALActionContext context = (DALActionFactory.DALActionContext)args[0];
            return StringUtils.equalsIgnoreCase((CharSequence)context.getName(), (CharSequence)"FormActionContext");
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new CopyFormActionFactory());
        }
    }
}

