/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator.suggestions;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.SuggestionProvider;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.Factory;

public class DivSuggestionProviderFactory
implements Factory {
    private FeatureType featureType;

    public DivSuggestionProviderFactory(FeatureStore store) {
        try {
            this.featureType = store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            this.featureType = null;
        }
    }

    public String getName() {
        return "DivSuggestion";
    }

    public Object create(Object ... parameters) {
        DivSuggestionProvider suggestionProvider = new DivSuggestionProvider();
        return suggestionProvider;
    }

    private class DivSuggestionProvider
    implements SuggestionProvider {
        private DivSuggestionProvider() {
        }

        public String getSuggestion(String expression) {
            if (StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            MutableBoolean showSuggestion = new MutableBoolean(false);
            try {
                Code code = ExpressionUtils.compile((String)expression);
                if (code == null) {
                    return null;
                }
                code.accept(obj -> {
                    if (obj instanceof Code.Callable) {
                        FeatureAttributeDescriptor attr;
                        Code.Callable callable = (Code.Callable)obj;
                        String name = callable.name();
                        if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"/")) {
                            return;
                        }
                        boolean isInt1 = false;
                        boolean isDec1 = false;
                        boolean isInt2 = false;
                        boolean isDec2 = false;
                        boolean isCast = false;
                        Code p1 = (Code)callable.parameters().get(0);
                        Code p2 = (Code)callable.parameters().get(1);
                        if (p1 instanceof Code.Constant) {
                            Code.Constant c1 = (Code.Constant)p1;
                            Object v1 = c1.value();
                            isInt1 = v1 instanceof Integer || v1 instanceof Long || v1 instanceof Short;
                            isDec1 = v1 instanceof Double || v1 instanceof Float || v1 instanceof BigDecimal;
                        } else if (p1 instanceof Code.Identifier) {
                            Code.Identifier i1 = (Code.Identifier)p1;
                            attr = DivSuggestionProviderFactory.this.featureType.getAttributeDescriptor(i1.name());
                            if (attr != null) {
                                int type1 = attr.getDataType().getType();
                                isInt1 = type1 == 4 || type1 == 5;
                                isDec1 = type1 == 19 || type1 == 7 || type1 == 6;
                            }
                        } else if (p1 instanceof Code.Callable && StringUtils.equalsIgnoreCase((CharSequence)((Code.Callable)p1).name(), (CharSequence)"CAST")) {
                            isCast = true;
                        }
                        if (p2 instanceof Code.Constant) {
                            Code.Constant c2 = (Code.Constant)p2;
                            Object v2 = c2.value();
                            isInt2 = v2 instanceof Integer || v2 instanceof Long || v2 instanceof Short;
                            isDec2 = v2 instanceof Double || v2 instanceof Float || v2 instanceof BigDecimal;
                        } else if (p2 instanceof Code.Identifier) {
                            Code.Identifier i2 = (Code.Identifier)p2;
                            attr = DivSuggestionProviderFactory.this.featureType.getAttributeDescriptor(i2.name());
                            if (attr != null) {
                                int type2 = attr.getDataType().getType();
                                isInt2 = type2 == 4 || type2 == 5;
                                isDec2 = type2 == 19 || type2 == 7 || type2 == 6;
                            }
                        } else if (p2 instanceof Code.Callable && StringUtils.equalsIgnoreCase((CharSequence)((Code.Callable)p2).name(), (CharSequence)"CAST")) {
                            isCast = true;
                        }
                        if (isCast) {
                            return;
                        }
                        if (isDec1 || isDec2) {
                            return;
                        }
                        if (isInt1 || isInt2 || !isInt1 && !isInt2) {
                            showSuggestion.setValue(true);
                            return;
                        }
                    }
                });
            }
            catch (Throwable code) {
                // empty catch block
            }
            if (showSuggestion.isFalse()) {
                return null;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            StringBuilder suggestion = new StringBuilder();
            suggestion.append(i18n.getTranslation("_Division_of_two_integer_values_returns_an_integer_value_You_can_force_an_operand_to_decimal_to_get_decimal_values"));
            return suggestion.toString();
        }
    }
}

