/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator.suggestions;

import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.swing.SuggestionProvider;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.Factory;

public class QuotesForFieldNameSuggestionProviderFactory
implements Factory {
    private static long lastSuggestedTime = 0L;
    private static final Pattern VALID_IDENTIFIER = Pattern.compile("[A-Za-z_]*[A-Za-z0-9_]*");
    private final FeatureStore store;
    private boolean suggestionApplies;

    public QuotesForFieldNameSuggestionProviderFactory(FeatureStore store) {
        this.store = store;
        String storename = store.getName();
        this.suggestionApplies = false;
        for (FeatureAttributeDescriptor attr : this.getFeatureAttributeDescriptors()) {
            if (VALID_IDENTIFIER.matcher(attr.getName()).matches()) continue;
            this.suggestionApplies = true;
            break;
        }
    }

    private Iterable<FeatureAttributeDescriptor> getFeatureAttributeDescriptors() {
        try {
            return this.store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            return Collections.EMPTY_LIST;
        }
    }

    public String getName() {
        return "QuotesForFieldNameSuggestion";
    }

    public Object create(Object ... parameters) {
        QuotesForFieldNameSuggestionProvider suggestionProvider = new QuotesForFieldNameSuggestionProvider();
        return suggestionProvider;
    }

    private class QuotesForFieldNameSuggestionProvider
    implements SuggestionProvider {
        private QuotesForFieldNameSuggestionProvider() {
        }

        public String getSuggestion(String expression) {
            if (!QuotesForFieldNameSuggestionProviderFactory.this.suggestionApplies || StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (now - lastSuggestedTime >= (long)(RandomUtils.nextInt((int)5, (int)15) * 60 * 1000)) {
                lastSuggestedTime = System.currentTimeMillis();
                I18nManager i18n = ToolsLocator.getI18nManager();
                String suggestion = i18n.getTranslation("_You_must_use_double_quotes_to_use_a_field_that_is_not_a_valid_identifier_When_the_name_does_not_start_with_a_letter_or_contains_characters_that_are_not_letters_numbers_or_underscore");
                return suggestion;
            }
            return null;
        }
    }
}

