/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.expressionevaluator.suggestions;

import java.util.Collections;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.SuggestionProvider;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.visitor.VisitCanceledException;

public class StorePointFieldSuggestionProviderFactory
implements Factory {
    private static long lastSuggestedTime = 0L;
    private final FeatureStore store;
    private boolean suggestionApplies;

    public StorePointFieldSuggestionProviderFactory(FeatureStore store) {
        this.store = store;
        String storename = store.getName();
        this.suggestionApplies = false;
        for (FeatureAttributeDescriptor attr : this.getFeatureAttributeDescriptors()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)storename, (CharSequence)attr.getName())) continue;
            this.suggestionApplies = true;
            break;
        }
    }

    private Iterable<FeatureAttributeDescriptor> getFeatureAttributeDescriptors() {
        try {
            return this.store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            return Collections.EMPTY_LIST;
        }
    }

    public String getName() {
        return "StorePointFieldSuggestion";
    }

    public Object create(Object ... parameters) {
        StorePointFieldSuggestionProvider suggestionProvider = new StorePointFieldSuggestionProvider();
        return suggestionProvider;
    }

    private class StorePointFieldSuggestionProvider
    implements SuggestionProvider {
        private StorePointFieldSuggestionProvider() {
        }

        public String getSuggestion(String expression) {
            if (!StorePointFieldSuggestionProviderFactory.this.suggestionApplies || StringUtils.isBlank((CharSequence)expression)) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (now - lastSuggestedTime >= (long)(RandomUtils.nextInt((int)5, (int)15) * 60 * 1000)) {
                lastSuggestedTime = System.currentTimeMillis();
                I18nManager i18n = ToolsLocator.getI18nManager();
                String suggestion = i18n.getTranslation("_You_can_access_the_fields_in_a_table_by_prefixing_the_table_name_followed_by_a_period_For_example_TABLE_FIELD_This_is_necessary_whenever_the_name_of_the_field_and_the_table_match");
                return suggestion;
            }
            MutableObject suggestion = new MutableObject();
            try {
                Code code = ExpressionUtils.compile((String)expression);
                if (code == null) {
                    return null;
                }
                String storename = StorePointFieldSuggestionProviderFactory.this.store.getName();
                code.accept(obj -> {
                    String varname;
                    if (obj instanceof Code.Identifier && StringUtils.equalsIgnoreCase((CharSequence)(varname = ((Code.Identifier)obj).name()), (CharSequence)storename)) {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        suggestion.setValue((Object)i18n.getTranslation("_You_can_access_the_fields_in_a_table_by_prefixing_the_table_name_followed_by_a_period_For_example_TABLE_FIELD_This_is_necessary_whenever_the_name_of_the_field_and_the_table_match"));
                        throw new VisitCanceledException();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return (String)suggestion.getValue();
        }
    }
}

