/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featurequery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.SymbolTableFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.featurequery.FeatureQueryGroupByPanel;
import org.gvsig.fmap.dal.swing.impl.featurequery.DefaultFeatureQueryGroupByPanelView;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributesSelectionPanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.FeatureAttributeListCellRendererImpl;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureQueryGroupByPanel
extends DefaultFeatureQueryGroupByPanelView
implements FeatureQueryGroupByPanel {
    protected Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureQueryGroupByPanel.class);
    private FeatureStore store;
    private FeatureType featureType;
    private FilteredListController attributesFilterController;
    private DefaultFeatureAttributesSelectionPanel groupByPanel;
    private FeatureQuery query;

    public DefaultFeatureQueryGroupByPanel() {
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public void setStore(FeatureStore store) {
        try {
            this.featureType = store.getDefaultFeatureType();
            this.store = store;
            this.query = store.createFeatureQuery();
            this.groupByPanel.setFeatureType(this.featureType);
            this.groupByPanel.setSelectedNames(this.query.getGroupByColumns());
            this.updateControls();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't assign store", ex);
        }
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.btnAttributesFilter);
        toolsSwingManager.translate(this.tabGroup);
        this.groupByPanel = new DefaultFeatureAttributesSelectionPanel();
        this.groupByPanel.allowCalculatedAttributes(true);
        this.pnlGroupByAttributes.setLayout(new BorderLayout());
        this.pnlGroupByAttributes.add((Component)this.groupByPanel, "Center");
        this.lstAttributes.setCellRenderer(new AttributesWithAggregateRenderer());
        this.lstAttributes.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectAttribute();
        });
        this.attributesFilterController = toolsSwingManager.createFilteredListController(this.lstAttributes, (JTextComponent)this.txtAttributesFilter, this.btnAttributesFilter);
        this.attributesFilterController.addChangeListener(ce -> this.doSelectAttribute());
        this.cboAggretateFunctions.addActionListener(e -> this.doSelectAggregateFunction());
        Dimension sz = this.getPreferredSize();
        if (sz.width < 650) {
            sz.width = 650;
        }
        if (sz.height < 320) {
            sz.height = 320;
        }
        this.setPreferredSize(sz);
    }

    private void doSelectAttribute() {
        FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)this.lstAttributes.getSelectedValue();
        if (attr == null) {
            this.txtCurrentAttributeName.setText("");
            this.cboAggretateFunctions.setSelectedIndex(0);
            return;
        }
        this.txtCurrentAttributeName.setText(attr.getName());
        String aggregate = this.query.getAggregateFunction(attr.getName());
        if (StringUtils.isBlank((CharSequence)aggregate) || aggregate.equalsIgnoreCase("<NULL>")) {
            this.cboAggretateFunctions.setSelectedIndex(0);
        } else {
            this.cboAggretateFunctions.setSelectedItem(aggregate);
        }
    }

    private void doSelectAggregateFunction() {
        String attribute = this.txtCurrentAttributeName.getText();
        if (!StringUtils.isBlank((CharSequence)attribute)) {
            String aggregate = (String)this.cboAggretateFunctions.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)aggregate) || aggregate.equalsIgnoreCase("<NULL>")) {
                this.query.removeAggregateFunction(attribute);
            } else {
                this.query.addAggregate(aggregate, attribute);
            }
            this.updateControls();
        }
    }

    private void updateControls() {
        int indexAttributes = this.lstAttributes.getSelectedIndex();
        if (this.cboAggretateFunctions.getModel().getSize() < 1) {
            ArrayList<String> aggregateFunctions = new ArrayList<String>();
            java.util.function.Function isAllowed = ((FeatureStoreProviderFactory)this.store.getProviderFactory()).allowFunction();
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            for (SymbolTableFactory factory : manager.getSymbolTableFactories()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)"Aggregate", (CharSequence)factory.getName())) continue;
                SymbolTable symbolTable = factory.create(new Object[0]);
                for (Function function : symbolTable) {
                    if ((Integer)isAllowed.apply(function.name()) == 2) continue;
                    aggregateFunctions.add(function.name());
                }
            }
            Collections.sort(aggregateFunctions);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement("<NULL>");
            for (String functionName : aggregateFunctions) {
                model.addElement(functionName);
            }
            this.cboAggretateFunctions.setModel(model);
            this.cboAggretateFunctions.setSelectedIndex(0);
            this.txtCurrentAttributeName.setText("");
        }
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        FilteredListModel model = toolsSwingManager.createFilteredListModel();
        for (FeatureAttributeDescriptor attr : this.featureType) {
            model.addElement((LabeledValue)attr);
        }
        for (FeatureAttributeDescriptor attr : this.featureType.getExtraColumns().getColumns()) {
            model.addElement((LabeledValue)attr);
        }
        for (FeatureAttributeDescriptor attr : this.query.getExtraColumn().getColumns()) {
            model.addElement((LabeledValue)attr);
        }
        model.setFilter(this.txtAttributesFilter.getText());
        model.sort(true);
        this.lstAttributes.setModel(model);
        this.lstAttributes.setSelectedIndex(indexAttributes);
    }

    public Map<String, String> getFixedConversion() {
        return this.query.getAggregateFunctions();
    }

    public FeatureQuery fetch(FeatureQuery query) {
        if (query == null) {
            FeatureQuery q = this.query.getCopy();
            q.getAggregateFunctions().clear();
            q.getAggregateFunctions().putAll(this.getFixedConversion());
            return q;
        }
        query.getGroupByColumns().clear();
        query.getGroupByColumns().addAll(this.groupByPanel.getSelectedNames());
        query.getAggregateFunctions().clear();
        query.getAggregateFunctions().putAll(this.getFixedConversion());
        return query;
    }

    public FeatureQuery fetch() {
        return this.fetch(null);
    }

    public void removeTypeConversion() {
        HashMap<String, String> fixed = new HashMap<String, String>();
        for (Map.Entry aggregate : this.query.getAggregateFunctions().entrySet()) {
            String key = (String)aggregate.getKey();
            String value = (String)aggregate.getValue();
            FeatureAttributeDescriptor attr = this.featureType.getAttributeDescriptorFromAll(value);
            if (attr == null && (attr = this.query.getExtraColumn().get(value)) == null) {
                switch (key.toLowerCase()) {
                    case "sum": {
                        Code code = ExpressionUtils.compile((String)value);
                        if (!(code instanceof Code.Callable)) break;
                        Code.Callable callable = (Code.Callable)code;
                        switch (callable.name().toLowerCase()) {
                            case "LET": {
                                value = ((Code.Identifier)callable.parameters().get(0)).name();
                            }
                        }
                    }
                }
            }
            fixed.put(key, value);
        }
        this.query.getAggregateFunctions().clear();
        this.query.getAggregateFunctions().putAll(fixed);
    }

    public void put(FeatureQuery query) {
        this.query.copyFrom(query);
        if (query == null) {
            this.groupByPanel.setSelectedNames(null);
            this.groupByPanel.setExtraColumns(null);
        } else {
            this.groupByPanel.setSelectedNames(this.query.getGroupByColumns());
            this.groupByPanel.setExtraColumns(this.query.getExtraColumn().getColumns());
        }
        this.updateControls();
    }

    public static void selfRegister() {
    }

    private class AttributesWithAggregateRenderer
    extends FeatureAttributeListCellRendererImpl {
        private AttributesWithAggregateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            FeatureAttributeDescriptor attrdesc = (FeatureAttributeDescriptor)value;
            String aggregate = DefaultFeatureQueryGroupByPanel.this.query.getAggregateFunction(attrdesc.getName());
            if (aggregate != null) {
                c.setText(c.getText() + "  [" + aggregate + "]");
            } else {
                c.setText(c.getText() + "  [<NULL>]");
            }
            return c;
        }
    }
}

