/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.swing.FeatureTableModel;
import org.gvsig.fmap.dal.swing.impl.featuretable.FeatureSelectionModel;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.DefaultFeatureTableModel;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.editors.FormattedCellEditor;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.editors.GeometryWKTCellEditor;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.renders.FeatureCellRenderer;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.renders.FormattedCellRenderer;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.renders.GeometryWKTCellRenderer;
import org.gvsig.fmap.dal.swing.impl.featuretable.table.renders.JToggleButtonHeaderCellRenderer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class FeatureTable
extends JTable
implements Observer,
Observable {
    private static final long serialVersionUID = -6139395189283163964L;
    private final FeatureTableModel featureTableModel;
    private JToggleButtonHeaderCellRenderer headerCellRenderer;
    private final Set<ActionListener> columnSelectionListeners;
    private static final int COLUMN_HEADER_MARGIN = 8;
    private static final int COLUMN_HEADER_MIN_WIDTH = 50;

    public FeatureTable(FeatureTableModel featureTableModel) {
        super((TableModel)featureTableModel);
        this.featureTableModel = featureTableModel;
        this.columnSelectionListeners = new HashSet<ActionListener>();
        this.init();
    }

    public void addColumnSelectionListener(ActionListener listener) {
        this.columnSelectionListeners.add(listener);
    }

    public void fireColumnSelection(ActionEvent e) {
        for (ActionListener listener : this.columnSelectionListeners) {
            try {
                listener.actionPerformed(e);
            }
            catch (Exception exception) {}
        }
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification fsNotification;
        String type;
        if (observable instanceof FeatureSelection) {
            this.repaint();
            return;
        }
        if (observable instanceof FeatureStore && "before_Delete_Feature".equals(type = (fsNotification = (FeatureStoreNotification)notification).getType()) && this.isEditing()) {
            ChangeEvent che = new ChangeEvent(this);
            this.editingCanceled(che);
        }
    }

    public void addObserver(Observer observer) {
        this.headerCellRenderer.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.headerCellRenderer.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.headerCellRenderer.deleteObservers();
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setDefaultRenderer(Geometry.class, new GeometryWKTCellRenderer());
        this.setDefaultEditor(Geometry.class, new GeometryWKTCellEditor());
        this.setDefaultRenderer(Feature.class, new FeatureCellRenderer());
        if (this.getModel() instanceof DefaultFeatureTableModel) {
            DefaultFeatureTableModel model = (DefaultFeatureTableModel)this.getModel();
            this.setDefaultRenderer(Double.class, new FormattedCellRenderer(model));
            this.setDefaultRenderer(Float.class, new FormattedCellRenderer(model));
            this.setDefaultRenderer(Integer.class, new FormattedCellRenderer(model));
            this.setDefaultRenderer(Long.class, new FormattedCellRenderer(model));
            this.setDefaultRenderer(Date.class, new FormattedCellRenderer(model));
            this.setDefaultEditor(Double.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Float.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Integer.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Long.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Date.class, new FormattedCellEditor(model));
        }
        this.setSelectionForeground(Color.blue);
        this.setSelectionBackground(Color.yellow);
    }

    private void init() {
        this.setAutoResizeMode(0);
        this.featureTableModel.getFeatureStore().addObserver((Observer)this);
        this.featureTableModel.getFeatureSelection().addObserver((Observer)this);
        this.featureTableModel.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("ChangeSelection".equals(e.getActionCommand())) {
                    FeatureTable.this.featureSelectionChanged();
                }
            }
        });
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionModel(new FeatureSelectionModel(this.featureTableModel));
        this.headerCellRenderer = new JToggleButtonHeaderCellRenderer(this);
        this.getTableHeader().setDefaultRenderer(this.headerCellRenderer);
        TableColumnModel tcmodel = this.getColumnModel();
        for (int i = 0; i < tcmodel.getColumnCount(); ++i) {
            TableColumn col = tcmodel.getColumn(i);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, col.getHeaderValue(), false, false, 0, i);
            int width = comp.getPreferredSize().width;
            width = width < 50 ? 50 : width;
            col.setPreferredWidth(width + 16);
        }
        this.setAutoResizeMode(3);
    }

    private void featureSelectionChanged() {
        this.featureTableModel.getFeatureSelection().addObserver((Observer)this);
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
    }

    @Override
    public int getSelectedColumnCount() {
        return this.headerCellRenderer.getSelectedColumns().length;
    }

    @Override
    public int[] getSelectedColumns() {
        return this.headerCellRenderer.getSelectedColumns();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getFirstRow() == -1 && this.headerCellRenderer != null) {
            this.headerCellRenderer.deselectAll();
        }
        super.tableChanged(e);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<?> resp = super.getColumnClass(column);
        if (Timestamp.class.isAssignableFrom(resp)) {
            return Object.class;
        }
        return resp;
    }

    @Override
    public int getSelectedRowCount() {
        return this.featureTableModel.getSelectionCount();
    }
}

