/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretable;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.impl.featuretable.SimpleFeaturesTableModelImpl;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class SimpleFeatureReferencesTableModelImpl
extends SimpleFeaturesTableModelImpl {
    public SimpleFeatureReferencesTableModelImpl(FeatureType featureType, List<FeatureReference> references, Expression filter) {
        super(featureType, null, SimpleFeatureReferencesTableModelImpl.createAdapter(references, filter));
    }

    private static List<Feature> createAdapter(List<FeatureReference> references, Expression filter) {
        if (ExpressionUtils.isPhraseEmpty((Expression)filter)) {
            return new FeatureReferenceListToFeatureListAdapter(references);
        }
        ArrayList<FeatureReference> r = new ArrayList<FeatureReference>();
        FeatureSymbolTable st = DALLocator.getDataManager().createFeatureSymbolTable();
        for (FeatureReference featureReference : r) {
            try {
                Feature f = featureReference.getFeature();
                st.setFeature(f);
                Object x = filter.execute((SymbolTable)st);
                if (!DataTypeUtils.isTrue((Object)x, (boolean)false)) continue;
                r.add(featureReference);
            }
            catch (Exception exception) {}
        }
        return new FeatureReferenceListToFeatureListAdapter(r);
    }

    private static class FeatureReferenceListToFeatureListAdapter
    extends AbstractList<Feature> {
        private final List<FeatureReference> references;
        private Feature lastFeature;
        private int lastIndex;

        public FeatureReferenceListToFeatureListAdapter(List<FeatureReference> references) {
            this.references = references;
            this.lastFeature = null;
            this.lastIndex = -1;
        }

        @Override
        public Feature get(int index) {
            if (index == this.lastIndex && this.lastFeature != null) {
                return this.lastFeature;
            }
            try {
                this.lastFeature = this.references.get(index).getFeature();
                this.lastIndex = index;
                return this.lastFeature;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public int size() {
            return this.references.size();
        }
    }
}

