/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.CalculatorController;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.DALExpressionBuilder;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.EditableForeingKey;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorAndExpressionPickerController;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.featuretype.FeatureTypeAttributePanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributePanelView;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultFeatureAttributeSelectionPanel;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.DefaultAggregateController;
import org.gvsig.fmap.dal.swing.impl.featuretype.availablevalues.AvailableValuesItemController;
import org.gvsig.fmap.dal.swing.impl.featuretype.availablevalues.AvailableValuesModel;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.Tag;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagItemController;
import org.gvsig.fmap.dal.swing.impl.featuretype.tags.TagsModel;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureAttributePanel
extends DefaultFeatureAttributePanelView
implements FeatureTypeAttributePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureAttributePanel.class);
    private final JTextComponent txtMaxValue = new JTextField();
    private final JTextComponent txtMinValue = new JTextField();
    private final JComponent lblMinValue = new JLabel();
    private final JComponent lblMaxValue = new JLabel();
    private Feature sampleFeature;
    private String previousDefaultValue;
    private ToManyController toManyController;
    private JSplitPane splAttrTags;
    private JSplitPane splAttrAvailableValues;
    private FeatureType featureType;
    private IProjection defaultProjection;
    private final List<ListElement<Integer>> fieldTypes;
    private final List<ListElement<Integer>> geometryTypes;
    private final List<ListElement<Integer>> geometrySubtypes;
    private DatePickerController pickerIntervalEnd;
    private DatePickerController pickerIntervalStart;
    private CalculatorController<Integer> pickerSize;
    private CalculatorController<Integer> pickerDisplaySize;
    private CalculatorController<Integer> pickerPrecision;
    private CalculatorController<Integer> pickerScale;
    private PickerController<Locale> pickerLocale;
    private PickerController<IProjection> pickerCRS;
    private ExpressionPickerController pickerVirtualFieldGetter;
    private ExpressionPickerController pickerVirtualFieldSetter;
    private ExpressionPickerController pickerDefaultFormat;
    private CalculatorController<Integer> pickerOrder;
    private AggregateController<Tag> tagsController;
    private AggregateController<DynObjectValueItem> availableValuesController;
    private ToOneController toOneController;
    private ExpressionPickerController pickerValuesFilter;
    private ExpressionPickerController pickerValuesExpression;
    private int mode = 2;
    private FeatureStoreElement featureStoreElement;

    public DefaultFeatureAttributePanel() {
        DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
        this.fieldTypes = new ArrayList<ListElement<Integer>>();
        this.fieldTypes.add((ListElement<Integer>)new ListElement("Decimal", (Object)19));
        this.fieldTypes.add((ListElement<Integer>)new ListElement("Integer", (Object)4));
        this.fieldTypes.add((ListElement<Integer>)new ListElement("Long", (Object)5));
        this.fieldTypes.add((ListElement<Integer>)new ListElement("String", (Object)8));
        this.fieldTypes.add((ListElement<Integer>)new ListElement("Boolean", (Object)1));
        this.fieldTypes.add((ListElement<Integer>)new ListElement("Date", (Object)9));
        this.fieldTypes.add((ListElement<Integer>)new ListElement("Date/Time (Timestamp)", (Object)11));
        this.fieldTypes.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
        this.geometryTypes = new ArrayList<ListElement<Integer>>();
        this.geometryTypes.add((ListElement<Integer>)new ListElement("Point", (Object)1));
        this.geometryTypes.add((ListElement<Integer>)new ListElement("Line", (Object)18));
        this.geometryTypes.add((ListElement<Integer>)new ListElement("Polygon", (Object)19));
        this.geometryTypes.add((ListElement<Integer>)new ListElement("MultiPoint", (Object)7));
        this.geometryTypes.add((ListElement<Integer>)new ListElement("MultiLine", (Object)21));
        this.geometryTypes.add((ListElement<Integer>)new ListElement("MultiPolygon", (Object)22));
        this.geometryTypes.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
        this.geometrySubtypes = new ArrayList<ListElement<Integer>>();
        this.geometrySubtypes.add((ListElement<Integer>)new ListElement("2D", (Object)0));
        this.geometrySubtypes.add((ListElement<Integer>)new ListElement("2DM", (Object)2));
        this.geometrySubtypes.add((ListElement<Integer>)new ListElement("3D", (Object)1));
        this.geometrySubtypes.add((ListElement<Integer>)new ListElement("3DM", (Object)3));
        this.geometrySubtypes.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager evaluatorSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        final DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
        this.translate();
        ToolsSwingUtils.ensureMaxRows((JComponent)this.gridAttrTagsTable, (int)10);
        this.splAttrTags = ToolsSwingUtils.createVerticalSplit((JPanel)this.gridAttrTags, (JPanel)this.gridAttrTagsTable, (boolean)false, (JPanel)this.gridAttrTagsItem, (boolean)true);
        ToolsSwingUtils.ensureMaxRows((JComponent)this.gridAttrAvailableValuesTable, (int)10);
        this.splAttrAvailableValues = ToolsSwingUtils.createVerticalSplit((JPanel)this.gridAttrAvailableValues, (JPanel)this.gridAttrAvailableValuesTable, (boolean)false, (JPanel)this.gridAttrAvailableValuesItem, (boolean)true);
        DefaultComboBoxModel<ListElement<Integer>> modelTypes = new DefaultComboBoxModel<ListElement<Integer>>();
        for (ListElement<Integer> listElement : this.fieldTypes) {
            modelTypes.addElement(listElement);
        }
        this.cboFieldType.setModel(modelTypes);
        this.cboFieldType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(null);
                try {
                    DataType dataType = dataTypeManager.get(((Integer)value).intValue());
                    IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
                    if (theme.exists(dataType.getIconName())) {
                        label.setIcon(theme.get(dataType.getIconName()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return label;
            }
        });
        DefaultComboBoxModel<ListElement<Integer>> modelGeomTypes = new DefaultComboBoxModel<ListElement<Integer>>();
        for (ListElement<Integer> listElement : this.geometryTypes) {
            modelGeomTypes.addElement(listElement);
        }
        this.cboGeometryType.setModel(modelGeomTypes);
        DefaultComboBoxModel<ListElement<Integer>> defaultComboBoxModel = new DefaultComboBoxModel<ListElement<Integer>>();
        for (ListElement<Integer> listElement : this.geometrySubtypes) {
            defaultComboBoxModel.addElement(listElement);
        }
        this.cboGeometrySubtype.setModel(defaultComboBoxModel);
        swingManager.addClearButton((JTextComponent)this.txtDefaultValue);
        swingManager.addClearButton((JTextComponent)this.txtDefaultFormat);
        swingManager.addClearButton((JTextComponent)this.txtFieldName);
        swingManager.addClearButton((JTextComponent)this.txtIntervalEnd);
        swingManager.addClearButton((JTextComponent)this.txtIntervalStart);
        swingManager.addClearButton((JTextComponent)this.txtScale);
        swingManager.addClearButton((JTextComponent)this.txtSize);
        swingManager.addClearButton((JTextComponent)this.txtDisplaySize);
        swingManager.addClearButton((JTextComponent)this.txtLabel);
        swingManager.addClearButton((JTextComponent)this.txtDescription);
        swingManager.addClearButton(this.cboGroup);
        swingManager.addClearButton(this.txtMaxValue);
        swingManager.addClearButton(this.txtMinValue);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtDefaultValue);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtDefaultFormat);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtFieldName);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtIntervalEnd);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtIntervalStart);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtScale);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtSize);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtDisplaySize);
        swingManager.setDefaultPopupMenu(this.cboDateFormat);
        swingManager.setDefaultPopupMenu(this.cboFieldType);
        swingManager.setDefaultPopupMenu(this.cboGeometrySubtype);
        swingManager.setDefaultPopupMenu(this.cboGeometryType);
        swingManager.setDefaultPopupMenu(this.cboDataProfile);
        swingManager.setDefaultPopupMenu(this.cboGroup);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtOrder);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtLabel);
        swingManager.setDefaultPopupMenu((JTextComponent)this.txtDescription);
        swingManager.setDefaultPopupMenu(this.txtMinValue);
        swingManager.setDefaultPopupMenu(this.txtMaxValue);
        this.toOneController = new ToOneController(this.txtRelationToOneMyFieldName, this.cboRelationToOneType, this.chkRelationToOneIsClosedList, this.chkCanBeOptimizedByProvider, this.cboRelationToOneTableName, this.cboRelationToOneCodeName, this.cboRelationToOneFormula, this.btnRelationToOneFormula, this.btnRelationToOneFormulaBookmarks, this.btnRelationToOneFormulaHistory);
        this.toManyController = new ToManyController(this.cboRelationToManyType, this.cboRelationToManyMyFieldName, this.cboRelationToManyTableName, this.cboRelationToManyForeignFieldName, this.txtRelationToManyExpression, this.btnRelationToManyExpression, this.btnRelationToManyExpressionHistory, this.btnRelationToManyExpressionBookmarks);
        this.pickerIntervalEnd = swingManager.createDatePickerController((JTextComponent)this.txtIntervalEnd, this.btnIntervalEnd);
        this.pickerIntervalStart = swingManager.createDatePickerController((JTextComponent)this.txtIntervalStart, this.btnIntervalStart);
        this.pickerSize = evaluatorSwingManager.createCalculatorController((JTextComponent)this.txtSize, 4);
        this.pickerDisplaySize = evaluatorSwingManager.createCalculatorController((JTextComponent)this.txtDisplaySize, 4);
        this.pickerPrecision = evaluatorSwingManager.createCalculatorController((JTextComponent)this.txtPrecision, 4);
        this.pickerScale = evaluatorSwingManager.createCalculatorController((JTextComponent)this.txtScale, 4);
        this.pickerLocale = swingManager.createLocalePickerController(this.cboLocale);
        this.txtDefaultValue.getComponentPopupMenu().add(evaluatorSwingManager.createJExpressionBuilderAction((JTextComponent)this.txtDefaultValue));
        this.pickerOrder = evaluatorSwingManager.createCalculatorController((JTextComponent)this.txtOrder, 4);
        this.availableValuesController = new DefaultAggregateController<DynObjectValueItem>(this.tblAvailableValuesItems, this.btnAvailableValuesModify, this.btnAvailableValuesDiscard, this.btnAvailableValuesAccept, this.btnAvailableValuesNew, this.btnAvailableValuesDelete, new AvailableValuesItemController(this.txtAvailableValuesItemLabel, this.txtAvailableValuesItemValue));
        this.tagsController = new DefaultAggregateController<Tag>(this.tblAttrTagsItems, this.btnAttrTagsModify, this.btnAttrTagsDiscard, this.btnAttrTagsAccept, this.btnAttrTagsNew, this.btnAttrTagsDelete, new TagItemController(this.cboAttrTagsItemName, this.cboAttrTagsItemValue, this.lblAttrTagsItemNotesValue));
        this.txtMinValue.setEnabled(false);
        this.txtMaxValue.setEnabled(false);
        this.btnVirtualFieldGetter.setText("");
        this.featureStoreElement = dataSwingManager.createFeatureStoreElement();
        this.pickerVirtualFieldGetter = evaluatorSwingManager.createExpressionPickerController((JTextComponent)this.txtVirtualFieldGetter, this.btnVirtualFieldGetter, this.btnVirtualFieldBookmarksGetter, this.btnVirtualFieldHistoryGetter);
        this.pickerVirtualFieldGetter.getConfig().addElement((Element)this.featureStoreElement);
        this.pickerVirtualFieldSetter = evaluatorSwingManager.createExpressionPickerController((JTextComponent)this.txtVirtualFieldSetter, this.btnVirtualFieldSetter, this.btnVirtualFieldBookmarksSetter, this.btnVirtualFieldHistorySetter);
        this.pickerVirtualFieldSetter.getConfig().addElement((Element)this.featureStoreElement);
        this.chkVirtualField.addChangeListener(e -> {
            if (this.chkVirtualField.isSelected()) {
                this.pickerVirtualFieldGetter.setEditable(this.mode == 1 || this.mode == 0 || this.mode == 100);
                this.pickerVirtualFieldSetter.setEditable(false);
            } else {
                this.pickerVirtualFieldGetter.setEditable(false);
                this.pickerVirtualFieldSetter.setEditable(false);
            }
        });
        this.pickerCRS = dataSwingManager.createProjectionPickerController(this.txtCRS, this.btnCRS);
        this.cboFieldType.addItemListener(e -> SwingUtilities.invokeLater(() -> this.doFieldTypeChanged()));
        this.pickerPrecision.addChangeListener(e -> this.doCheckPrecisionAndScale());
        this.pickerScale.addChangeListener(e -> this.doCheckPrecisionAndScale());
        DefaultComboBoxModel<ListElement> defaultComboBoxModel2 = new DefaultComboBoxModel<ListElement>();
        defaultComboBoxModel2.addElement(new ListElement("", null));
        for (DataProfile profile : DALLocator.getDataManager().getDataProfiles()) {
            defaultComboBoxModel2.addElement(new ListElement(profile.getName(), (Object)profile.getID()));
        }
        this.cboDataProfile.setModel(defaultComboBoxModel2);
        this.btnFieldType.addActionListener(e -> this.doDataTypeSelection());
        this.pickerValuesFilter = evaluatorSwingManager.createExpressionPickerController((JTextComponent)this.txtValuesFilter, this.btnValuesFilter, this.btnValuesFilterBookmarks, this.btnValuesFilterHistory);
        this.pickerValuesFilter.getConfig().addElement((Element)this.featureStoreElement);
        this.pickerValuesExpression = evaluatorSwingManager.createExpressionPickerController((JTextComponent)this.txtValuesExpression, this.btnValuesExpression, this.btnValuesExpressionBookmarks, this.btnValuesExpressionHistory);
        this.pickerValuesExpression.getConfig().addElement((Element)this.featureStoreElement);
        this.chkIsAutomatic.addActionListener(e -> this.doIsAutomaticChanged());
        this.rdbRelationNone.addItemListener(e -> this.doChangeRelationType());
        this.rdbRelationToOne.addItemListener(e -> this.doChangeRelationType());
        this.rdbRelationToMany.addItemListener(e -> this.doChangeRelationType());
        this.chkDefaultValue.addActionListener(e -> this.txtDefaultValue.setEditable(!this.chkDefaultValue.isSelected()));
        SwingUtilities.invokeLater(() -> {
            this.splAttrTags.setDividerLocation(0.4);
            this.splAttrAvailableValues.setDividerLocation(0.4);
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)16, (int)95);
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        swingManager.translate(this.lblAllowNulls);
        swingManager.translate(this.lblCRS);
        swingManager.translate(this.lblDataProfile);
        swingManager.translate(this.lblDateFormat);
        swingManager.translate(this.lblDefaultValue);
        swingManager.translate((AbstractButton)this.chkDefaultValue);
        swingManager.translate(this.lblDefaultFormat);
        swingManager.translate(this.lblFieldName);
        swingManager.translate(this.lblFieldType);
        swingManager.translate(this.lblGeometrySubtype);
        swingManager.translate(this.lblGeometryType);
        swingManager.translate(this.lblInterval);
        swingManager.translate(this.lblIntervalEnd);
        swingManager.translate(this.lblIntervalStart);
        swingManager.translate(this.lblIsAutomatic);
        swingManager.translate(this.lblIsIndexed);
        swingManager.translate(this.lblAllowIndexDuplicateds);
        swingManager.translate(this.lblIsReadOnly);
        swingManager.translate(this.lblIsPrimaryKey);
        swingManager.translate(this.lblPrecision);
        swingManager.translate(this.lblScale);
        swingManager.translate(this.lblSize);
        swingManager.translate(this.lblDisplaySize);
        swingManager.translate((AbstractButton)this.chkVirtualField);
        swingManager.translate(this.lblVirtualField);
        swingManager.translate((JComponent)this.lblVirtualFieldSep);
        swingManager.translate(this.lblVirtualFieldGetter);
        swingManager.translate(this.lblVirtualFieldSetter);
        swingManager.translate(this.tabAditionalFields);
        swingManager.translate(this.tabLayout);
        swingManager.translate(this.lblGroup);
        swingManager.translate(this.lblOrder);
        swingManager.translate(this.lblHidden);
        swingManager.translate(this.lblLabel);
        swingManager.translate(this.lblDescription);
        swingManager.translate(this.lblMinValue);
        swingManager.translate(this.lblMaxValue);
        swingManager.translate(this.lblAvailableValues);
        swingManager.translate(this.lblAvailableValuesItemLabel);
        swingManager.translate(this.lblAvailableValuesItemValue);
        swingManager.translate(this.lblAttrTagsItemName);
        swingManager.translate(this.lblAttrTagsItemValue);
        swingManager.translate(this.lblAttrTagsItemNotes);
        swingManager.translate(this.lblValuesFilter);
        swingManager.translate(this.lblValuesExpression);
        swingManager.translate(this.lblRelationRepository);
        swingManager.translate(this.lblRelationNone);
        swingManager.translate(this.lblRelationToOne);
        swingManager.translate(this.lblRelationToMany);
        swingManager.translate(this.lblRelationToOneType);
        swingManager.translate(this.lblRelationToOneCondition);
        swingManager.translate(this.lblRelationToOneLabelFormula);
        swingManager.translate(this.lblRelationToOneIsClosedList);
        swingManager.translate(this.lblRelationToManyType);
        swingManager.translate(this.lblRelationToManyExpression);
        swingManager.translate(this.lblRelationToManyCondition);
        swingManager.translate((JComponent)this.txtDisplaySize);
        swingManager.translate((JComponent)this.txtPrecision);
        swingManager.translate((JComponent)this.txtScale);
        swingManager.translate((JComponent)this.txtScale);
        swingManager.translate(this.lblLocale);
        swingManager.translate((AbstractButton)this.rdbRelationToMany);
        this.lblRelationToMany.setText(this.lblRelationToMany.getText() + "  (" + i18n.getTranslation("_Requires_that_it_be_a_calculated_field_of_list_type") + ")");
        swingManager.translate(this.lblRelationVirtual);
        swingManager.translate(this.lblRelationReferences1);
        swingManager.translate(this.lblRelationReferences2);
        swingManager.translate((AbstractButton)this.chkCanBeOptimizedByProvider);
        swingManager.translate(this.lblCanBeOptimizedByProvider);
    }

    private int getRelationType() {
        if (this.rdbRelationNone.isSelected()) {
            return 0;
        }
        if (this.rdbRelationToOne.isSelected()) {
            return this.toOneController.getRelationType();
        }
        if (this.rdbRelationToMany.isSelected()) {
            return this.toManyController.getRelationType();
        }
        return 0;
    }

    private void doChangeRelationType() {
        boolean enabled;
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 100: {
                enabled = true;
                break;
            }
            default: {
                enabled = false;
            }
        }
        this.rdbRelationNone.setEnabled(enabled);
        this.rdbRelationToOne.setEnabled(enabled && !this.getDataType().isObject() && !this.getDataType().isContainer());
        this.rdbRelationToMany.setEnabled(enabled && (this.isVirtualField() || this.getDataType().getType() == 34));
        if (this.rdbRelationNone.isSelected()) {
            this.pickerVirtualFieldGetter.setEnabled(enabled);
            this.toOneController.setEnabled(false);
            this.toManyController.setEnabled(false);
        } else if (this.rdbRelationToOne.isSelected()) {
            this.pickerVirtualFieldGetter.setEnabled(enabled);
            this.toManyController.setEnabled(false);
            this.toOneController.setEditable(enabled);
            this.toOneController.setEnabled(enabled);
        } else if (this.rdbRelationToMany.isSelected()) {
            if (!this.isVirtualField() || this.getDataType().getType() != 34) {
                this.rdbRelationNone.setSelected(true);
            } else {
                this.pickerVirtualFieldGetter.setEnabled(false);
                this.toOneController.setEnabled(false);
                this.toManyController.setEditable(enabled);
                this.toManyController.setEnabled(enabled);
            }
        }
        this.toOneController.updateEnabledState();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doIsAutomaticChanged() {
        if (this.chkIsAutomatic.isSelected()) {
            DataType type = this.getDataType();
            String defaultValue = this.chkDefaultValue.isSelected() ? null : this.txtDefaultValue.getText();
            if (type.getType() != 5 || StringUtils.isNotBlank((CharSequence)defaultValue)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_The_automatic_fields_must_be_of_type_long_and_do_not_support_default_values") + "\n" + i18n.getTranslation("_The_type_and_the_default_value_will_be_changed_to_adapt_them_to_these_needs"), (String[])null, i18n.getTranslation("_Warning"), 1, "_Automatic_field_flag_force_the_type_to_long_and_an_empty_default_value");
                ListElement.setSelected((JComboBox)this.cboFieldType, (Object)5);
                this.txtDefaultValue.setText("");
            }
        }
        this.updateEditableStates();
    }

    private void doDataTypeSelection() {
        final DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ArrayList<ListElement> types = new ArrayList<ListElement>();
        for (Object dataType : dataManager) {
            types.add(new ListElement(dataType.getName(), (Object)dataType.getType()));
        }
        types.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
        DefaultListModel<ListElement> modelTypes = new DefaultListModel<ListElement>();
        for (ListElement element : types) {
            modelTypes.addElement(element);
        }
        JList<Object> list = new JList<Object>();
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(null);
                try {
                    DataType dataType = dataManager.get(((Integer)value).intValue());
                    IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
                    if (theme.exists(dataType.getIconName())) {
                        label.setIcon(theme.get(dataType.getIconName()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return label;
            }
        });
        list.setModel(modelTypes);
        JScrollPane scrollpanel = new JScrollPane(list);
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winManager.createDialog((JComponent)scrollpanel, i18n.getTranslation("_Data_type_selection"), i18n.getTranslation("_Select_the_data_type"), 3);
        dialog.addActionListener(e -> {
            Integer type;
            if (dialog.getAction() == 1 && (type = (Integer)ListElement.getSelected((JList)list)) != null) {
                ListElement.setSelected((JComboBox)this.cboFieldType, (Object)type);
                if (ListElement.getSelected((JComboBox)this.cboFieldType) == null) {
                    DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
                    DataType dataType = dataTypeManager.get(type.intValue());
                    this.cboFieldType.addItem(new ListElement(dataType.getName(), (Object)dataType.getType()));
                    ListElement.setSelected((JComboBox)this.cboFieldType, (Object)dataType.getType());
                }
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private int getMaxAttributeSize(EditableFeatureAttributeDescriptor descriptor) {
        FeatureStore store = descriptor.getStore();
        if (store == null) {
            return -1;
        }
        DataStoreProviderFactory providerFactory = store.getProviderFactory();
        if (providerFactory == null) {
            return -1;
        }
        return ((FeatureStoreProviderFactory)providerFactory).getMaxAttributeNameSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditableFeatureAttributeDescriptor fetch(EditableFeatureAttributeDescriptor descriptor) {
        block29: {
            I18nManager i18n = ToolsLocator.getI18nManager();
            try {
                ThreadSafeDialogsManager dialogs;
                int n;
                if (this.pickerPrecision.get() != null && this.pickerDisplaySize.get() != null && (Integer)this.pickerPrecision.get() > (Integer)this.pickerDisplaySize.get() && (n = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_The_precision_is_greater_than_the_display_size") + "\n" + i18n.getTranslation("_This_can_cause_problems_with_some_data_providers_like_SHP_or_DBF") + "\n" + i18n.getTranslation("_Do_you_want_to_continue_accepting_the_current_values"), i18n.getTranslation("_Warning"), 0, 2)) != 0) {
                    return null;
                }
                if (!this.chkAllowNulls.isSelected() && descriptor.allowNull()) {
                    dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_You_have_marked_not_allow_nulls") + "\n" + i18n.getTranslation("If_you_are_not_fully_aware_of_the_repercussions_of_this_it_is_advisable_to_allow_nulls"), null, i18n.getTranslation("_Warning"), 1, "AllowNullsInFeatureTypeEditing");
                }
                descriptor.setDataType(((Integer)ListElement.getSelected((JComboBox)this.cboFieldType)).intValue());
                int maxAttributeNameSize = this.getMaxAttributeSize(descriptor);
                String attrName = this.txtFieldName.getText();
                if (maxAttributeNameSize > -1 && StringUtils.length((CharSequence)attrName) > maxAttributeNameSize) {
                    ThreadSafeDialogsManager dialogs2 = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs2.messageDialog(i18n.getTranslation("_Attribute_name_is_too_long") + "\n" + i18n.getTranslation("_max_size_allowed_for_this_table_is_{0}", new String[]{String.valueOf(maxAttributeNameSize)}), null, i18n.getTranslation("_Warning"), 2);
                    return null;
                }
                descriptor.setName(attrName);
                descriptor.setAllowNull(this.chkAllowNulls.isSelected());
                descriptor.setIsPrimaryKey(this.chkIsPrimaryKey.isSelected());
                descriptor.setIsAutomatic(this.chkIsAutomatic.isSelected());
                descriptor.setIsReadOnly(this.chkIsReadOnly.isSelected());
                descriptor.setIsIndexed(this.chkIsIndexed.isSelected());
                descriptor.setAllowIndexDuplicateds(this.chkAllowIndexDuplicateds.isSelected());
                descriptor.setSize(((Integer)this.pickerSize.get((Object)0)).intValue());
                descriptor.setDisplaySize(((Integer)this.pickerDisplaySize.get((Object)0)).intValue());
                descriptor.setPrecision(((Integer)this.pickerPrecision.get((Object)0)).intValue());
                descriptor.setScale(((Integer)this.pickerScale.get((Object)0)).intValue());
                String defaultValue = this.chkDefaultValue.isSelected() ? null : this.txtDefaultValue.getText();
                switch (this.mode) {
                    case 0: {
                        if (!ExpressionUtils.isDynamicText((String)defaultValue) && !StringUtils.equals((CharSequence)this.previousDefaultValue, (CharSequence)defaultValue)) {
                            ThreadSafeDialogsManager dialogs3 = ToolsSwingLocator.getThreadSafeDialogsManager();
                            dialogs3.messageDialog(i18n.getTranslation("_In_metadata_editing_only_mode_it_is_only_allowed_to_indicate_default_values_with_dynamic_expressions"), null, i18n.getTranslation("_Warning"), 2);
                            return null;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 100: {
                        descriptor.setDefaultValue((Object)defaultValue);
                    }
                }
                descriptor.setDefaultFormat(this.txtDefaultFormat.getText());
                descriptor.setDataProfileName((String)ListElement.getSelected((JComboBox)this.cboDataProfile));
                switch (descriptor.getType()) {
                    case 66: {
                        if (ListElement.getSelected((JComboBox)this.cboGeometryType) == null || ListElement.getSelected((JComboBox)this.cboGeometrySubtype) == null || this.pickerCRS.get() == null) {
                            ThreadSafeDialogsManager dialogs4 = ToolsSwingLocator.getThreadSafeDialogsManager();
                            dialogs4.messageDialog(i18n.getTranslation("_Geometry_not_configured"), null, i18n.getTranslation("_Warning"), 2);
                            return null;
                        }
                        GeometryManager geomManager = GeometryLocator.getGeometryManager();
                        GeometryType geomType = geomManager.getGeometryType(((Integer)ListElement.getSelected((JComboBox)this.cboGeometryType)).intValue(), ((Integer)ListElement.getSelected((JComboBox)this.cboGeometrySubtype)).intValue());
                        descriptor.setGeometryType(geomType);
                        descriptor.setSRS((IProjection)this.pickerCRS.get());
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 68: 
                    case 69: {
                        break;
                    }
                }
                descriptor.setDataProfileName((String)StringUtils.defaultIfBlank((CharSequence)((String)ListElement.getSelected((JComboBox)this.cboDataProfile)), null));
                if (!this.chkVirtualField.isSelected()) break block29;
                Expression expression = this.pickerVirtualFieldGetter.get();
                if (expression == null) {
                    descriptor.setFeatureAttributeEmulator((String)null);
                    break block29;
                }
                DataManager dataManager = DALLocator.getDataManager();
                FeatureAttributeEmulatorExpression emulator = dataManager.createFeatureAttributeEmulatorExpression(this.getFeatureType((FeatureAttributeDescriptor)descriptor), expression);
                if (!emulator.isValid()) {
                    ThreadSafeDialogsManager dialogs5 = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs5.messageDialog(i18n.getTranslation("_The_expression_of_virtual_field_is_not_valid") + "\n" + "\n" + emulator.getErrorMessage(), i18n.getTranslation("_Warning"), 2);
                    return null;
                }
                for (String requiredFieldName : emulator.getRequiredFieldNames()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)requiredFieldName, (CharSequence)descriptor.getName())) continue;
                    ThreadSafeDialogsManager dialogs6 = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs6.messageDialog(i18n.getTranslation("_The_expression_of_virtual_field_is_not_valid") + "\n\n" + i18n.getTranslation("_The_expression_contains_a_reference_to_itself"), i18n.getTranslation("_Warning"), 2);
                    return null;
                }
                List undefinedSymbols = emulator.getUndefinedSymbols();
                if (undefinedSymbols != null && !undefinedSymbols.isEmpty()) {
                    ThreadSafeDialogsManager dialogs7 = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs7.messageDialog(i18n.getTranslation("_The_expression_has_undefined_symbols_at_this_moment") + "\n" + i18n.getTranslation("_This_may_not_be_a_mistake") + "\n" + "\n" + "(" + StringUtils.join((Iterable)undefinedSymbols, (String)",") + ")", i18n.getTranslation("_Warning"), 2);
                }
                try {
                    emulator.setEnableExceptions(true);
                    emulator.get(this.sampleFeature);
                }
                catch (Throwable ex) {
                    ThreadSafeDialogsManager dialogs8 = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs8.messageDialog(i18n.getTranslation("_The_expression_can_not_be_evaluated_right_now_It_could_be_valid_when_all_changes_has_been_applied") + "\n" + ex.getMessage(), i18n.getTranslation("_Warning"), 2);
                }
                finally {
                    emulator.setEnableExceptions(false);
                }
                descriptor.setFeatureAttributeEmulator((FeatureAttributeEmulator)emulator);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't retrieve information from user form.", (Throwable)ex);
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_Cant_retrieve_information_from_user_form") + "\n" + i18n.getTranslation("_See_log_for_details"), i18n.getTranslation("_Warning"), 2);
                return null;
            }
        }
        descriptor.setGroup((String)StringUtils.defaultIfBlank((CharSequence)((String)this.cboGroup.getSelectedItem()), null));
        descriptor.setOrder(((Integer)this.pickerOrder.get((Object)0)).intValue());
        descriptor.setHidden(this.chkHidden.isSelected());
        descriptor.setLabel((String)StringUtils.defaultIfBlank((CharSequence)this.txtLabel.getText(), null));
        descriptor.setDescription((String)StringUtils.defaultIfBlank((CharSequence)this.txtDescription.getText(), null));
        Expression valuesFilter = this.pickerValuesFilter.get();
        descriptor.setAvailableValuesFilter(valuesFilter);
        Expression valuesExpression = this.pickerValuesExpression.get();
        descriptor.setAvailableValuesExpression(valuesExpression);
        descriptor.setLocale((Locale)this.pickerLocale.get());
        this.availableValuesController.getModel().fetch(descriptor);
        this.tagsController.getModel().fetch(descriptor.getTags());
        this.toOneController.fetch(descriptor);
        this.toManyController.fetch(descriptor);
        if (this.rdbRelationToOne.isSelected()) {
            descriptor.setRelationType(this.toOneController.getRelationType());
            descriptor.getForeingKey().setForeingKey(true);
        } else if (this.rdbRelationToMany.isSelected()) {
            descriptor.setRelationType(this.toManyController.getRelationType());
            descriptor.getForeingKey().setForeingKey(false);
            descriptor.setFeatureAttributeEmulator(this.toManyController.getExpression());
        } else if (this.rdbRelationNone.isSelected()) {
            descriptor.setRelationType(0);
            descriptor.getForeingKey().setForeingKey(false);
        }
        return descriptor;
    }

    public void clean() {
        this.txtDefaultValue.setText("");
        this.chkDefaultValue.setEnabled(true);
        this.txtDefaultValue.setEditable(false);
        this.txtDefaultFormat.setText("");
        this.txtFieldName.setText("");
        this.pickerIntervalEnd.set(null);
        this.pickerIntervalStart.set(null);
        this.pickerScale.set(null);
        this.pickerSize.set(null);
        this.pickerDisplaySize.set(null);
        this.chkAllowNulls.setSelected(false);
        this.chkIsAutomatic.setSelected(false);
        this.chkIsReadOnly.setSelected(false);
        this.chkIsIndexed.setSelected(false);
        this.chkIsPrimaryKey.setSelected(false);
        switch (this.mode) {
            case 0: 
            case 1: {
                this.chkVirtualField.setSelected(false);
                this.chkVirtualField.setEnabled(true);
                break;
            }
            case 2: {
                this.chkVirtualField.setSelected(false);
                this.chkVirtualField.setEnabled(false);
                break;
            }
            case 100: {
                this.chkVirtualField.setSelected(true);
                this.chkVirtualField.setEnabled(false);
            }
        }
        this.pickerVirtualFieldGetter.setEditable(false);
        this.pickerVirtualFieldGetter.set(null);
        ListElement.setSelected((JComboBox)this.cboGeometryType, null);
        ListElement.setSelected((JComboBox)this.cboGeometrySubtype, null);
        ListElement.setSelected((JComboBox)this.cboFieldType, (Object)8);
        this.cboDataProfile.setSelectedIndex(-1);
        this.cboGroup.setSelectedIndex(-1);
        this.pickerOrder.set(null);
        this.chkHidden.setSelected(false);
        this.txtLabel.setText("");
        this.txtDescription.setText("");
        this.txtMinValue.setText("");
        this.txtMaxValue.setText("");
        this.availableValuesController.clean();
        this.tagsController.clean();
        this.toOneController.clean();
        this.pickerCRS.set((Object)this.defaultProjection);
    }

    public void put(FeatureAttributeDescriptor descriptor) {
        String profile;
        Expression expression;
        if (descriptor == null) {
            this.clean();
            return;
        }
        DataType dataType = descriptor.getDataType();
        FeatureType featureType = descriptor.getFeatureType();
        DefaultComboBoxModel<String> groupModel = new DefaultComboBoxModel<String>();
        this.pickerCRS.set((Object)this.defaultProjection);
        if (featureType != null) {
            FeatureStore store = descriptor.getFeatureType().getStore();
            this.featureStoreElement.setFeatureStore(store);
            if (store != null) {
                this.sampleFeature = store.getSampleFeature();
                if (this.sampleFeature != null) {
                    FeatureSymbolTable featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
                    featureSymbolTable.setFeature(this.sampleFeature);
                    this.pickerVirtualFieldGetter.getConfig().setPreviewSymbolTable((SymbolTable)featureSymbolTable.createParent());
                    this.pickerValuesFilter.getConfig().setPreviewSymbolTable((SymbolTable)featureSymbolTable.createParent());
                    this.pickerValuesExpression.getConfig().setPreviewSymbolTable((SymbolTable)featureSymbolTable.createParent());
                }
            }
            ArrayList<String> groups = new ArrayList<String>();
            for (FeatureAttributeDescriptor otherdesc : featureType) {
                String group = otherdesc.getGroup();
                if (StringUtils.isBlank((CharSequence)group) || groups.contains(group)) continue;
                groups.add(group);
            }
            for (String group : groups) {
                groupModel.addElement(group);
            }
        }
        this.previousDefaultValue = Objects.toString(descriptor.getDefaultValue(), null);
        if (this.previousDefaultValue == null) {
            this.txtDefaultValue.setText("");
            this.chkDefaultValue.setSelected(true);
            this.txtDefaultValue.setEditable(false);
        } else {
            this.txtDefaultValue.setText(this.previousDefaultValue);
            this.chkDefaultValue.setSelected(false);
            this.txtDefaultValue.setEditable(true);
        }
        this.txtDefaultFormat.setText(Objects.toString(descriptor.getDefaultFormat(), ""));
        this.txtFieldName.setText(descriptor.getName());
        RelativeInterval interval = (RelativeInterval)descriptor.getInterval();
        if (interval == null) {
            this.pickerIntervalEnd.set(null);
            this.pickerIntervalStart.set(null);
        } else {
            this.pickerIntervalEnd.set((Object)interval.getEnd().toDate());
            this.pickerIntervalStart.set((Object)interval.getStart().toDate());
        }
        if (dataType.supportSize()) {
            this.pickerSize.set((Object)descriptor.getSize());
        } else {
            this.pickerSize.set(null);
        }
        this.pickerDisplaySize.set((Object)descriptor.getDisplaySize());
        if (dataType.supportPrecision()) {
            this.pickerPrecision.set((Object)descriptor.getPrecision());
        } else {
            this.pickerPrecision.set(null);
        }
        if (dataType.supportScale()) {
            this.pickerScale.set((Object)descriptor.getScale());
        } else {
            this.pickerScale.set(null);
        }
        this.chkAllowNulls.setSelected(descriptor.allowNull());
        this.chkIsAutomatic.setSelected(descriptor.isAutomatic());
        this.chkIsReadOnly.setSelected(descriptor.isReadOnly());
        this.chkIsIndexed.setSelected(descriptor.isIndexed());
        this.chkAllowIndexDuplicateds.setSelected(descriptor.allowIndexDuplicateds());
        this.chkIsPrimaryKey.setSelected(descriptor.isPrimaryKey());
        this.pickerVirtualFieldGetter.setEnabled(true);
        FeatureAttributeEmulator attrEmulator = descriptor.getFeatureAttributeEmulator();
        if (attrEmulator instanceof FeatureAttributeEmulatorExpression) {
            expression = ((FeatureAttributeEmulatorExpression)attrEmulator).getExpression();
            this.chkVirtualField.setEnabled(this.mode == 1);
            this.chkVirtualField.setSelected(true);
            this.pickerVirtualFieldGetter.set((Object)expression);
        } else if (descriptor.isComputed()) {
            this.chkVirtualField.setEnabled(false);
            this.chkVirtualField.setSelected(true);
            this.pickerVirtualFieldGetter.set(null);
        } else {
            this.chkVirtualField.setEnabled(this.mode == 1);
            this.chkVirtualField.setSelected(false);
            this.pickerVirtualFieldGetter.set(null);
        }
        this.pickerVirtualFieldGetter.setEnabled(true);
        expression = descriptor.getAvailableValuesFilter();
        this.pickerValuesFilter.set((Object)expression);
        Expression expression2 = descriptor.getAvailableValuesExpression();
        this.pickerValuesExpression.set((Object)expression2);
        if (descriptor.getType() == 66) {
            if (descriptor.getSRS() == null) {
                this.pickerCRS.set((Object)this.defaultProjection);
            } else {
                this.pickerCRS.set((Object)descriptor.getSRS());
            }
            if (descriptor.getGeomType() != null) {
                ListElement.setSelected((JComboBox)this.cboGeometryType, (Object)descriptor.getGeomType().getType());
                ListElement.setSelected((JComboBox)this.cboGeometrySubtype, (Object)descriptor.getGeomType().getSubType());
            }
        } else {
            this.pickerCRS.set((Object)this.defaultProjection);
            ListElement.setSelected((JComboBox)this.cboGeometryType, null);
            ListElement.setSelected((JComboBox)this.cboGeometrySubtype, null);
        }
        ListElement.setSelected((JComboBox)this.cboFieldType, (Object)dataType.getType());
        if (ListElement.getSelected((JComboBox)this.cboFieldType) == null) {
            this.cboFieldType.addItem(new ListElement(dataType.getName(), (Object)dataType.getType()));
            ListElement.setSelected((JComboBox)this.cboFieldType, (Object)dataType.getType());
        }
        if (StringUtils.isBlank((CharSequence)(profile = descriptor.getDataProfileName()))) {
            this.cboDataProfile.setSelectedIndex(-1);
        } else {
            ListElement.setSelected((JComboBox)this.cboDataProfile, (Object)profile);
        }
        this.cboGroup.setModel(groupModel);
        this.cboGroup.setSelectedItem(StringUtils.defaultIfBlank((CharSequence)descriptor.getGroup(), (CharSequence)""));
        this.pickerOrder.set((Object)descriptor.getOder());
        this.chkHidden.setSelected(descriptor.isHidden());
        if (descriptor.hasLabel()) {
            this.txtLabel.setText((String)StringUtils.defaultIfBlank((CharSequence)descriptor.getLabel(), (CharSequence)""));
        } else {
            this.txtLabel.setText("");
        }
        if (descriptor.hasDescription()) {
            this.txtDescription.setText((String)StringUtils.defaultIfBlank((CharSequence)descriptor.getDescription(), (CharSequence)""));
        } else {
            this.txtDescription.setText("");
        }
        this.txtMinValue.setText(Objects.toString(descriptor.getMinValue(), ""));
        this.txtMinValue.setText(Objects.toString(descriptor.getMaxValue(), ""));
        if (descriptor.hasConstantAvailableValues()) {
            this.availableValuesController.setModel(new AvailableValuesModel(descriptor.getAvailableValues()));
        } else {
            this.availableValuesController.setModel(new AvailableValuesModel());
        }
        this.tagsController.setModel(new TagsModel(descriptor.getTags()));
        this.pickerLocale.set((Object)descriptor.getLocale());
        this.toOneController.put(descriptor);
        this.toManyController.put(descriptor);
        switch (descriptor.getRelationType()) {
            case 0: {
                this.rdbRelationNone.setSelected(true);
                this.rdbRelationToOne.setSelected(false);
                this.rdbRelationToMany.setSelected(false);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                this.rdbRelationNone.setSelected(false);
                this.rdbRelationToOne.setSelected(true);
                this.rdbRelationToMany.setSelected(false);
                break;
            }
            case 3: 
            case 4: {
                this.rdbRelationNone.setSelected(false);
                this.rdbRelationToOne.setSelected(false);
                this.rdbRelationToMany.setSelected(true);
                this.pickerVirtualFieldGetter.setEnabled(false);
            }
        }
        if (!(descriptor instanceof EditableFeatureAttributeDescriptor)) {
            this.setMode(2);
        }
        this.updateEditableStates();
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        this.toManyController.setFeatureType(featureType);
    }

    private FeatureType getFeatureType(FeatureAttributeDescriptor descriptor) {
        if (descriptor == null || descriptor.getFeatureType() == null) {
            return this.featureType;
        }
        return descriptor.getFeatureType();
    }

    private DataType getDataType() {
        Integer fieldType = (Integer)ListElement.getSelected((JComboBox)this.cboFieldType);
        if (fieldType == null) {
            return null;
        }
        DataType dataType = ToolsLocator.getDataTypesManager().get(fieldType.intValue());
        return dataType;
    }

    private void doFieldTypeChanged() {
        try {
            DataType dataType = this.getDataType();
            if (dataType.supportSize()) {
                this.pickerSize.setEditable(this.mode == 1 || this.isVirtualField());
            } else {
                this.pickerSize.setEditable(false);
                this.pickerSize.set(null);
            }
            this.pickerDisplaySize.setEditable(this.mode == 1 || this.isVirtualField());
            if (dataType.supportPrecision()) {
                if (dataType.isPredefinedPrecision()) {
                    this.pickerPrecision.setEditable(false);
                } else {
                    this.pickerPrecision.setEditable(this.mode == 1 || this.isVirtualField());
                }
            } else {
                this.pickerPrecision.setEditable(false);
                this.pickerPrecision.set(null);
            }
            if (dataType.supportScale()) {
                this.pickerScale.setEditable(this.mode == 1 || this.isVirtualField());
            } else {
                this.pickerScale.setEditable(false);
                this.pickerScale.set(null);
            }
            switch (dataType.getType()) {
                case 66: {
                    this.cboGeometryType.setEnabled(this.mode == 1 || this.isVirtualField());
                    this.cboGeometrySubtype.setEnabled(this.mode == 1 || this.isVirtualField());
                    this.pickerCRS.setEditable(this.mode == 1 || this.isVirtualField());
                    this.cboDateFormat.setEnabled(false);
                    this.pickerIntervalStart.setEditable(false);
                    this.pickerIntervalEnd.setEditable(false);
                    this.tabAditionalFields.setEnabledAt(1, true);
                    this.tabAditionalFields.setEnabledAt(2, false);
                    this.tabAditionalFields.setSelectedIndex(1);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 68: 
                case 69: {
                    this.cboGeometryType.setEnabled(false);
                    this.cboGeometrySubtype.setEnabled(false);
                    this.pickerCRS.setEditable(false);
                    this.cboDateFormat.setEnabled(this.mode == 1 || this.mode == 0 || this.isVirtualField());
                    this.pickerIntervalStart.setEnabled(this.mode == 1 || this.mode == 0 || this.isVirtualField());
                    this.pickerIntervalEnd.setEnabled(this.mode == 1 || this.mode == 0 || this.isVirtualField());
                    this.tabAditionalFields.setEnabledAt(1, false);
                    this.tabAditionalFields.setEnabledAt(2, true);
                    this.tabAditionalFields.setSelectedIndex(0);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 16: 
                case 17: 
                case 19: {
                    this.cboGeometryType.setEnabled(false);
                    this.cboGeometrySubtype.setEnabled(false);
                    this.pickerCRS.setEditable(false);
                    this.cboDateFormat.setEnabled(false);
                    this.pickerIntervalStart.setEditable(false);
                    this.pickerIntervalEnd.setEditable(false);
                    this.tabAditionalFields.setEnabledAt(1, false);
                    this.tabAditionalFields.setEnabledAt(2, false);
                    this.tabAditionalFields.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.cboGeometryType.setEnabled(false);
                    this.cboGeometrySubtype.setEnabled(false);
                    this.pickerCRS.setEditable(false);
                    this.cboDateFormat.setEnabled(false);
                    this.pickerIntervalStart.setEditable(false);
                    this.pickerIntervalEnd.setEditable(false);
                    this.tabAditionalFields.setEnabledAt(1, false);
                    this.tabAditionalFields.setEnabledAt(2, false);
                    this.tabAditionalFields.setSelectedIndex(0);
                }
            }
            this.doChangeRelationType();
        }
        catch (Exception ex) {
            LOGGER.warn("Problems changing field type.", (Throwable)ex);
        }
    }

    boolean isVirtualField() {
        return this.chkVirtualField.isSelected();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.updateEditableStates();
    }

    private void updateEditableStates() {
        DataType dataType = this.getDataType();
        switch (this.mode) {
            case 1: {
                this.txtDefaultValue.setEditable(!this.chkIsAutomatic.isSelected());
                this.chkDefaultValue.setEnabled(this.txtDefaultValue.isEditable());
                this.txtDefaultFormat.setEditable(true);
                this.txtFieldName.setEditable(true);
                this.pickerIntervalEnd.setEditable(true);
                this.pickerIntervalStart.setEditable(true);
                this.pickerSize.setEditable(dataType.supportSize());
                this.pickerDisplaySize.setEditable(true);
                if (dataType.isPredefinedPrecision()) {
                    this.pickerPrecision.setEditable(false);
                    this.pickerPrecision.set((Object)dataType.getMaxPrecision());
                } else {
                    this.pickerPrecision.setEditable(dataType.supportPrecision());
                }
                this.pickerScale.setEditable(dataType.supportScale());
                this.cboDataProfile.setEnabled(true);
                this.chkAllowNulls.setEnabled(true);
                this.chkIsAutomatic.setEnabled(true);
                this.chkIsReadOnly.setEnabled(true);
                this.chkIsIndexed.setEnabled(true);
                this.chkAllowIndexDuplicateds.setEnabled(true);
                if (this.isVirtualField()) {
                    this.chkIsPrimaryKey.setEnabled(false);
                } else {
                    this.chkIsPrimaryKey.setEnabled(true);
                }
                this.chkVirtualField.setEnabled(true);
                this.pickerVirtualFieldGetter.setEditable(true);
                this.cboDateFormat.setEnabled(true);
                this.cboFieldType.setEnabled(!this.chkIsAutomatic.isSelected());
                this.btnFieldType.setEnabled(!this.chkIsAutomatic.isSelected());
                this.cboGeometryType.setEnabled(true);
                this.cboGeometrySubtype.setEnabled(true);
                this.pickerCRS.setEditable(true);
                this.cboGroup.setEnabled(true);
                this.pickerOrder.setEditable(true);
                this.chkHidden.setEnabled(true);
                this.txtLabel.setEditable(true);
                this.txtDescription.setEditable(true);
                this.txtMinValue.setEditable(false);
                this.txtMaxValue.setEditable(false);
                this.pickerValuesFilter.setEditable(true);
                this.pickerValuesExpression.setEditable(true);
                this.availableValuesController.setEnabled(true);
                this.tagsController.setEnabled(true);
                this.pickerLocale.setEnabled(true);
                break;
            }
            case 0: {
                if (this.chkVirtualField.isSelected()) {
                    this.txtFieldName.setEditable(true);
                    this.pickerScale.setEditable(true);
                    this.pickerSize.setEditable(true);
                    this.pickerVirtualFieldGetter.setEditable(true);
                    this.cboFieldType.setEnabled(true);
                    this.btnFieldType.setEnabled(true);
                    this.cboGeometryType.setEnabled(true);
                    this.cboGeometrySubtype.setEnabled(true);
                    this.pickerCRS.setEditable(true);
                } else {
                    this.txtFieldName.setEditable(false);
                    this.pickerPrecision.setEditable(false);
                    this.pickerScale.setEditable(false);
                    this.pickerSize.setEditable(false);
                    this.pickerVirtualFieldGetter.setEditable(false);
                    this.cboFieldType.setEnabled(false);
                    this.btnFieldType.setEnabled(false);
                    this.cboGeometryType.setEnabled(false);
                    this.cboGeometrySubtype.setEnabled(false);
                    this.pickerCRS.setEditable(false);
                }
                this.pickerLocale.setEnabled(true);
                this.txtDefaultValue.setEditable(true);
                this.chkDefaultValue.setEnabled(this.txtDefaultValue.isEditable());
                this.txtDefaultFormat.setEditable(true);
                this.pickerIntervalEnd.setEditable(true);
                this.pickerIntervalStart.setEditable(true);
                this.cboDataProfile.setEnabled(true);
                this.pickerDisplaySize.setEditable(false);
                this.chkAllowNulls.setEnabled(false);
                this.chkIsAutomatic.setEnabled(false);
                this.chkIsReadOnly.setEnabled(false);
                this.chkIsIndexed.setEnabled(false);
                this.chkAllowIndexDuplicateds.setEnabled(false);
                this.chkIsPrimaryKey.setEnabled(false);
                this.chkVirtualField.setEnabled(false);
                this.cboDateFormat.setEnabled(true);
                this.cboGroup.setEnabled(true);
                this.pickerOrder.setEditable(true);
                this.chkHidden.setEnabled(true);
                this.txtLabel.setEditable(true);
                this.txtDescription.setEditable(true);
                this.txtMinValue.setEditable(false);
                this.txtMaxValue.setEditable(false);
                this.pickerValuesFilter.setEditable(true);
                this.pickerValuesExpression.setEditable(true);
                this.availableValuesController.setEnabled(true);
                this.tagsController.setEnabled(true);
                break;
            }
            case 2: {
                this.txtDefaultValue.setEditable(false);
                this.chkDefaultValue.setEnabled(this.txtDefaultValue.isEditable());
                this.txtDefaultFormat.setEditable(false);
                this.txtFieldName.setEditable(false);
                this.pickerIntervalEnd.setEditable(false);
                this.pickerIntervalStart.setEditable(false);
                this.pickerPrecision.setEditable(false);
                this.pickerScale.setEditable(false);
                this.pickerSize.setEditable(false);
                this.pickerDisplaySize.setEditable(false);
                this.cboDataProfile.setEnabled(false);
                this.pickerLocale.setEnabled(false);
                this.chkAllowNulls.setEnabled(false);
                this.chkIsAutomatic.setEnabled(false);
                this.chkIsReadOnly.setEnabled(false);
                this.chkIsIndexed.setEnabled(false);
                this.chkAllowIndexDuplicateds.setEnabled(false);
                this.chkIsPrimaryKey.setEnabled(false);
                this.chkVirtualField.setEnabled(false);
                this.pickerVirtualFieldGetter.setEditable(false);
                this.cboDateFormat.setEnabled(false);
                this.cboFieldType.setEnabled(false);
                this.btnFieldType.setEnabled(false);
                this.cboGeometryType.setEnabled(false);
                this.cboGeometrySubtype.setEnabled(false);
                this.pickerCRS.setEditable(false);
                this.cboGroup.setEnabled(false);
                this.pickerOrder.setEditable(false);
                this.chkHidden.setEnabled(false);
                this.txtLabel.setEditable(false);
                this.txtDescription.setEditable(false);
                this.txtMinValue.setEditable(false);
                this.txtMaxValue.setEditable(false);
                this.pickerValuesFilter.setEditable(false);
                this.pickerValuesExpression.setEditable(false);
                this.availableValuesController.setEnabled(false);
                this.tagsController.setEnabled(false);
                break;
            }
            case 100: {
                this.txtDefaultValue.setEditable(!this.chkIsAutomatic.isSelected());
                this.chkDefaultValue.setEnabled(this.txtDefaultValue.isEditable());
                this.txtDefaultFormat.setEditable(true);
                this.txtFieldName.setEditable(true);
                this.pickerIntervalEnd.setEditable(true);
                this.pickerIntervalStart.setEditable(true);
                this.pickerSize.setEditable(dataType.supportSize());
                this.pickerDisplaySize.setEditable(true);
                if (dataType.isPredefinedPrecision()) {
                    this.pickerPrecision.setEditable(false);
                    this.pickerPrecision.set((Object)dataType.getMaxPrecision());
                } else {
                    this.pickerPrecision.setEditable(dataType.supportPrecision());
                }
                this.pickerScale.setEditable(dataType.supportScale());
                this.cboDataProfile.setEnabled(true);
                this.chkAllowNulls.setEnabled(true);
                this.chkIsAutomatic.setEnabled(true);
                this.chkIsReadOnly.setEnabled(true);
                this.chkIsIndexed.setEnabled(true);
                this.chkAllowIndexDuplicateds.setEnabled(true);
                if (this.isVirtualField()) {
                    this.chkIsPrimaryKey.setEnabled(false);
                } else {
                    this.chkIsPrimaryKey.setEnabled(true);
                }
                this.chkVirtualField.setEnabled(false);
                this.chkVirtualField.setSelected(true);
                this.pickerVirtualFieldGetter.setEditable(true);
                this.cboDateFormat.setEnabled(true);
                this.cboFieldType.setEnabled(!this.chkIsAutomatic.isSelected());
                this.btnFieldType.setEnabled(!this.chkIsAutomatic.isSelected());
                this.cboGeometryType.setEnabled(true);
                this.cboGeometrySubtype.setEnabled(true);
                this.pickerCRS.setEditable(true);
                this.cboGroup.setEnabled(true);
                this.pickerOrder.setEditable(true);
                this.chkHidden.setEnabled(true);
                this.txtLabel.setEditable(true);
                this.txtDescription.setEditable(true);
                this.txtMinValue.setEditable(false);
                this.txtMaxValue.setEditable(false);
                this.pickerValuesFilter.setEditable(true);
                this.pickerValuesExpression.setEditable(true);
                this.availableValuesController.setEnabled(true);
                this.tagsController.setEnabled(true);
                this.pickerLocale.setEnabled(true);
            }
        }
        this.txtDisplaySize.setBackground(UIManager.getColor("TextField.background"));
        if (this.pickerPrecision.get() != null && this.pickerDisplaySize.get() != null && (Integer)this.pickerPrecision.get() > (Integer)this.pickerDisplaySize.get()) {
            this.txtDisplaySize.setBackground(ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor());
        }
        this.doChangeRelationType();
    }

    private void doCheckPrecisionAndScale() {
        DataType.NumberPrecisionAndScale r;
        Integer scale;
        DataType dataType = this.getDataType();
        Integer precision = (Integer)this.pickerPrecision.get();
        if (precision == null) {
            precision = 0;
        }
        if ((scale = (Integer)this.pickerScale.get()) == null) {
            scale = 0;
        }
        if ((r = dataType.fixPrecisionAndScale(precision.intValue(), scale.intValue())).getPrecision() != precision.intValue() || r.getScale() != scale.intValue()) {
            this.pickerPrecision.setWarning(true, "The precision/scale are not valids");
            this.pickerScale.setWarning(true, "The precision/scale are not valids");
        } else {
            this.pickerPrecision.setWarning(false);
            this.pickerScale.setWarning(false);
        }
    }

    public void setNameAsNew(FeatureType featureType) {
        EditableFeatureType cloneFeatureType = featureType.getCopy().getEditable();
        EditableFeatureAttributeDescriptor newAttributeDescriptor = cloneFeatureType.add(cloneFeatureType.getNewFieldName(), 8, 50);
        this.put((FeatureAttributeDescriptor)newAttributeDescriptor);
    }

    @Override
    public String getName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.txtFieldName.getText(), null);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public static void selfRegister() {
        boolean n = ToolsSwingUtils.registerIcons(DefaultFeatureAttributeSelectionPanel.class, null, (String)"DataAccessSwingLibrary", (String[][])new String[][]{{"picker", "picker-datatype", "picker-datatype"}});
    }

    public void setDefaultProjection(IProjection projection) {
        this.defaultProjection = projection;
    }

    private static class ToManyController {
        private final JComboBox cboRelationType;
        private final JComboBox cboMyField;
        private final JComboBox cboTable;
        private final JComboBox cboForeignField;
        private final JTextField txtExpression;
        private final JButton btnExpression;
        private final JButton btnExpressionHistory;
        private final JButton btnExpressionBokkmarks;
        private ExpressionPickerController pickerExpression;
        private AttributeDescriptorPickerController pickerForeignField;
        private AttributeDescriptorPickerController pickerMyField;
        private boolean editable;
        private boolean disableEvents = false;
        private FeatureType featureType;

        public ToManyController(JComboBox cboRelationType, JComboBox cboMyField, JComboBox cboTable, JComboBox cboForeignField, JTextField txtExpression, JButton btnExpression, JButton btnExpressionBokkmarks, JButton btnExpressionHistory) {
            this.cboRelationType = cboRelationType;
            this.cboMyField = cboMyField;
            this.cboTable = cboTable;
            this.cboForeignField = cboForeignField;
            this.txtExpression = txtExpression;
            this.btnExpression = btnExpression;
            this.btnExpressionHistory = btnExpressionHistory;
            this.btnExpressionBokkmarks = btnExpressionBokkmarks;
            this.initComponents();
        }

        private void initComponents() {
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.editable = true;
            DefaultComboBoxModel<ListElement> relationTypeModel = new DefaultComboBoxModel<ListElement>();
            relationTypeModel.addElement(new ListElement("3 - " + i18n.getTranslation("_Aggregate_1_N_with_composition"), (Object)3));
            relationTypeModel.addElement(new ListElement("4 - " + i18n.getTranslation("_Aggregate_1_N_without_composition"), (Object)4));
            this.cboRelationType.setModel(relationTypeModel);
            this.pickerMyField = dataSwingManager.createAttributeDescriptorPickerController(this.cboMyField);
            this.pickerMyField.setAllowNull(true);
            this.pickerMyField.addChangeListener(e -> {
                if (this.disableEvents) {
                    return;
                }
                this.doUpdateExpression();
            });
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            ArrayList<String> tableNames = new ArrayList<String>();
            for (String tableName : repository.keySet()) {
                tableNames.add(tableName);
            }
            Collections.sort(tableNames);
            for (String tableName : tableNames) {
                model.addElement(tableName);
            }
            this.cboTable.setEditable(false);
            this.cboTable.setModel(model);
            this.cboTable.addItemListener(e -> {
                if (this.disableEvents) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                Thread th = new Thread(() -> this.doTableChanged(), "FeatureTypePanelToManyTableChanged");
                th.start();
            });
            this.pickerForeignField = dataSwingManager.createAttributeDescriptorPickerController(this.cboForeignField);
            this.pickerForeignField.setAllowNull(true);
            this.pickerForeignField.addChangeListener(e -> {
                if (this.disableEvents) {
                    return;
                }
                this.doUpdateExpression();
            });
            this.pickerExpression = ExpressionEvaluatorSwingLocator.getManager().createExpressionPickerController((JTextComponent)this.txtExpression, this.btnExpression, this.btnExpressionBokkmarks, this.btnExpressionHistory);
        }

        private void doTableChanged() {
            FeatureType featureType;
            String tableName = (String)this.cboTable.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)tableName)) {
                return;
            }
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            DataStore store = repository.getStore(tableName);
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            try {
                featureType = featureStore.getDefaultFeatureType();
            }
            catch (DataException ex) {
                return;
            }
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            this.pickerForeignField.setFeatureType(featureType);
            if (featureType == null) {
                return;
            }
            dataSwingManager.configureExpressionBuilder(this.pickerExpression.getConfig(), featureStore);
        }

        private void doUpdateExpression() {
            String myField = this.pickerMyField.getName();
            if (StringUtils.isBlank((CharSequence)myField)) {
                this.pickerExpression.set(null);
                return;
            }
            String foreignField = this.pickerForeignField.getName();
            if (StringUtils.isBlank((CharSequence)foreignField)) {
                this.pickerExpression.set(null);
                return;
            }
            String tableName = this.getTableName();
            if (StringUtils.isBlank((CharSequence)tableName)) {
                this.pickerExpression.set(null);
                return;
            }
            DataManager dataManager = DALLocator.getDataManager();
            DALExpressionBuilder builder = dataManager.createDALExpressionBuilder();
            SQLBuilder.SelectBuilder select = builder.select();
            select.from().table().name(tableName);
            select.column().all();
            select.where().set((ExpressionBuilder.Value)builder.expression().eq((ExpressionBuilder.Value)builder.expression().hostexpression((ExpressionBuilder.Value)builder.expression().column(myField)), (ExpressionBuilder.Value)builder.expression().getattr(tableName, foreignField)));
            this.pickerExpression.set((Object)ExpressionUtils.createExpression((String)select.toString()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String[] getFieldsAndTable(Expression expression) {
            if (ExpressionUtils.isEmpty((Expression)expression)) {
                return null;
            }
            try {
                Code foreingFieldCode;
                String tableName;
                Code code = expression.getCode();
                if (!StringUtils.equalsIgnoreCase((CharSequence)Code.Callable.name((Code)code), (CharSequence)"SELECT")) {
                    return null;
                }
                Code.Callable callable = (Code.Callable)code;
                Codes args = callable.parameters();
                Code storeName_code = (Code)args.get(1);
                if (storeName_code instanceof Code.Identifier) {
                    tableName = ((Code.Identifier)storeName_code).name();
                } else {
                    if (!(storeName_code instanceof Code.Constant)) return null;
                    Code.Constant storeName_const = (Code.Constant)storeName_code;
                    if (!(storeName_const.value() instanceof CharSequence)) return null;
                    tableName = storeName_const.value().toString();
                }
                if (StringUtils.isBlank((CharSequence)tableName)) {
                    return null;
                }
                String foreignColumnName = null;
                String myColumnName = null;
                Code where = (Code)callable.parameters().get(2);
                Code myFieldCode = this.getCode(where, new Pair[]{new ImmutablePair((Object)"=", (Object)0)});
                if (myFieldCode != null) {
                    Code params0;
                    Codes params;
                    if (StringUtils.equals((CharSequence)Code.Callable.name((Code)myFieldCode), (CharSequence)"$HOSTEXPRESSION") && (params = Code.Callable.parameters((Code)myFieldCode)) != null && (params0 = (Code)params.get(0)) != null) {
                        myFieldCode = params0;
                    }
                    myColumnName = Objects.toString(Code.Identifier.name((Code)myFieldCode), null);
                }
                if ((foreingFieldCode = this.getCode(where, new Pair[]{new ImmutablePair((Object)"=", (Object)1), new ImmutablePair((Object)"GETATTR", (Object)1)})) == null) return new String[]{myColumnName, tableName, foreignColumnName};
                foreignColumnName = Objects.toString(Code.Constant.value((Code)foreingFieldCode), null);
                return new String[]{myColumnName, tableName, foreignColumnName};
            }
            catch (Throwable t) {
                LOGGER.warn("Can't get table and code from expression '" + expression.getPhrase() + "' in toMany controller", t);
                return null;
            }
        }

        private Code getCode(Code code, Pair<String, Integer> ... args) {
            for (Pair<String, Integer> arg : args) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)Code.Callable.name((Code)code), (CharSequence)((CharSequence)arg.getLeft()))) {
                    return null;
                }
                code = (Code)Code.Callable.parameters((Code)code).get(((Integer)arg.getRight()).intValue());
            }
            return code;
        }

        private String getTableName() {
            String s = (String)this.cboTable.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return s;
        }

        public void setEditable(boolean editable) {
            this.cboRelationType.setEnabled(editable);
            this.pickerMyField.setEditable(editable);
            this.cboTable.setEnabled(editable);
            this.pickerForeignField.setEditable(editable);
            this.pickerExpression.setEditable(editable);
            this.editable = editable;
        }

        public void setEnabled(boolean enabled) {
            if (!this.editable) {
                enabled = false;
            }
            this.cboRelationType.setEnabled(enabled);
            this.pickerMyField.setEnabled(enabled);
            this.cboTable.setEnabled(enabled);
            this.pickerForeignField.setEnabled(enabled);
            this.pickerExpression.setEditable(enabled);
        }

        public void clean() {
            this.cboRelationType.setSelectedIndex(-1);
            this.pickerMyField.clean();
            this.cboTable.setSelectedIndex(-1);
            this.pickerForeignField.clean();
            this.pickerExpression.set(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(FeatureAttributeDescriptor descriptor) {
            if (descriptor == null) {
                this.clean();
                return;
            }
            boolean prevDisableEvents = this.disableEvents;
            try {
                this.disableEvents = true;
                this.pickerMyField.setFeatureType(this.getFeatureType(descriptor));
                ListElement.setSelected((JComboBox)this.cboRelationType, (Object)descriptor.getRelationType());
                FeatureAttributeEmulator attrEmulator = descriptor.getFeatureAttributeEmulator();
                if (attrEmulator instanceof FeatureAttributeEmulatorExpression) {
                    Expression expression = ((FeatureAttributeEmulatorExpression)attrEmulator).getExpression();
                    String[] fieldsAndTable = this.getFieldsAndTable(expression);
                    if (fieldsAndTable == null) {
                        this.cboTable.setSelectedIndex(-1);
                        this.pickerForeignField.clean();
                        return;
                    }
                    this.pickerMyField.set(fieldsAndTable[0]);
                    this.cboTable.setSelectedItem(fieldsAndTable[1]);
                    this.doTableChanged();
                    this.pickerForeignField.set(fieldsAndTable[2]);
                    this.pickerExpression.set((Object)expression);
                } else {
                    this.clean();
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Can't set attribute descriptor in toMany controller", t);
            }
            finally {
                this.disableEvents = prevDisableEvents;
            }
        }

        public void setFeatureType(FeatureType featureType) {
            this.featureType = featureType;
        }

        private FeatureType getFeatureType(FeatureAttributeDescriptor descriptor) {
            if (descriptor == null || descriptor.getFeatureType() == null) {
                return this.featureType;
            }
            return descriptor.getFeatureType();
        }

        public void fetch(EditableFeatureAttributeDescriptor descriptor) {
            String tableName;
            if (descriptor == null) {
                this.clean();
                return;
            }
            Tags tags = descriptor.getTags();
            if (!tags.has("DAL.RelatedFeatures.Table") && StringUtils.isNotBlank((CharSequence)(tableName = this.getTableName()))) {
                tags.set("DAL.RelatedFeatures.Table", (Object)tableName);
            }
            if (!tags.has("DAL.RelatedFeatures.Unique.Field.Name") && StringUtils.isNotBlank((CharSequence)(tableName = tags.getString("DAL.RelatedFeatures.Table", null)))) {
                try {
                    StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
                    FeatureType ft = repository.getFeatureType(tableName);
                    Object[] pk = ft.getPrimaryKey();
                    if (!ArrayUtils.isEmpty((Object[])pk) && pk.length == 1) {
                        tags.set("DAL.RelatedFeatures.Unique.Field.Name", (Object)pk[0].getName());
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't get primary key of table '" + tableName + "'.", t);
                }
            }
        }

        public Expression getExpression() {
            Expression exp = this.pickerExpression.get();
            if (ExpressionUtils.isPhraseEmpty((Expression)exp)) {
                return null;
            }
            return exp;
        }

        public int getRelationType() {
            Object n = this.cboRelationType.getSelectedItem();
            if (n == null) {
                return 0;
            }
            return (Integer)((LabeledValue)n).getValue();
        }
    }

    private static class ToOneController {
        private final JTextComponent txtMyFieldName;
        private final JComboBox cboRelationType;
        private final JCheckBox chkIsClosedList;
        private final JCheckBox chkCanBeOptimizedByProvider;
        private final JComboBox cboTable;
        private final JComboBox cboForeignField;
        private final JComboBox cboFormula;
        private final JButton btnFormula;
        private final JButton btnFormulaHistory;
        private final JButton btnFormulaBokkmarks;
        private AttributeDescriptorAndExpressionPickerController pickerFormula;
        private AttributeDescriptorPickerController pickerCode;
        private boolean editable;
        private ForeingKey foreingKey;

        public ToOneController(JTextComponent txtMyFieldName, JComboBox cboRelationType, JCheckBox chkIsClosedList, JCheckBox chkCanBeOptimizedByProvider, JComboBox cboTable, JComboBox cboCode, JComboBox cboFormula, JButton btnFormula, JButton btnFormulaBokkmarks, JButton btnFormulaHistory) {
            this.txtMyFieldName = txtMyFieldName;
            this.cboRelationType = cboRelationType;
            this.chkIsClosedList = chkIsClosedList;
            this.chkCanBeOptimizedByProvider = chkCanBeOptimizedByProvider;
            this.cboTable = cboTable;
            this.cboForeignField = cboCode;
            this.cboFormula = cboFormula;
            this.btnFormula = btnFormula;
            this.btnFormulaHistory = btnFormulaHistory;
            this.btnFormulaBokkmarks = btnFormulaBokkmarks;
            this.initComponents();
        }

        private void initComponents() {
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.editable = true;
            DefaultComboBoxModel<ListElement> relationTypeModel = new DefaultComboBoxModel<ListElement>();
            relationTypeModel.addElement(new ListElement("2 - " + i18n.getTranslation("_Identity_1_1"), (Object)2));
            relationTypeModel.addElement(new ListElement("1 - " + i18n.getTranslation("_Collaboration_1_1_without_composition"), (Object)1));
            relationTypeModel.addElement(new ListElement("5 - " + i18n.getTranslation("_Collaboration_1_1_with_composition"), (Object)5));
            this.cboRelationType.setModel(relationTypeModel);
            this.cboRelationType.addActionListener(e -> this.updateEnabledState());
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            ArrayList<String> tableNames = new ArrayList<String>();
            for (String tableName : repository.keySet()) {
                tableNames.add(tableName);
            }
            Collections.sort(tableNames);
            for (String tableName : tableNames) {
                model.addElement(tableName);
            }
            this.cboTable.setEditable(false);
            this.cboTable.setModel(model);
            this.cboTable.addItemListener(e -> {
                this.updateEnabledState();
                if (e.getStateChange() != 1) {
                    return;
                }
                Thread th = new Thread(() -> this.doTableChanged(), "FeatureTypePanelToOneChangeTable");
                th.start();
            });
            this.pickerCode = dataSwingManager.createAttributeDescriptorPickerController(this.cboForeignField);
            this.pickerCode.addChangeListener(e -> this.updateEnabledState());
            this.btnFormula.setText("");
            this.btnFormulaBokkmarks.setText("");
            this.btnFormulaHistory.setText("");
            this.pickerFormula = dataSwingManager.createExpressionPickerController(null, this.cboFormula, this.btnFormula, this.btnFormulaBokkmarks, this.btnFormulaHistory);
            this.pickerFormula.setAllowNull(true);
        }

        private void doTableChanged() {
            FeatureType featureType;
            String tableName = (String)this.cboTable.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)tableName)) {
                return;
            }
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            DataStore store = repository.getStore(tableName);
            if (!(store instanceof FeatureStore)) {
                return;
            }
            try {
                featureType = ((FeatureStore)store).getDefaultFeatureType();
            }
            catch (DataException ex) {
                return;
            }
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            this.pickerCode.setAllowNull(true);
            this.pickerCode.setFeatureType(featureType);
            if (featureType == null) {
                return;
            }
            dataSwingManager.configureExpressionBuilder(this.pickerFormula.getConfig(), (FeatureStore)store);
            SwingUtilities.invokeLater(() -> this.cboForeignField.setSelectedItem(this.foreingKey.getCodeName()));
        }

        public void updateEnabledState() {
            if (this.editable) {
                if (this.cboRelationType.getSelectedItem() == null) {
                    this.cboRelationType.setBackground(ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor());
                } else {
                    this.cboRelationType.setBackground(UIManager.getColor("ComboBox.background"));
                }
                if (this.cboTable.getSelectedItem() == null) {
                    this.cboTable.setBackground(ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor());
                } else {
                    this.cboTable.setBackground(UIManager.getColor("ComboBox.background"));
                }
                if (this.cboForeignField.getSelectedItem() == null) {
                    this.cboForeignField.setBackground(ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor());
                } else {
                    this.cboForeignField.setBackground(UIManager.getColor("ComboBox.background"));
                }
            } else {
                this.cboRelationType.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                this.cboTable.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                this.cboForeignField.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
        }

        public void setEditable(boolean editable) {
            this.cboRelationType.setEnabled(editable);
            this.chkIsClosedList.setEnabled(editable);
            this.chkCanBeOptimizedByProvider.setEnabled(editable);
            this.cboTable.setEnabled(editable);
            this.cboForeignField.setEnabled(editable);
            this.pickerFormula.setEditable(editable);
            this.editable = editable;
        }

        public void setEnabled(boolean enabled) {
            if (!this.editable) {
                enabled = false;
            }
            this.cboRelationType.setEnabled(enabled);
            this.chkIsClosedList.setEnabled(enabled);
            this.chkCanBeOptimizedByProvider.setEnabled(enabled);
            this.cboTable.setEnabled(enabled);
            this.cboForeignField.setEnabled(enabled);
            this.pickerFormula.setEditable(enabled);
        }

        public void clean() {
            this.txtMyFieldName.setText("");
            this.cboRelationType.setSelectedIndex(-1);
            this.chkIsClosedList.setSelected(false);
            this.chkCanBeOptimizedByProvider.setSelected(true);
            this.cboTable.setSelectedItem("");
            this.cboForeignField.setSelectedItem("");
            this.pickerFormula.set(null);
        }

        public void put(FeatureAttributeDescriptor descriptor) {
            if (descriptor == null) {
                this.clean();
                return;
            }
            ForeingKey theForeingKey = descriptor.getForeingKey();
            if (theForeingKey == null) {
                this.clean();
                return;
            }
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            this.pickerFormula.setFeatureType(repository.getFeatureType(theForeingKey.getTableName()));
            this.foreingKey = theForeingKey;
            ListElement.setSelected((JComboBox)this.cboRelationType, (Object)descriptor.getRelationType());
            this.chkIsClosedList.setSelected(theForeingKey.isClosedList());
            this.chkCanBeOptimizedByProvider.setSelected(theForeingKey.canBeOptimizedByProvider());
            this.cboTable.setSelectedItem(theForeingKey.getTableName());
            this.doTableChanged();
            this.pickerCode.set(theForeingKey.getCodeName());
            this.pickerFormula.set((Object)theForeingKey.getLabelExpression(null));
            this.txtMyFieldName.setText(descriptor.getName());
        }

        public void fetch(EditableFeatureAttributeDescriptor descriptor) {
            if (descriptor == null) {
                this.clean();
                return;
            }
            EditableForeingKey theForeingKey = descriptor.getForeingKey();
            if (theForeingKey == null) {
                return;
            }
            theForeingKey.setClosedList(this.chkIsClosedList.isSelected());
            theForeingKey.setCanBeOptimizedByProvider(this.chkCanBeOptimizedByProvider.isSelected());
            theForeingKey.setTableName((String)this.cboTable.getSelectedItem());
            theForeingKey.setCodeName(this.pickerCode.getName());
            Expression exp = this.pickerFormula.get();
            if (ExpressionUtils.isPhraseEmpty((Expression)exp)) {
                theForeingKey.setLabelFormula("");
            } else {
                theForeingKey.setLabelFormula(exp.getPhrase());
            }
        }

        public int getRelationType() {
            Object n = this.cboRelationType.getSelectedItem();
            if (n == null) {
                return 0;
            }
            return (Integer)((LabeledValue)n).getValue();
        }
    }
}

