/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype.availablevalues;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableValuesModel
extends AbstractTableModel
implements AggregateController.AggregateModel<DynObjectValueItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailableValuesModel.class);
    private static final int COLUMN_LABEL = 0;
    private static final int COLUMN_VALUE = 1;
    private List<DynObjectValueItem> items;
    private String[] columnNames;
    private Class[] columnClases;

    public AvailableValuesModel(List<DynObjectValueItem> items) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.items = this.cloneItems(items);
        this.columnNames = new String[2];
        this.columnNames[0] = i18n.getTranslation("_Label");
        this.columnNames[1] = i18n.getTranslation("_Value");
        this.columnClases = new Class[2];
        this.columnClases[0] = String.class;
        this.columnClases[1] = String.class;
    }

    public AvailableValuesModel() {
        this((List<DynObjectValueItem>)null);
    }

    public AvailableValuesModel(DynObjectValueItem[] items) {
        this(Arrays.asList(items));
    }

    @Override
    public DynObjectValueItem createItem() {
        DynObjectValueItem item = new DynObjectValueItem((Object)"value", "label");
        return item;
    }

    @Override
    public int addItem(DynObjectValueItem item) {
        if (this.items == null) {
            return -1;
        }
        this.items.add(item);
        this.fireTableDataChanged();
        return this.items.size() - 1;
    }

    @Override
    public void itemUpdated(int position) {
        this.fireTableDataChanged();
    }

    public DynObjectValueItem get(int position) {
        if (this.items == null) {
            return null;
        }
        return this.items.get(position);
    }

    @Override
    public Iterator<DynObjectValueItem> iterator() {
        if (this.items == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.items.iterator();
    }

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClases[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.items == null) {
            return null;
        }
        DynObjectValueItem item = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getLabel();
            }
            case 1: {
                return item.getValue();
            }
        }
        return null;
    }

    @Override
    public void fetch(Object container) {
        if (container instanceof Collection) {
            this.fetch((List)container, null, null);
            return;
        }
        if (container instanceof FeatureAttributeDescriptor) {
            this.fetch((FeatureAttributeDescriptor)container);
            return;
        }
        throw new IllegalArgumentException("fetch require List or FeatureAttributeDescriptor as argument");
    }

    public void fetch(FeatureAttributeDescriptor descriptor) {
        Coercion coercion = descriptor.getCoercion();
        CoercionContext coercionContext = descriptor.getCoercionContext();
        List<DynObjectValueItem> values = this.cloneItems(this.items, coercion, coercionContext);
        descriptor.setAvailableValues(values);
    }

    public void fetch(List<DynObjectValueItem> items, Coercion coercion, CoercionContext coercionContext) {
        items.clear();
        items.addAll(this.cloneItems(this.items, coercion, coercionContext));
    }

    private List<DynObjectValueItem> cloneItems(List<DynObjectValueItem> items) {
        return this.cloneItems(items, null, null);
    }

    private List<DynObjectValueItem> cloneItems(List<DynObjectValueItem> items, Coercion coercion, CoercionContext coercionContext) {
        ArrayList<DynObjectValueItem> x = new ArrayList<DynObjectValueItem>();
        if (items != null) {
            for (DynObjectValueItem item : items) {
                Object value = item.getValue();
                if (coercion != null) {
                    try {
                        value = coercion.coerce(value, coercionContext);
                    }
                    catch (CoercionException ex) {
                        LOGGER.warn("Can't coerce value " + Objects.toString(value), (Throwable)ex);
                    }
                }
                x.add(new DynObjectValueItem(value, item.getLabel()));
            }
        }
        return x;
    }
}

