/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.jdbc;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionDialog;
import org.gvsig.fmap.dal.swing.jdbc.JDBCServerExplorerParametersController;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class JDBCConnectionPickerControllerImpl
extends AbstractPickerController<JDBCServerExplorerParameters>
implements JDBCServerExplorerParametersController {
    private final JComboBox cboConnection;
    private final JButton btnConnection;

    public JDBCConnectionPickerControllerImpl(JComboBox cboConnection, JButton btnConnection) {
        this.btnConnection = btnConnection;
        this.cboConnection = cboConnection;
        this.fillConnections(this.cboConnection);
        this.btnConnection.addActionListener(e -> this.doAddConnection());
        if ("...".equals(this.btnConnection.getText())) {
            this.btnConnection.setText("");
        }
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        this.btnConnection.setIcon(theme.get("picker-dbconnection"));
        this.cboConnection.addItemListener(e -> {
            if (!this.isEnabled()) {
                return;
            }
            if (e.getStateChange() == 1) {
                SwingUtilities.invokeLater(() -> this.fireChangeEvent());
            }
        });
    }

    private void fillConnections(JComboBox combo) {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
        combo.removeAllItems();
        ArrayList entries = new ArrayList();
        pool.iterator().forEachRemaining(e -> entries.add(e));
        entries.sort((o1, o2) -> StringUtils.compare((String)o1.getName(), (String)o2.getName()));
        for (DataServerExplorerPoolEntry entry : entries) {
            if (!(entry.getExplorerParameters() instanceof JDBCServerExplorerParameters)) continue;
            JDBCServerExplorerParameters dbParams = (JDBCServerExplorerParameters)entry.getExplorerParameters();
            combo.addItem(new ListElement(entry.getName(), (Object)dbParams));
        }
        combo.setSelectedIndex(-1);
    }

    private void doAddConnection() {
        JDBCConnectionDialog dialog = DALSwingLocator.getSwingManager().createJDBCConectionDialog();
        dialog.showDialog();
        if (dialog.isCanceled()) {
            return;
        }
        JDBCServerExplorerParameters connectionParameters = dialog.getServerExplorerParameters();
        this.fillConnections(this.cboConnection);
        ListElement.setSelected((JComboBox)this.cboConnection, (Object)connectionParameters);
    }

    public JDBCServerExplorerParameters get() {
        ListElement item = (ListElement)this.cboConnection.getSelectedItem();
        if (item == null) {
            return null;
        }
        JDBCServerExplorerParameters conn = (JDBCServerExplorerParameters)item.getValue();
        return conn;
    }

    public String getName() {
        ListElement item = (ListElement)this.cboConnection.getSelectedItem();
        if (item == null) {
            return null;
        }
        String name = item.getLabel();
        return name;
    }

    public void set(JDBCServerExplorerParameters value) {
        JDBCServerExplorerParameters params;
        int i;
        if (value == null) {
            this.cboConnection.setSelectedIndex(-1);
            this.cboConnection.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = this.cboConnection.getModel();
        for (i = 0; i < model.getSize(); ++i) {
            params = (JDBCServerExplorerParameters)((ListElement)model.getElementAt(i)).getValue();
            if (params != value) continue;
            this.cboConnection.setSelectedIndex(i);
            return;
        }
        for (i = 0; i < model.getSize(); ++i) {
            params = (JDBCServerExplorerParameters)((ListElement)model.getElementAt(i)).getValue();
            if (!StringUtils.equals((CharSequence)params.getUrl(), (CharSequence)value.getUrl())) continue;
            this.cboConnection.setSelectedIndex(i);
            return;
        }
        this.cboConnection.addItem(new ListElement(value.getHost() + ":" + value.getDBName(), (Object)value));
        this.cboConnection.setSelectedIndex(this.cboConnection.getModel().getSize() - 1);
    }

    public void coerceAndSet(Object value) {
        JDBCServerExplorerParameters params;
        try {
            params = (JDBCServerExplorerParameters)value;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't coerce value to JDBCServerExplorerParameters", ex);
        }
        this.set(params);
    }

    public void setEnabled(boolean enabled) {
        this.cboConnection.setEnabled(enabled);
        this.btnConnection.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.cboConnection.isEnabled();
    }

    public static void selfRegister() {
        boolean n = ToolsSwingUtils.registerIcons(JDBCConnectionPickerControllerImpl.class, null, (String)"DataAccessSwingLibrary", (String[][])new String[][]{{"picker", "picker-dbconnection", "picker-dbconnection"}});
    }
}

