/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.searchpanel.AbstractSearchConditionPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchConditionPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class SearchConditionPanelAdvanced
extends AbstractSearchConditionPanel
implements SearchConditionPanel {
    private static final SearchConditionPanel.SearchConditionPanelFactory FACTORY = new SearchConditionPanelAdvancedFactory();
    private final ExpressionPickerController advancedExpression;
    private final FeatureStore store;
    private final ChangeListenerHelper changeListenerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();

    public JComponent asJComponent() {
        return null;
    }

    public void put(SearchParameters params) {
        Expression filter = null;
        if (params.getQuery().getExpressionFilter() != null) {
            try {
                filter = params.getQuery().getExpressionFilter().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Not able to clone advanced parameters", ex);
            }
        }
        this.set(filter);
    }

    public SearchParameters fetch(SearchParameters params) {
        if (params == null) {
            return params;
        }
        Expression exp = this.get();
        if (exp == null) {
            params.getQuery().setFilter((Expression)null);
        } else if (exp.isEmpty()) {
            params.getQuery().clearFilter();
        } else {
            try {
                exp = this.get().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Not able to clone advanced parameters", ex);
            }
            params.getQuery().setFilter(exp);
        }
        return params;
    }

    public SearchConditionPanelAdvanced(FeatureStore store, JTextComponent text, JButton button, JButton bookmarks, JButton history) {
        this.store = store;
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getManager();
        this.advancedExpression = dataSwingManager.createExpressionPickerController(this.store, text, button, bookmarks, history);
        this.initComponents();
    }

    public SearchConditionPanel.SearchConditionPanelFactory getFactory() {
        return FACTORY;
    }

    private void initComponents() {
    }

    public void clear() {
        this.advancedExpression.set(null);
        this.changeListenerHelper.fireEvent();
    }

    public Expression get() {
        return this.advancedExpression.get();
    }

    public boolean isValid(StringBuilder message) {
        if (this.advancedExpression.isValid()) {
            return true;
        }
        message.append("The expression entered is not valid.");
        return false;
    }

    public String getWarnings() {
        return null;
    }

    public boolean set(Expression filter) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.set(filter));
            return true;
        }
        this.advancedExpression.set((Object)filter);
        this.changeListenerHelper.fireEvent();
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.advancedExpression.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    private static class SearchConditionPanelAdvancedFactory
    implements SearchConditionPanel.SearchConditionPanelFactory {
        private SearchConditionPanelAdvancedFactory() {
        }

        public boolean isApplicable(FeatureStore store) {
            return true;
        }

        public SearchConditionPanel create(Object ... os) {
            return null;
        }

        public String getName() {
            return "Advanced";
        }
    }
}

