/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SearchConditionFieldController;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SearchConditionFieldView;
import org.gvsig.fmap.dal.swing.searchpanel.AbstractSearchConditionPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchConditionPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchConditionPanelSimplified
extends AbstractSearchConditionPanel
implements SearchConditionPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchConditionPanelSimplified.class);
    public static final String PANEL_NAME = "SearchConditionPanelSimplified";
    private static final SearchConditionPanel.SearchConditionPanelFactory FACTORY = new SearchConditionPanelAdvancedFactory();
    private final FeatureStore store;
    private final List<SearchConditionFieldController> searchFieldsControllers;
    private int maxSearhFields = 4;
    private String accumulatedFilter;
    private final JButton btnAddAccumulatedFilter;
    private final JButton btnRemoveAccumulatedFilter;
    private final JButton btnViewAccumulatedFilter;
    private final String baseToolTip;
    private SearchConditionPanel.SearchConditionPanelFactory factory;
    private final ChangeListenerHelper changeListenerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();

    public JComponent asJComponent() {
        return null;
    }

    public void put(SearchParameters params) {
        Map allPersistenceJson = params.getValues();
        JsonObject jsonState = (JsonObject)allPersistenceJson.get(PANEL_NAME);
        int i = 0;
        for (SearchConditionFieldController searchFieldController : this.searchFieldsControllers) {
            searchFieldController.put(params, i++);
        }
    }

    public SearchParameters fetch(SearchParameters params) {
        if (params == null) {
            return null;
        }
        Map persistenceJson = params.getValues();
        JsonObject jsonState = this.toJson();
        persistenceJson.put(PANEL_NAME, jsonState);
        return params;
    }

    public SearchConditionPanelSimplified(SearchParameters parameters, FeatureStore store, JPanel panel, JButton btnAddToAccumulatedFilter, JButton btnRemoveAccumulatedFilter, JButton btnViewAccumulatedFilter) {
        this.store = store;
        this.searchFieldsControllers = new ArrayList<SearchConditionFieldController>();
        int numfields = 4;
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0);
        c.weightx = 1.0 / (double)numfields;
        panel.setLayout(new GridBagLayout());
        for (int i = 0; i < numfields; ++i) {
            c.gridx = i;
            c.weightx = 1.0;
            SearchConditionFieldView view = new SearchConditionFieldView();
            panel.add((Component)view, c);
            SearchConditionFieldController controller = new SearchConditionFieldController(parameters, store, view);
            this.searchFieldsControllers.add(controller);
            if (i != numfields - 1) continue;
            view.lblLogicalOperators.setVisible(false);
        }
        this.accumulatedFilter = null;
        this.btnAddAccumulatedFilter = btnAddToAccumulatedFilter;
        this.btnRemoveAccumulatedFilter = btnRemoveAccumulatedFilter;
        this.btnViewAccumulatedFilter = btnViewAccumulatedFilter;
        this.baseToolTip = this.btnAddAccumulatedFilter.getToolTipText();
        this.initComponents();
    }

    public SearchConditionPanel.SearchConditionPanelFactory getFactory() {
        return FACTORY;
    }

    public boolean isValid(StringBuilder message) {
        boolean valid = true;
        for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
            if (searchField.isValid(message)) continue;
            valid = false;
        }
        return valid;
    }

    public String getWarnings() {
        StringBuilder warns = new StringBuilder();
        for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
            String s = searchField.getWarnings();
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            warns.append(s);
        }
        String s = warns.toString();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s;
    }

    private void initComponents() {
        try {
            Search search = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)this.store.getDefaultFeatureType());
            List orderedAttributes = search.getOrderedAttributes(Search.BASIC_TYPES_FILTER, Search.STR_INT_LONG_LABEL_ORDER, 5);
            this.maxSearhFields = Integer.min(orderedAttributes.size(), 4);
            int n = 0;
            for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
                if (n < this.maxSearhFields) {
                    searchField.setAttribute(((Search.OrderedAttribute)orderedAttributes.get(n++)).getDescriptor().getName());
                    continue;
                }
                searchField.setEnabled(false);
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Can't determine order of attributes", (Throwable)ex);
        }
        this.btnAddAccumulatedFilter.addActionListener(e -> this.addToAccumulatedFilter(this.getCurrentFilter()));
        this.btnRemoveAccumulatedFilter.addActionListener(e -> this.clearAccumulatedFilter());
        this.btnViewAccumulatedFilter.addActionListener(e -> this.showAccumulatedFilter());
        this.btnRemoveAccumulatedFilter.setEnabled(false);
        this.btnViewAccumulatedFilter.setEnabled(false);
        this.btnAddAccumulatedFilter.setEnabled(true);
    }

    public void addToAccumulatedFilter(String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return;
        }
        String theAccumulatedFilter = this.accumulatedFilter;
        this.clear();
        if (!StringUtils.isBlank((CharSequence)theAccumulatedFilter)) {
            filter = "( " + theAccumulatedFilter + ") AND \n( " + filter + ")";
        }
        this.btnAddAccumulatedFilter.setToolTipText("<html><b>" + this.baseToolTip + "</b><br><br>" + filter.replaceAll("\\n", "<br>") + "</html>");
        this.accumulatedFilter = filter;
        this.btnRemoveAccumulatedFilter.setEnabled(true);
        this.btnViewAccumulatedFilter.setEnabled(true);
        this.changeListenerHelper.fireEvent();
    }

    public void clearAccumulatedFilter() {
        this.accumulatedFilter = null;
        this.btnRemoveAccumulatedFilter.setEnabled(false);
        this.btnViewAccumulatedFilter.setEnabled(false);
        this.btnAddAccumulatedFilter.setToolTipText(this.baseToolTip);
        this.changeListenerHelper.fireEvent();
    }

    public void showAccumulatedFilter() {
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DataSwingManager manager = DALSwingLocator.getDataSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        JExpressionBuilder panel = manager.createQueryFilterExpresion(this.store);
        panel.setExpression(ExpressionUtils.createExpression((String)this.getAccumulatedFilter()));
        Dialog dialog = winmanager.createDialog(panel.asJComponent(), i18n.getTranslation("_Expression_builder"), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                this.clearAccumulatedFilter();
                this.addToAccumulatedFilter(panel.getExpression().getPhrase());
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public void setEnabled(boolean enabled) {
        if (this.searchFieldsControllers == null) {
            this.initComponents();
        }
        int n = 0;
        for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
            if (n < this.maxSearhFields) {
                searchField.setEnabled(enabled);
            } else {
                searchField.setEnabled(false);
            }
            ++n;
        }
    }

    public void clear() {
        if (this.searchFieldsControllers == null) {
            return;
        }
        for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
            searchField.clear();
        }
        this.clearAccumulatedFilter();
    }

    public Expression get() {
        String currentFilter = this.getCurrentFilter();
        if (StringUtils.isBlank((CharSequence)this.accumulatedFilter)) {
            if (StringUtils.isBlank((CharSequence)currentFilter)) {
                return null;
            }
            return ExpressionUtils.createExpression((String)currentFilter);
        }
        if (StringUtils.isBlank((CharSequence)currentFilter)) {
            return ExpressionUtils.createExpression((String)this.accumulatedFilter);
        }
        return ExpressionUtils.createExpression((String)("( " + this.accumulatedFilter + " ) AND ( " + currentFilter + " )"));
    }

    public String getAccumulatedFilter() {
        return this.accumulatedFilter;
    }

    public String getCurrentFilter() {
        ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
        String relational = "OR";
        for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
            ExpressionBuilder.Value cond = searchField.getFilter();
            if (cond == null) continue;
            if (relational.equals("AND")) {
                builder.and(cond);
            } else {
                builder.or(cond);
            }
            relational = searchField.getLogicalOperator();
        }
        if (builder.isEmpty()) {
            return null;
        }
        return builder.toString();
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        int i = 0;
        for (SearchConditionFieldController searchField : this.searchFieldsControllers) {
            JsonObject jsonState = searchField.toJson();
            String name = DataTypeUtils.toString((Object)i);
            builder.add(name, (JsonValue)jsonState);
            ++i;
        }
        JsonObject jsonBuild = builder.build();
        return jsonBuild;
    }

    public void fromJson(JsonObject json) {
        if (json == null) {
            return;
        }
        int i = 0;
        for (SearchConditionFieldController searchFieldController : this.searchFieldsControllers) {
            String index = DataTypeUtils.toString((Object)i);
            JsonObject jsonField = json.getJsonObject(index);
            searchFieldController.fromJson(jsonField);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(Expression filter) {
        try {
            Code.Callable caller;
            SearchConditionFieldController searchField;
            Code code = filter.getCode();
            if (code.code() == 2 && (searchField = this.searchFieldsControllers.get(0)).isAValidRelationOperator((caller = (Code.Callable)code).name())) {
                Code op1 = (Code)caller.parameters().get(0);
                Code op2 = (Code)caller.parameters().get(1);
                if (op1.code() == 1 && op2.code() == 0 && searchField.setAttribute(((Code.Identifier)op1).name()) >= 0) {
                    searchField.setRelationalOperator(caller.name());
                    searchField.setValue(((Code.Constant)op2).value());
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeListenerHelper.fireEvent();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    private static class SearchConditionPanelAdvancedFactory
    implements SearchConditionPanel.SearchConditionPanelFactory {
        private SearchConditionPanelAdvancedFactory() {
        }

        public boolean isApplicable(FeatureStore store) {
            return true;
        }

        public SearchConditionPanel create(Object ... os) {
            return null;
        }

        public String getName() {
            return "Simplified";
        }
    }
}

