/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.registration;

import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.AbstractEntityRegistrationManager;
import ar.com.fdvs.dj.core.registration.ConditionalStylesRegistrationManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.Entity;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnRegistrationManager
extends AbstractEntityRegistrationManager {
    private static final String FIELD_ALREADY_REGISTERED = "The field has already been registered";
    private static final Log log = LogFactory.getLog(ColumnRegistrationManager.class);
    private int colCounter = 0;
    private static final String COLUMN_NAME_PREFIX = "COLUMN_";

    public ColumnRegistrationManager(DynamicJasperDesign jd, DynamicReport dr, LayoutManager layoutManager) {
        super(jd, dr, layoutManager);
    }

    @Override
    protected void registerEntity(Entity entity) {
        AbstractColumn column = (AbstractColumn)entity;
        if (column.getName() == null) {
            column.setName(this.getDjd().getName() + "_" + COLUMN_NAME_PREFIX + this.colCounter++);
        }
        column.setReportName(this.getDjd().getName());
        log.debug((Object)("Registering column " + column.getName() + " (" + column.getClass().getSimpleName() + ")"));
        if (column.getConditionalStyles() != null && !column.getConditionalStyles().isEmpty()) {
            ConditionalStylesRegistrationManager conditionalStylesRm = new ConditionalStylesRegistrationManager(this.getDjd(), this.getDynamicReport(), column.getName(), this.getLayoutManager());
            conditionalStylesRm.registerEntities(column.getConditionalStyles());
        }
        if (column.getTextFormatter() != null) {
            JRDesignParameter parameter = new JRDesignParameter();
            parameter.setName(ExpressionUtils.createParameterName("formatter_for_" + column.getName(), column.getTextFormatter()));
            parameter.setValueClassName(Object.class.getName());
            log.debug((Object)("Registering text formatter: " + parameter.getName()));
            this.getDjd().getParametersWithValues().put(parameter.getName(), column.getTextFormatter());
            try {
                this.getDjd().addParameter((JRParameter)parameter);
            }
            catch (JRException e) {
                log.debug((Object)("Repeated parameter: " + parameter.getName()));
            }
        }
        if (entity instanceof PropertyColumn) {
            try {
                PropertyColumn propertyColumn = (PropertyColumn)entity;
                ColumnProperty columnProperty = propertyColumn.getColumnProperty();
                if (columnProperty != null && !columnProperty.getProperty().startsWith("__name_to_be_replaced_in_registration_manager_")) {
                    JRField jrfield = (JRField)this.transformEntity(entity);
                    if (this.getDjd().getFieldsMap().get(jrfield.getName()) == null) {
                        this.getDjd().addField(jrfield);
                    }
                }
                if (entity instanceof ExpressionColumn && ((ExpressionColumn)entity).getExpression() != null) {
                    ExpressionColumn expressionColumn = (ExpressionColumn)entity;
                    expressionColumn.setColumns(this.getDynamicReport().getAllFields());
                    expressionColumn.setVariables(new ArrayList<JRVariable>(this.getDjd().getVariablesList()));
                    String property_name = "customExpression_for_" + expressionColumn.getName();
                    expressionColumn.getColumnProperty().setProperty(property_name);
                    this.registerCustomExpressionParameter(property_name, expressionColumn.getExpression());
                    this.registerCustomExpressionParameter(property_name + "_calc", expressionColumn.getExpressionForCalculation());
                }
            }
            catch (JRException e) {
                log.info((Object)("The field has already been registered: " + e.getMessage() + ", (skipping)"));
            }
        }
    }

    @Override
    protected Object transformEntity(Entity entity) {
        PropertyColumn propertyColumn = (PropertyColumn)entity;
        JRDesignField field = new JRDesignField();
        ColumnProperty columnProperty = propertyColumn.getColumnProperty();
        field.setName(columnProperty.getProperty());
        field.setValueClassName(columnProperty.getValueClassName());
        log.debug((Object)("Transforming column: " + propertyColumn.getName() + ", property: " + columnProperty.getProperty() + " (" + columnProperty.getValueClassName() + ") "));
        field.setDescription(propertyColumn.getFieldDescription());
        for (String key : columnProperty.getFieldProperties().keySet()) {
            field.getPropertiesMap().setProperty(key, (String)columnProperty.getFieldProperties().get(key));
        }
        return field;
    }
}

