/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.netcdf.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.raster.netcdf.io.NetCDFDataParameters;
import org.gvsig.raster.netcdf.io.NetCDFProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;

public class NetCDFDataParametersImpl
extends AbstractRasterFileDataParameters
implements NetCDFDataParameters {
    private ArrayList<String[]> gridVarList = null;
    private ArrayList<Variable> varList = null;
    private HashMap<String, double[]> rankByVar = new HashMap();
    private HashMap<String, Date[]> dateByVar = new HashMap();
    private String xDimVariable = null;
    private String yDimVariable = null;

    public NetCDFDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(NetCDFDataParametersImpl.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("NetCDFDataParametersImpl_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(NetCDFDataParametersImpl.class, "NetCDFDataParametersImpl_Persistent", "NetCDFDataParametersImpl Persistent", null, null);
            AbstractRasterFileDataParameters.registerDynClass((DynStruct)definition);
        }
        definition.addDynFieldString("GridVariable").setDescription("Grid variable").setMandatory(false);
        definition.addDynFieldInt("Level").setDescription("Level selected").setMandatory(false);
        definition.addDynFieldInt("Time").setDescription("Time selected").setMandatory(false);
        definition.addDynFieldString("XDim").setMandatory(false);
        definition.addDynFieldString("YDim").setMandatory(false);
        return definition;
    }

    @Override
    public ArrayList<Variable> getVariables() throws IOException {
        if (this.varList == null) {
            NetcdfFile netCDFFile = NetcdfFile.open((String)this.getFile().getAbsolutePath());
            this.varList = new ArrayList();
            List variableList = netCDFFile.getVariables();
            for (Variable var : variableList) {
                this.varList.add(var);
            }
            netCDFFile.close();
        }
        return this.varList;
    }

    @Override
    public ArrayList<String[]> getGridVariables() throws IOException {
        if (this.gridVarList == null) {
            GridDataset connector = GridDataset.open((String)this.getFile().getAbsolutePath());
            List gridList = connector.getGrids();
            this.gridVarList = new ArrayList();
            for (GridDatatype dt : gridList) {
                String[] pair = new String[]{dt.getName(), dt.getDescription()};
                this.gridVarList.add(pair);
                Dimension dim = (Dimension)dt.getDimensions().get(dt.getXDimensionIndex());
                this.xDimVariable = dim.getName();
                dim = (Dimension)dt.getDimensions().get(dt.getYDimensionIndex());
                this.yDimVariable = dim.getName();
                if (dt.getShape() == null) continue;
                GridCoordSystem gcs = dt.getCoordinateSystem();
                CoordinateAxis1D zAxis = gcs.getVerticalAxis();
                if (zAxis != null) {
                    double[] d = this.calcSliceValue(zAxis.getCoordEdges());
                    this.rankByVar.put(pair[0], d);
                }
                if (!gcs.hasTimeAxis1D()) continue;
                CoordinateAxis1DTime tAxis1D = gcs.getTimeAxis1D();
                Date[] dates = tAxis1D.getTimeDates();
                this.dateByVar.put(pair[0], dates);
            }
            connector.close();
        }
        return this.gridVarList;
    }

    private double[] calcSliceValue(double[] coordsEdges) {
        if (coordsEdges == null) {
            return null;
        }
        double[] values = new double[coordsEdges.length - 1];
        for (int i = 0; i < coordsEdges.length - 1; ++i) {
            values[i] = (coordsEdges[i] + coordsEdges[i + 1]) / 2.0;
        }
        return values;
    }

    @Override
    public Date[] getTimeList(String var) {
        return this.dateByVar.get(var);
    }

    @Override
    public double[] getLevelList(String var) {
        return this.rankByVar.get(var);
    }

    @Override
    public String getXDimVariable() {
        return this.xDimVariable;
    }

    @Override
    public String getYDimVariable() {
        return this.yDimVariable;
    }

    public String getDataStoreName() {
        return NetCDFProvider.NAME;
    }

    public String getDescription() {
        return NetCDFProvider.DESCRIPTION;
    }

    @Override
    public void selectNextInstant() {
        int i = this.getFieldTime() + 1;
        if (i < this.getTimeListLength()) {
            this.setDynValue("Time", i);
        }
    }

    @Override
    public void selectPrevInstant() {
        int i = this.getFieldTime() - 1;
        if (i >= 0) {
            this.setDynValue("Time", i);
        }
    }

    @Override
    public void goTo(int position) {
        if (position < this.getTimeListLength() && position >= 0) {
            this.setDynValue("Time", position);
        }
    }

    @Override
    public int getFieldTime() {
        if (this.hasDynValue("Time") && this.getDynValue("Time") != null) {
            return (Integer)this.getDynValue("Time");
        }
        return 0;
    }

    @Override
    public int getFieldLevel() {
        if (this.hasDynValue("Level") && this.getDynValue("Level") != null) {
            return (Integer)this.getDynValue("Level");
        }
        return 0;
    }

    @Override
    public String getStringVariable() {
        if (this.hasDynValue("GridVariable")) {
            return (String)this.getDynValue("GridVariable");
        }
        try {
            String[] var;
            ArrayList<String[]> vars = this.getGridVariables();
            if (vars.size() > 0 && (var = vars.get(0)).length > 0) {
                this.setFieldVariable(var[0]);
                return var[0];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getStringLevel() {
        if (!this.hasDynValue("Level")) {
            this.setFieldLevel(0);
        }
        int index = (Integer)this.getDynValue("Level");
        double[] levelList = this.getLevelList(this.getStringVariable());
        if (levelList == null) {
            return "-1";
        }
        return levelList[index] + "";
    }

    @Override
    public String getStringTime() {
        if (!this.hasDynValue("Time")) {
            this.setFieldTime(0);
        }
        int index = (Integer)this.getDynValue("Time");
        Date[] timeList = this.getTimeList(this.getStringVariable());
        if (timeList == null) {
            return "-1";
        }
        return timeList[index].toString();
    }

    private int getTimeListLength() {
        Date[] dateList;
        String var = (String)this.getDynValue("GridVariable");
        if (var != null && (dateList = this.getTimeList(var)) != null) {
            return dateList.length;
        }
        return 0;
    }

    @Override
    public void setFieldVariable(String variable) {
        this.setDynValue("GridVariable", variable);
    }

    @Override
    public void setFieldTime(int timePosInList) {
        this.setDynValue("Time", timePosInList);
    }

    @Override
    public void setFieldLevel(int levelPosInList) {
        this.setDynValue("Level", levelPosInList);
    }
}

