/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.netcdf.io;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.DefaultNoData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.tile.FileTileServer;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.netcdf.io.NetCDFDataParameters;
import org.gvsig.raster.netcdf.io.NetCDFDataParametersImpl;
import org.gvsig.raster.netcdf.io.NetCDFFilesystemServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.ProjectionRect;

public class NetCDFProvider
extends AbstractRasterProvider {
    public static String NAME = "NetCDF Raster";
    public static String DESCRIPTION = "NetCDF Raster file";
    public final String METADATA_DEFINITION_NAME = NAME;
    private Extent viewRequest = null;
    private TileServer tileServer = null;
    private boolean open = false;
    private GridDataset gridNetCDF = null;
    private List<GridDatatype> gridList = null;
    private GridDatatype selectedGridDataType = null;
    private DataStoreTransparency fileTransparency = null;
    private static final Logger logger = LoggerFactory.getLogger(NetCDFProvider.class);
    protected static String[] formatList = null;

    public static void register() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        RasterLocator.getManager().getProviderServices().registerFileProvidersTiled(NetCDFProvider.class);
        NetCDFProvider.registerFormats();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, NetCDFProvider.class, NetCDFDataParametersImpl.class);
        }
        if (DALFileLocator.getFilesystemServerExplorerManager() != null) {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider(NAME, DESCRIPTION, NetCDFFilesystemServerExplorer.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private static void registerFormats() {
        formatList = new String[]{"nc", "nc4"};
        for (int i = 0; i < formatList.length; ++i) {
            RasterLocator.getManager().getProviderServices().addFormat(formatList[i], NetCDFProvider.class);
        }
    }

    public String[] getFormatList() {
        return formatList;
    }

    public boolean isExtensionSupported(String ext) {
        if (ext.indexOf(".") != -1) {
            ext = ext.substring(ext.lastIndexOf(".") + 1, ext.length());
        }
        for (int i = 0; i < formatList.length; ++i) {
            if (formatList[i].compareTo(ext) != 0) continue;
            return true;
        }
        return false;
    }

    public NetCDFProvider() {
    }

    public NetCDFProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
        logger.info("Deprecated use of NetCDFProvider constructor");
        if (params instanceof String) {
            URI uriObj;
            NetCDFDataParametersImpl p = new NetCDFDataParametersImpl();
            try {
                uriObj = new URI(params);
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create URI from " + params, (Throwable)e);
            }
            p.setURI(uriObj);
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init(p, null);
        }
    }

    public NetCDFProvider(URI uri) throws NotSupportedExtensionException, OpenException {
        super(uri);
        NetCDFDataParametersImpl p = new NetCDFDataParametersImpl();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init(p, null);
    }

    public NetCDFProvider(NetCDFDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        super((DataStoreParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init(params, storeServices);
    }

    public void init(NetCDFDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException, OpenException {
        if (((RasterFileStoreParameters)params).getFile().exists()) {
            String fileName = ((RasterFileStoreParameters)params).getFile().getAbsolutePath();
            try {
                this.gridNetCDF = GridDataset.open((String)fileName);
                this.gridList = this.gridNetCDF.getGrids();
                if (this.gridList.size() == 0) {
                    throw new OpenException("There is not a grid variable", null);
                }
                this.selectedGridDataType = this.gridList.get(0);
            }
            catch (IOException e) {
                throw new OpenException("Imposible to read the file", (Throwable)e);
            }
            this.setParam(storeServices, (DataStoreParameters)params);
            this.reloadMetadataFromGrid();
            this.noData = new DefaultNoData((Number)Double.NaN, (Number)Double.NaN, fileName);
            this.load();
        } else {
            this.setParam(storeServices, (DataStoreParameters)params);
        }
        super.init();
        this.selectSubdataset(this.getId(0, 0, 0));
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        this.open = true;
    }

    private void reloadMetadataFromGrid() {
        ProjectionRect pRect = this.selectedGridDataType.getCoordinateSystem().getBoundingBox();
        double scaleX = pRect.getWidth() / (double)this.selectedGridDataType.getXDimension().getLength();
        double scaleY = pRect.getHeight() / (double)this.selectedGridDataType.getYDimension().getLength();
        this.ownTransformation = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, pRect.getMinX(), pRect.getMaxY());
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        this.bandCount = 1;
        this.setDataType();
    }

    private void setDataType() {
        DataType dt = this.selectedGridDataType.getDataType();
        int type = 32;
        if (dt.name() == DataType.BYTE.name()) {
            type = 0;
        }
        if (dt.name() == DataType.SHORT.name()) {
            type = 2;
        }
        if (dt.name() == DataType.INT.name()) {
            type = 3;
        }
        if (dt.name() == DataType.DOUBLE.name()) {
            type = 5;
        }
        if (dt.name() == DataType.FLOAT.name()) {
            type = 4;
        }
        if (dt.name() == DataType.LONG.name()) {
            type = 5;
        }
        int[] dtype = new int[this.getBandCount()];
        for (int i = 0; i < dtype.length; ++i) {
            dtype[i] = type;
        }
        this.setDataType(dtype);
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        try {
            this.gridNetCDF.close();
        }
        catch (IOException e) {
            logger.error("Error closing file", (Throwable)e);
        }
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = new ExtentImpl(e);
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        return this.selectedGridDataType.getXDimension().getLength();
    }

    public double getHeight() {
        return this.selectedGridDataType.getYDimension().getLength();
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        NetCDFDataParameters p = (NetCDFDataParameters)this.param;
        if (pos < 0) {
            throw new InvalidSetViewException("Request out of grid");
        }
        if ((double)(pos + blockHeight) > this.getHeight()) {
            blockHeight = Math.abs((int)this.getHeight() - pos);
        }
        Buffer buf = DefaultRasterManager.getInstance().createBuffer(this.getDataType()[0], (int)this.getWidth(), blockHeight, 1, true);
        try {
            int time = p.getFieldTime();
            int level = this.getLevelValue();
            Range rangeY = new Range(pos, pos + blockHeight - 1, 1);
            Range rangeX = new Range(0, (int)(this.getWidth() - 1.0), 1);
            GridDatatype dt = this.selectedGridDataType.makeSubset(null, null, null, null, rangeY, rangeX);
            Array values = dt.readDataSlice(time, level, -1, -1);
            return this.arrayValuesToBuffer(values, buf, rangeX.length(), rangeY.length(), null);
        }
        catch (IOException e) {
            throw new RasterDriverException("Error reading a slice", (Exception)e);
        }
        catch (InvalidRangeException e) {
            throw new RasterDriverException("Error reading a slice", (Exception)((Object)e));
        }
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        NetCDFDataParameters p = (NetCDFDataParameters)this.param;
        if (x < 0 || y < 0 || (double)x >= this.getWidth() || (double)y >= this.getHeight()) {
            throw new InvalidSetViewException("Request out of grid");
        }
        try {
            int strideX = 1;
            int strideY = 1;
            Range rangeY = new Range((int)(this.getHeight() - (double)y), (int)(this.getHeight() - (double)y), strideY);
            Range rangeX = new Range(x, x, strideX);
            this.selectSubdataset();
            int time = p.getFieldTime();
            int level = this.getLevelValue();
            GridDatatype dt = this.selectedGridDataType.makeSubset(null, null, null, null, rangeY, rangeX);
            Array values = dt.readDataSlice(time, level, -1, -1);
            Number data = null;
            if (this.getDataType()[0] == 0) {
                data = new Integer(values.getByte(0));
            }
            if (this.getDataType()[0] == 2) {
                data = new Integer(values.getShort(0));
            }
            if (this.getDataType()[0] == 3) {
                data = new Integer(values.getInt(0));
            }
            if (this.getDataType()[0] == 4) {
                data = new Float(values.getFloat(0));
            }
            if (this.getDataType()[0] == 5) {
                data = new Double(values.getDouble(0));
            }
            return data;
        }
        catch (IOException e) {
            throw new RasterDriverException("Error reading a slice", (Exception)e);
        }
        catch (InvalidRangeException e) {
            throw new RasterDriverException("Error reading a slice", (Exception)((Object)e));
        }
    }

    public void loadBuffer(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
        NetCDFDataParameters p = (NetCDFDataParameters)this.param;
        this.setView(query.getAdjustedRequestBoundingBox());
        Point2D ul = new Point2D.Double(this.viewRequest.getULX(), this.viewRequest.getULY());
        Point2D lr = new Point2D.Double(this.viewRequest.getLRX(), this.viewRequest.getLRY());
        ul = this.worldToRaster(ul);
        lr = this.worldToRaster(lr);
        ul.setLocation(ul.getX() < 0.0 ? 0.0 : ul.getX(), ul.getY() < 0.0 ? 0.0 : ul.getY());
        lr.setLocation(lr.getX() < 0.0 ? 0.0 : lr.getX(), lr.getY() < 0.0 ? 0.0 : lr.getY());
        ul.setLocation(ul.getX() >= this.getWidth() ? this.getWidth() - 1.0 : ul.getX(), ul.getY() >= this.getHeight() ? this.getHeight() - 1.0 : ul.getY());
        lr.setLocation(lr.getX() >= this.getWidth() ? this.getWidth() - 1.0 : lr.getX(), lr.getY() >= this.getHeight() ? this.getHeight() - 1.0 : lr.getY());
        this.adjustPoints(ul, lr);
        try {
            int strideX = 1;
            int strideY = 1;
            Range rangeY = new Range((int)(this.getHeight() - lr.getY()), (int)(this.getHeight() - ul.getY() - 1.0), strideY <= 0 ? 1 : strideY);
            Range rangeX = new Range((int)ul.getX(), (int)(lr.getX() - 1.0), strideX <= 0 ? 1 : strideX);
            this.selectSubdataset();
            int time = p.getFieldTime();
            int level = this.getLevelValue();
            GridDatatype dt = this.selectedGridDataType.makeSubset(null, null, null, null, rangeY, rangeX);
            Array values = dt.readDataSlice(time, level, -1, -1);
            Rectangle2D r = query.getBufferForProviders().getDataExtent();
            Buffer rasterBuf = this.arrayValuesToBuffer(values, query.getBufferForProviders(), rangeX.length(), rangeY.length(), query.getBandList());
            rasterBuf.setDataExtent(r);
            query.setBufferResult(rasterBuf);
        }
        catch (IOException e) {
            throw new RasterDriverException("Error reading a slice", (Exception)e);
        }
        catch (InvalidRangeException e) {
            throw new RasterDriverException("Error reading a slice", (Exception)((Object)e));
        }
    }

    private Range getTime(int strideX) throws InvalidRangeException {
        NetCDFDataParameters p = (NetCDFDataParameters)this.param;
        int time = p.getFieldTime();
        return new Range(time, time, strideX);
    }

    private Range getLevel(int strideX) throws InvalidRangeException {
        int level = this.getLevelValue();
        return new Range(level, level, strideX);
    }

    private int getLevelValue() {
        int level = 0;
        if (this.param.hasDynValue("Level") && this.param.getDynValue("Level") != null) {
            level = (Integer)this.param.getDynValue("Level");
        }
        return level;
    }

    public void selectSubdataset() {
        if (this.param.hasDynValue("GridVariable")) {
            NetCDFDataParameters p = (NetCDFDataParameters)this.param;
            String variable = (String)this.param.getDynValue("GridVariable");
            if (variable != null) {
                for (int j = 0; j < this.gridList.size(); ++j) {
                    if (this.gridList.get(j).getName().compareTo(variable) != 0) continue;
                    this.selectedGridDataType = this.gridList.get(j);
                    this.reloadMetadataFromGrid();
                    super.selectSubdataset(this.getId(j, this.getLevelValue(), p.getFieldTime()));
                }
            }
        }
    }

    private String getId(int grid, int level, int time) {
        return grid + "-" + level + "-" + time;
    }

    private Buffer arrayValuesToBuffer(Array values, Buffer rasterBuf, int w, int h, BandList bandList) {
        int iBands;
        int[] rc;
        int i;
        int[] drawableBands;
        Buffer buf = null;
        boolean resampling = false;
        if ((long)(rasterBuf.getWidth() * rasterBuf.getHeight()) != values.getSize()) {
            buf = DefaultRasterManager.getInstance().createBuffer(this.getDataType()[0], w, h, rasterBuf.getBandCount(), true);
            resampling = true;
        } else {
            buf = rasterBuf;
        }
        int[] nArray = drawableBands = bandList != null ? bandList.getBufferBandToDraw(new File(this.getURIOfFirstProvider()).getAbsolutePath(), 0) : new int[1];
        if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) {
            return rasterBuf;
        }
        if (this.getDataType()[0] == 0) {
            i = 0;
            while ((long)i < values.getSize()) {
                rc = this.getColAndRow(i, buf);
                for (iBands = 0; iBands < drawableBands.length; ++iBands) {
                    buf.setElem(rc[0], rc[1], drawableBands[iBands], values.getByte(i));
                }
                ++i;
            }
        }
        if (this.getDataType()[0] == 2) {
            i = 0;
            while ((long)i < values.getSize()) {
                rc = this.getColAndRow(i, buf);
                for (iBands = 0; iBands < drawableBands.length; ++iBands) {
                    buf.setElem(rc[0], rc[1], drawableBands[iBands], values.getShort(i));
                }
                ++i;
            }
        }
        if (this.getDataType()[0] == 3) {
            i = 0;
            while ((long)i < values.getSize()) {
                rc = this.getColAndRow(i, buf);
                for (iBands = 0; iBands < drawableBands.length; ++iBands) {
                    buf.setElem(rc[0], rc[1], drawableBands[iBands], values.getInt(i));
                }
                ++i;
            }
        }
        if (this.getDataType()[0] == 4) {
            i = 0;
            while ((long)i < values.getSize()) {
                rc = this.getColAndRow(i, buf);
                for (iBands = 0; iBands < drawableBands.length; ++iBands) {
                    buf.setElem(rc[0], rc[1], drawableBands[iBands], values.getFloat(i));
                }
                ++i;
            }
        }
        if (this.getDataType()[0] == 5) {
            i = 0;
            while ((long)i < values.getSize()) {
                rc = this.getColAndRow(i, buf);
                for (iBands = 0; iBands < drawableBands.length; ++iBands) {
                    buf.setElem(rc[0], rc[1], drawableBands[iBands], values.getDouble(i));
                }
                ++i;
            }
        }
        if (resampling) {
            try {
                Buffer result = null;
                result = buf.getAdjustedWindow(rasterBuf.getWidth(), rasterBuf.getHeight(), 1);
                if (result != buf) {
                    buf.dispose();
                }
                return result;
            }
            catch (ProcessInterruptedException e) {
                return buf;
            }
        }
        return buf;
    }

    private int[] getColAndRow(int i, Buffer buf) {
        int auxRow = i / buf.getWidth();
        return new int[]{buf.getHeight() - auxRow - 1, i - auxRow * buf.getWidth()};
    }

    private void adjustPoints(Point2D ul, Point2D lr) {
        double a = ul.getX() - (double)((int)ul.getX());
        double b = ul.getY() - (double)((int)ul.getY());
        ul.setLocation(a > 0.95 || a < 0.05 ? (double)Math.round(ul.getX()) : ul.getX(), b > 0.95 || b < 0.05 ? (double)Math.round(ul.getY()) : ul.getY());
        lr.setLocation(a > 0.95 || a < 0.05 ? (double)Math.round(lr.getX()) : lr.getX(), b > 0.95 || b < 0.05 ? (double)Math.round(lr.getY()) : lr.getY());
    }

    public int getBlockSize() {
        return 0;
    }

    public ColorInterpretation getColorInterpretation() {
        if (super.getColorInterpretation() == null) {
            this.setColorInterpretation((ColorInterpretation)new DataStoreColorInterpretation(new String[]{"Gray"}));
        }
        return super.getColorInterpretation();
    }

    public DataStoreTransparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency(this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public boolean isSupersampling() {
        return false;
    }

    public void setAffineTransform(AffineTransform t) {
        super.setAffineTransform(t);
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public boolean isOverviewsSupported() {
        return true;
    }

    public boolean isReproyectable() {
        return true;
    }

    public String getProviderName() {
        return NAME;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof NetCDFProvider) {
            // empty if block
        }
    }

    public boolean isTimeSupported() {
        return true;
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new FileTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

