/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvsig.sldsupport.SLDSupportManager;
import org.gvsig.sldsupport.exception.SLDException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.SLDWriteException;
import org.gvsig.sldsupport.exception.UnsupportedSLDVersionException;
import org.gvsig.sldsupport.impl.filter.DefaultSLDFilter;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.reader.SLDReader;
import org.gvsig.sldsupport.reader.SLDReaderFactory;
import org.gvsig.sldsupport.sld.SLDObject;
import org.gvsig.sldsupport.sld.filter.SLDFilter;
import org.gvsig.sldsupport.writer.SLDWriter;
import org.gvsig.sldsupport.writer.SLDWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSLDSupportManager
implements SLDSupportManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultSLDSupportManager.class);
    private Map<String, Set<SLDReaderFactory>> versionToReaders = new HashMap<String, Set<SLDReaderFactory>>();
    private Map<String, Set<SLDWriterFactory>> versionToWriters = new HashMap<String, Set<SLDWriterFactory>>();

    public void registerReader(SLDReaderFactory fact) {
        String v = fact.getVersion();
        Set<SLDReaderFactory> set = this.versionToReaders.get(v);
        if (set == null) {
            set = new HashSet<SLDReaderFactory>();
            set.add(fact);
            this.versionToReaders.put(v, set);
        } else {
            set.add(fact);
        }
    }

    public void registerWriter(SLDWriterFactory fact) {
        String v = fact.getVersion();
        Set<SLDWriterFactory> set = this.versionToWriters.get(v);
        if (set == null) {
            set = new HashSet<SLDWriterFactory>();
            set.add(fact);
            this.versionToWriters.put(v, set);
        } else {
            set.add(fact);
        }
    }

    public List<SLDWriter> createWriters(String version) throws UnsupportedSLDVersionException {
        Set<SLDWriterFactory> set = this.versionToWriters.get(version);
        if (set == null || set.size() == 0) {
            throw new UnsupportedSLDVersionException(version);
        }
        ArrayList<SLDWriter> resp = new ArrayList<SLDWriter>();
        Iterator<SLDWriterFactory> iter = set.iterator();
        SLDWriterFactory fact = null;
        while (iter.hasNext()) {
            fact = iter.next();
            try {
                resp.add(fact.create());
            }
            catch (Exception exc) {
                logger.info("Error while creating writer (ignored)", (Throwable)exc);
            }
        }
        return resp;
    }

    public List<SLDReader> createReaders(String version) throws UnsupportedSLDVersionException {
        Set<SLDReaderFactory> set = this.versionToReaders.get(version);
        if (set == null || set.size() == 0) {
            throw new UnsupportedSLDVersionException(version);
        }
        ArrayList<SLDReader> resp = new ArrayList<SLDReader>();
        Iterator<SLDReaderFactory> iter = set.iterator();
        SLDReaderFactory fact = null;
        while (iter.hasNext()) {
            fact = iter.next();
            try {
                resp.add(fact.create());
            }
            catch (Exception exc) {
                logger.info("Error while creating reader (ignored)", (Throwable)exc);
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SLDObject obj, String version, File outfile) throws IOException, SLDException {
        if (obj == null) {
            throw new IOException("Input SLDObject is null");
        }
        Set<SLDWriterFactory> wset = this.versionToWriters.get(version);
        if (wset == null || wset.size() == 0) {
            throw new UnsupportedSLDVersionException(version);
        }
        FileOutputStream outstream = null;
        Iterator<SLDWriterFactory> witer = wset.iterator();
        SLDWriterFactory fact_item2 = null;
        SLDWriter witem = null;
        while (witer.hasNext()) {
            fact_item2 = witer.next();
            witem = fact_item2.create();
            outstream = new FileOutputStream(outfile);
            try {
                witem.write(obj, (OutputStream)outstream);
                return;
            }
            catch (Exception exc) {
                logger.info("One of the writers was unable to write object: " + obj.getClass().getSimpleName());
            }
            finally {
                try {
                    ((OutputStream)outstream).close();
                }
                catch (Exception exc) {}
            }
        }
        for (SLDWriterFactory fact_item2 : wset) {
            witem = fact_item2.create();
            outstream = new FileOutputStream(outfile);
            try {
                witem.forceWrite(obj, (OutputStream)outstream);
                return;
            }
            catch (Exception exc) {
                logger.info("One of the writers was unable to force-write object: " + obj.getClass().getSimpleName());
            }
            finally {
                try {
                    ((OutputStream)outstream).close();
                }
                catch (Exception exception) {}
            }
        }
        throw new SLDWriteException("Unable to write with available writers (" + obj.getClass().getSimpleName() + ")");
    }

    private SLDObject read(File infile, String version) throws SLDException, IOException {
        if (infile == null || !infile.exists()) {
            throw new IOException("Null or non-existing file: " + (infile == null ? "Null" : infile.getAbsolutePath()));
        }
        FileInputStream instream = null;
        Set<SLDReaderFactory> sitem = null;
        Iterator<SLDReaderFactory> siter = null;
        SLDReaderFactory fact_item2 = null;
        SLDReader ritem = null;
        SLDObject resp = null;
        sitem = this.versionToReaders.get(version);
        if (sitem == null || sitem.size() == 0) {
            throw new SLDReadException("No SLD readers found for version: " + version);
        }
        for (SLDReaderFactory fact_item2 : sitem) {
            ritem = fact_item2.create();
            instream = new FileInputStream(infile);
            try {
                resp = ritem.read((InputStream)instream);
            }
            catch (Exception exc) {
                logger.info("One of the readers was unable to parse file: " + infile.getAbsolutePath(), (Throwable)exc);
            }
            try {
                ((InputStream)instream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resp == null) continue;
            return resp;
        }
        throw new SLDReadException("No available SLD reader was able to parse file: " + infile.getAbsolutePath());
    }

    public SLDObject read(File infile) throws SLDException, IOException {
        if (infile == null || !infile.exists()) {
            throw new IOException("Null or non-existing file: " + (infile == null ? "Null" : infile.getAbsolutePath()));
        }
        String v = null;
        try {
            v = SLDUtils.detectVersion(infile);
        }
        catch (Exception e) {
            v = null;
        }
        if (v != null) {
            return this.read(infile, v);
        }
        FileInputStream instream = null;
        Iterator<String> iter = this.versionToReaders.keySet().iterator();
        String vitem = null;
        Set<SLDReaderFactory> sitem = null;
        Iterator<SLDReaderFactory> siter = null;
        SLDReaderFactory fact_item = null;
        SLDReader ritem = null;
        SLDObject resp = null;
        boolean found = false;
        while (iter.hasNext()) {
            vitem = iter.next();
            sitem = this.versionToReaders.get(vitem);
            siter = sitem.iterator();
            while (siter.hasNext()) {
                found = true;
                fact_item = siter.next();
                ritem = fact_item.create();
                instream = new FileInputStream(infile);
                try {
                    resp = ritem.read((InputStream)instream);
                }
                catch (Exception exc) {
                    logger.info("One of the readers was unable to parse file: " + infile.getAbsolutePath(), (Throwable)exc);
                }
                try {
                    ((InputStream)instream).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (resp == null) continue;
                return resp;
            }
        }
        if (found) {
            throw new SLDReadException("No available SLD reader was able to parse file: " + infile.getAbsolutePath());
        }
        throw new SLDReadException("No SLD readers found.");
    }

    public SLDFilter createFilter() {
        return new DefaultSLDFilter();
    }
}

