/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.symbol;

import java.io.IOException;
import java.util.Map;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.DisplacementElement;
import org.gvsig.sldsupport.impl.sld.parsing.FillElement;
import org.gvsig.sldsupport.impl.sld.parsing.GeometryElement;
import org.gvsig.sldsupport.impl.sld.parsing.StrokeElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDDisplacement;
import org.gvsig.sldsupport.sld.symbol.SLDPolygonSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDFill;
import org.gvsig.sldsupport.sld.symbol.misc.SLDGeometry;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PolygonSymbolElement {
    public static void append(SLDPolygonSymbol obj, XmlBuilder xb, Map<String, String> atts) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        SLDDisplacement disp;
        SLDStroke stro;
        SLDFill fill;
        String v = obj.getVersion();
        if (v == null && atts != null) {
            v = atts.get("version");
        }
        if (v == null) {
            v = "1.0.0";
        }
        String ent = "";
        ent = v.compareToIgnoreCase("1.0.0") == 0 ? "PolygonSymbolizer" : "PolygonSymbol";
        if (atts == null) {
            xb.openTag(ent);
        } else {
            xb.openTag(ent, atts);
        }
        String gn = obj.getGeometryPropertyName();
        if (gn != null) {
            GeometryElement.append(new SLDGeometry(gn), xb, v);
        }
        if ((fill = obj.getFill()) != null) {
            FillElement.append(fill, xb, v);
        }
        if ((stro = obj.getStroke()) != null) {
            StrokeElement.append(stro, xb, v);
        }
        if (v.compareToIgnoreCase("1.1.0") == 0 && (disp = obj.getDisplacement()) != null) {
            DisplacementElement.append(disp, xb, v);
        }
        xb.closeTag();
    }

    public static SLDPolygonSymbol parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String ent_name = parser.getName();
        SLDPolygonSymbol resp = new SLDPolygonSymbol();
        resp.setVersion(version);
        int tag = 0;
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        while (!SLDUtils.isStr(name, ent_name) || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Geometry")) {
                        SLDGeometry geom = GeometryElement.parse(parser, version);
                        resp.setGeometryPropertyName(geom.getPropertyName());
                        break;
                    }
                    if (SLDUtils.isStr(name, "Fill")) {
                        SLDFill fil = FillElement.parse(parser, version);
                        resp.setFill(fil);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Stroke")) {
                        SLDStroke st = StrokeElement.parse(parser, version);
                        resp.setStroke(st);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Displacement")) {
                        resp.setVersion("1.1.0");
                        SLDDisplacement disp = DisplacementElement.parse(parser, version);
                        resp.setDisplacement(disp);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in polygon symbol: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

