/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlpull.prov.kxml.stream;

import java.io.IOException;
import java.io.InputStream;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;
import org.gvsig.xmlpull.prov.kxml.stream.KxmlQName;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class KxmlXmlStreamReader
implements IXmlStreamReader {
    private XmlPullParser parser;

    public KxmlXmlStreamReader(InputStream in) throws XmlStreamException {
        this.setInput(in);
    }

    public void setInput(InputStream inputStream) throws XmlStreamException {
        try {
            this.parser = new KXmlParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(inputStream, null);
        }
        catch (XmlPullParserException e) {
            throw new XmlStreamException((Throwable)e);
        }
    }

    public int getAttributeCount() throws XmlStreamException {
        return this.parser.getAttributeCount();
    }

    public IQName getAttributeName(int i) throws XmlStreamException {
        return new KxmlQName(this.parser.getAttributeNamespace(i), this.parser.getAttributeName(i));
    }

    public String getAttributeValue(int i) throws XmlStreamException {
        return this.parser.getAttributeValue(i);
    }

    public int getEventType() throws XmlStreamException {
        int xmlPullEventType;
        try {
            xmlPullEventType = this.parser.getEventType();
        }
        catch (XmlPullParserException e) {
            throw new XmlStreamException((Throwable)e);
        }
        return this.pullEventToGpeEventType(xmlPullEventType);
    }

    public IQName getName() throws XmlStreamException {
        try {
            int eventType = this.parser.getEventType();
            if (eventType != 1 && eventType != 2 && eventType != 3 && eventType != 4) {
                return null;
            }
            String name = this.parser.getName();
            if (name != null) {
                name = name.substring(name.indexOf(":") + 1, name.length());
                this.parser.getNamespace();
                return new KxmlQName(this.parser.getNamespace(), name);
            }
        }
        catch (XmlPullParserException e) {
            return null;
        }
        return null;
    }

    public String getText() throws XmlStreamException {
        return this.parser.getText();
    }

    public boolean isWhitespace() throws XmlStreamException {
        try {
            return this.parser.isWhitespace();
        }
        catch (XmlPullParserException e) {
            throw new XmlStreamException((Throwable)e);
        }
    }

    public int next() throws XmlStreamException {
        int xmlPullEventType;
        if (this.getEventType() == 8) {
            throw new XmlStreamException("End Document Exception! \n There aren't more items to get.");
        }
        try {
            xmlPullEventType = this.parser.next();
        }
        catch (XmlPullParserException e) {
            throw new XmlStreamException((Throwable)e);
        }
        catch (IOException e) {
            throw new XmlStreamException((Throwable)e);
        }
        return this.pullEventToGpeEventType(xmlPullEventType);
    }

    public int nextTag() throws XmlStreamException {
        int xmlPullEventType;
        if (this.getEventType() == 8) {
            throw new XmlStreamException("End Document Exception! \n There aren't more tags to get.");
        }
        try {
            xmlPullEventType = this.parser.nextTag();
        }
        catch (XmlPullParserException e) {
            throw new XmlStreamException((Throwable)e);
        }
        catch (IOException e) {
            throw new XmlStreamException((Throwable)e);
        }
        return this.pullEventToGpeEventType(xmlPullEventType);
    }

    private int pullEventToGpeEventType(int xmlPullEventType) {
        switch (xmlPullEventType) {
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 5;
            }
            case 10: {
                return 11;
            }
        }
        throw new IllegalStateException("Unknown tag type, this should't happen!: " + xmlPullEventType);
    }
}

