#!/bin/sh
#
# gvSIG. Desktop Geographic Information System.
#
# Copyright (C) 2007-2013 gvSIG Association.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301, USA.
#
# For any additional information, do not hesitate to contact us
# at info AT gvsig.com, or visit our website www.gvsig.com.
#


#
# Plugin autorun
#

PLUGIN_NAME=$(basename "$PLUGIN_FOLDER")


gdal_init() {
    logger_info "Using gdal from release-1800-gdal-1-11-3-mapserver-6-4-2"
    logger_info "http://www.gisinternals.com/query.html?content=filelist&file=release-1800-gdal-1-11-3-mapserver-6-4-2.zip"

    SDK_ROOT="$PLUGIN_FOLDER/gdal"
    add_library_path "$SDK_ROOT/bin"
    add_library_path "$SDK_ROOT/bin/gdal/java"

    add_classpath "$SDK_ROOT/bin/gdal/java/gdal.jar"

    #export GDAL_DATA="$SDK_ROOT/bin/gdal-data-1.11.3"
    export GDAL_DATA="$SDK_ROOT/bin/gdal-data-2.2.1"

    export GDAL_DRIVER_PATH="$SDK_ROOT/bin/gdal/plugins;$SDK_ROOT/bin/gdal/plugins-optional"
    export PYTHONPATH="$SDK_ROOT/bin/gdal/python;$SDK_ROOT/bin/ms/python"
    export PROJ_LIB="$SDK_ROOT/bin/gdal/proj/SHARE"

    list_shared_library_dependencies "$SDK_ROOT/bin/gdal/java/gdaljni.dll"
    list_shared_library_dependencies "$SDK_ROOT/bin/gdal/java/gdalconstjni.dll"
    list_shared_library_dependencies "$SDK_ROOT/bin/gdal/java/ogrjni.dll"
    list_shared_library_dependencies "$SDK_ROOT/bin/gdal/java/osrjni.dll"
    list_shared_library_dependencies "$SDK_ROOT/bin/proj.dll"
}

gdal_init