
def __createAction(scriptName, label=None, iconName=None, tooltip=None, position= 2009009009):
  from org.gvsig.andami import PluginsLocator
  from org.gvsig.scripting.app.extension import ScriptingExtension
  from javax.imageio import ImageIO
  from org.gvsig.tools.swing.api import ToolsSwingLocator
  from java.io import File
  from org.apache.commons.io import FilenameUtils
  from javax.swing import ImageIcon
  
  if label == None:
    label = scriptName
  if iconName == None:
    iconName = "tools-scripting-launcher"
  if tooltip == None:
    tooltip = label
  if isinstance(iconName,File):
    iconFile = iconName
    iconName = FilenameUtils.getBaseName(iconFile.getName())
    iconImage = ImageIcon(ImageIO.read(iconFile))
    iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault()
    iconTheme.registerDefault("scripting", "scripting", iconName, iconImage, None)
    
  actionManager = PluginsLocator.getActionInfoManager()
  actionName = "script-%s" % scriptName
  action = actionManager.createAction(
    ScriptingExtension, 
    actionName, 
    label, 
    scriptName, 
    iconName, 
    None, 
    position, 
    tooltip
  )
  action = actionManager.registerAction(action)
  return action

def toolbar_add(scriptName, label=None, iconName=None, tooltip=None, position=2009009009):
  application = ApplicationLocator.getManager()
  action = __createAction(scriptName, label, iconName, tooltip, position)
  application.addTool(action, "scripting")
  application.message("added script '%s' to toolbar" % scriptName,1)

def menus_add(scriptName, label=None, menuEntry=None, iconName=None, tooltip=None, position= 2009009009):
  application = ApplicationLocator.getManager()
  action = __createAction(scriptName, label, iconName, tooltip, position)
  if menuEntry == None:
    menuEntry = "tools/Scripting/%s" % action.getLabel()
  application.addMenu(action, menuEntry)
  application.message("added script '%s' to menu '%s'" % (scriptName,menuEntry),1)
