# -*- coding: utf-8 -*-
#
# File: simpleui.py
#
# Copyright (c) 2011 by Model Driven Development sl and Antonio Carrasco Valero
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
#

__author__ = """Antonio Carrasco Valero
Model Driven Development sl and Antonio Carrasco Valero
<carrasco@modeldd.org>"""
__docformat__ = 'plaintext'


from gvsig import *

def loadViewsInCombo(dialog, combo):
  cleanCombo(dialog, combo)
  project = currentProject()
  print "project"
  views = project.getViews()
  print "views"
  if isinstance(combo, str):
    combo = dialog.find(combo)
  print "combo"
  if combo == None:
    return
  print "combo not None"
  for view in views:
    print "create view choice"
    ch = dialog.create("choice")  
    dialog.setString(ch, "name", view.getName())
    dialog.setString(ch, "text", view.getName())
    #FIXME
    #--------------------
    
    dialog.putProperty(ch, "view", View(view))
    #----------------------
    dialog.add(combo, ch)
  print "Finish add combo choices"
  

def loadLayersInCombo(dialog, combo, viewName):
  if isinstance(combo, str):
    combo = dialog.find(combo)
  p = currentProject()
  view = p.getView(viewName)

  if combo == None or view == None:
    return
  cleanCombo(dialog, combo)
  
  ls = view.getLayers()
  try:
    for i in xrange(len(ls)):
      l = ls.getLayer(i)
      ch = dialog.create("choice")  
      dialog.setString(ch, "name", l.getName())
      dialog.setString(ch, "text", l.getName())    #FIXME
      #--------------------
      dialog.putProperty(ch, "layer",Layer(l))
      #----------------------

      dialog.add(combo, ch)
  except Exception, ex:
    print "Error %s"%repr(ex)

  
  print "Finish add layers combo choices"

def cleanCombo(dialog, combo):
  print "cleanCombo"
  if isinstance(combo, str):
    combo = dialog.find(combo)
  if combo == None:
    return
  choices = dialog.getItems(combo)
  if len(choices) >0:
    for ch in choices:
      dialog.remove(ch)

def getSelectedView(dialog, combo):
  if isinstance(combo, str):
    combo = dialog.find(combo)
  choice = dialog.getSelectedItem(combo)
  if choice == None:
    return
  viewName = dialog.getString(choice,"name")
  #FIXME
  """
  project = currentProject()
  view = project.getView(viewName)
  """
  view = dialog.getProperty(choice, "view")
  return view

def getSelectedViewName(dialog, combo):
  v = getSelectedView(dialog, combo)
  return v.getName()

def getSelectedLayer(dialog, combo):
  if isinstance(combo, str):
    combo = dialog.find(combo)
  choice = dialog.getSelectedItem(combo)
  if choice == None:
    return
  #FIXME
  """
  layerName = dialog.getString(choice,"name")
  project = currentProject()
  layer = project.getView(layerName)
  """
  layer = dialog.getProperty(choice,"layer")
  print layer.getName()
  return layer