


from org.gvsig.app.project.documents.table import TableDocument as JTableDocument

from org.gvsig.fmap.dal import DALLocator

def _features(self, filter = None, sortby="", asc=True):
  return self.getFeatureStore().features(filter,sortby,asc)

def _iter_features(self):
  return self.getFeatureStore().getFeatureSet().__iter__()

def _len_features(self):
  return self.getFeatureStore().getFeatureSet().getSize()

def _edit(self,mode=1):
  self.getFeatureStore().edit(mode)

def _append(self, *valuesList, **values):
  self.getFeatureStore().append(*valuesList, **values)

def _updateSchema(self, schema):
  self.getFeatureStore().update(schema)

def _update(self, feature):
  self.getFeatureStore().update(feature)

def _getSchema(self):
  return self.getFeatureStore().getDefaultFeatureType()

def _commit(self):
  self.getFeatureStore().finishEditing()

def _abort(self):
  self.getFeatureStore().cancelEditing()

def _getSelection(self):
  return self.getFeatureStore().getFeatureSelection()

def _select(self, selection):
  self.getFeatureStore().getFeatureSelection().select(selection)

def _deselect(self, selection):
  self.getFeatureStore().getFeatureSelection().deselect(selection)

def _isSelected(feature):
  self.getFeatureStore().getFeatureSelection().isSelect(feature)

def _getFeatureStore(self):
  return self.getStore()

def _call(self):
  return self

def _createNewFeature(self, feature=None):
  if feature == None:
    return self.getFeatureStore().createNewFeature()
  else:
    return self.getFeatureStore().createNewFeature(feature)

def _getWindowOfTable(self):
    application = ApplicationLocator.getManager()
    projectManager = application.getProjectManager()
    tableManager = projectManager.getDocumentManager(TableManager.TYPENAME)
    return tableManager.getMainWindow(self,None)


#
# Inject new methods in the class JTableDocument
#
JTableDocument.createNewFeature = _createNewFeature
JTableDocument.getFeatureStore = _getFeatureStore
JTableDocument.__iter__ = _iter_features
JTableDocument.__len__ = _len_features
JTableDocument.__call__ = _call
JTableDocument.features = _features
JTableDocument.edit = _edit
JTableDocument.append = _append
JTableDocument.updateSchema = _updateSchema
JTableDocument.update = _update
JTableDocument.getSchema = _getSchema
JTableDocument.commit = _commit
JTableDocument.abort = _abort
JTableDocument.getSelection = _getSelection
JTableDocument.select = _select
JTableDocument.deselect = _deselect
JTableDocument.isSelected = _isSelected
JTableDocument.finishEditing = _commit
JTableDocument.cancelEditing = _abort
JTableDocument.getWindowOfTable = _getWindowOfTable


