
from gvsig.uselib import use_plugin

use_plugin("org.gvsig.app.document.layout2.app.mainplugin")

from gvsig import *
from org.gvsig.app.project.documents.layout import DefaultLayoutManager
from gvsig.commonsdialog import *

from gvsig.libs.formpanel import FormPanel 

class CustomizeLayout(FormPanel):
  def __init__(self):
    FormPanel.__init__(self,script.getResource("personalizar_mapa3.xml"))
    # Llenamos el desplegable de mapas con los mapas que hay en el proyecto.
    proyecto = currentProject()()
    docs = proyecto.getDocuments()
    for doc in docs :
      if doc.__class__.__name__ == "DefaultLayoutDocument":
        cboMapas.addItem(doc)
    pass
    
  def actualizar_mapa(self, mapa, tagVista, tagTitulo, tagLogo, encuadre, titulo, logo):
    context = mapa.getLayoutContext()
  
    # Nos recorremos todos los elementos del mapa buscando los que hemos etiquetado
    for elemento in  context.getAllFFrames():
      if elemento.getTag() == tagVista:
        # Ajustamos el encuadre de la vista al del elemento seleccionado
        mapContext = elemento.getMapContext()
        mapContext.getViewPort().setEnvelope(encuadre)
        mapContext.invalidate()
  
      elif elemento.getTag() == tagTitulo:
        # Cambiamos el rotulo del texto que habiamos etiquetado en el mapa
        elemento.clearText()
        elemento.addText(titulo)
  
      elif elemento.getTag() == tagLogo:
        # Cambiamos la imagen del logotipo
        elemento.setImage(logo)
  
    context.fullRefresh()

  def btnCerrar_click(*args):
    self.hide()
  
  def cboMapas_click(*args):
    mapa = self.cboMapas.getSelectedItem()
  
    cboTagVista = self.cboTagVista
    cboTagTitulo = self.cboTagTitulo
    cboTagLogotipo= self.cboTagLogotipo
  
    for elemento in  mapa.getLayoutContext().getAllFFrames():
      #print elemento.__class__.__name__
      if not elemento.getTag() in (None, ""):
        if elemento.__class__.__name__ == "FFrameText":
          self.cboTagTitulo.addItem(elemento.getTag())
  
        elif elemento.__class__.__name__ == "FFrameView":
          self.cboTagVista.addItem(elemento.getTag())
  
        elif elemento.__class__.__name__ == "FFramePicture":
          self.cboTagLogotipo.addItem(elemento.getTag())
  
  
  def btnActualizarMapa_click(*args):
    # Obtenemos la capa activa de la vista activa
    capa = currentLayer()
    if capa == None:
      msgbox("Debera tener seleccionada una capa.")
      return
  
    # Obtenemos el primer elemento seleccionado de la capa
    seleccion = list()
    seleccion.extend(capa.getSelection())
    if len(seleccion) < 1:
      msgbox("Debera tener seleccionados elementos en la capa activa.")
      return
    entidad = seleccion[0]
  
    mapa = self.cboMapas.getSelectedItem()
    tagVista = self.cboTagVista.getSelectedItem()
    tagTitulo = self.cboTagTitulo.getSelectedItem()
    tagLogotipo = self.cboTagLogotipo.getSelectedItem()
    if tagVista in ("",None) or tagTitulo in ("",None) :
      msgbox("Debera seleccionar el tag de la vista, titulo y logotipo")
      return
  
    encuadre = entidad.geometry().getEnvelope()
    try:
      titulo = eval(self.txtTitulo.getText(), entidad)
    except:
      titulo = self.txtTitulo.getText()
  
    try:
      logotipo_nombre = eval(self.txtLogotipo.getText(), entidad)
      logotipo = load_image(script.getResource(logotipo_nombre))
    except:
      logotipo = None
  
    self.actualizar_mapa(mapa, tagVista, tagTitulo, tagLogotipo, encuadre, titulo, logotipo)



def main(*args):
  customizeLayout = CustomizeLayout()
  customizeLayout.showTool("Customize layout")


