# encoding: utf-8

from gvsig import currentLayer
from gvsig.geom import POINT, LINE, POLYGON
from gvsig import commonsdialog

def main():
  """
  Modify layer data definition and adds new fields to store features geometry 
  information.
  If is points layer type adds 'X' 'Y' and 'Z' coordinates
  If is lines layer type adds perimeter value
  IF is polygons layer adds Area and perimeter values
  """
  #
  #Invoke gvsig.currentLayer function to get active layer
  #If not view or active layer in view raise RuntimeException
  layer = currentLayer()
  
  # Gets layer type. If layer type is not supported shows a message, else 
  # adds geometry information to features
  layertype = layer.getTypeVectorLayer()
  if layertype.isSubTypeOf(POINT):
      addInfoToPoint(layer)
  elif layertype.isSubTypeOf(LINE):
      addInfoToLine(layer)
  elif layertype.isSubTypeOf(POLYGON):
      addInfoToPolygon(layer)
  else:
      text = """This layer is not supported. 
      Layer type must be:
        - Points
        - Line
        - Polygon
      Finish script."""
      title = "Warning"
      messageType = commonsdialog.FORBIDEN
      commonsdialog.msgbox(text, title, messageType)
      
def addInfoToPoint(layer):
  layer.edit()
  schema = layer.getSchema()
  xName=generateUniqColumnName(schema,"X")
  schema.append(xName, "Double", size=15, precision = 3)
  yName=generateUniqColumnName(schema,"Y")
  schema.append(yName, "Double", size=15, precision = 3)
  zName=generateUniqColumnName(schema,"Z")
  schema.append(zName, "Double", size=15, precision = 3)
  layer.updateSchema(schema)

  for feature in layer.features():
    feature.edit()
    point = feature.geometry()
    feature.set(xName,point.getX())
    feature.set(yName,point.getY())
    if point.getDimension()>2:
      feature.set(zName,point.getCoordinateAt(2))
    layer.update(feature)
    
  layer.commit() 


def addInfoToPolygon(layer):
  layer.edit()
  schema = layer.getSchema()
  areaName=generateUniqColumnName(schema,"Area")
  schema.append(areaName, "Double", size=15, precision = 3)
  perimeterName=generateUniqColumnName(schema,"Perimeter")
  schema.append(perimeterName, "Double", size=15, precision = 3)

  layer.updateSchema(schema)

  for feature in layer.features():
    feature.edit()
    polygon = feature.geometry()
    feature.set(areaName,polygon.area())
    feature.set(perimeterName,polygon.perimeter())

    layer.update(feature)

def addInfoToLine(layer):
  layer.edit()
  schema = layer.getSchema()
  perimeterName=generateUniqColumnName(schema,"Perimeter")
  schema.append(perimeterName, "Double", size=15, precision = 3)

  layer.updateSchema(schema)

  for feature in layer.features():
    feature.edit()
    line = feature.geometry()
    feature.set(perimeterName,line.perimeter())

    layer.update(feature)
    
  layer.commit() 

def generateUniqColumnName(schema, name):
   cont = 1
   name2 = name
   while True:
     attr = schema.get(name2)
     if attr == None:
       return name2
     cont += 1
     name2 = "%s%s" % (name , cont)
