/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api.documentfilters;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class RegexpDocumentFilter
extends DocumentFilter {
    private final Pattern pattern;
    private final JTextField text;
    private final Color backgroundOk;
    private final Color backgroundErr;

    public static void install(JTextField text, String pattern) {
        Document doc = text.getDocument();
        if (doc instanceof PlainDocument) {
            ((PlainDocument)doc).setDocumentFilter(new RegexpDocumentFilter(text, pattern));
        }
    }

    public static void setValue(JTextField text, String value) {
        text.setText(value);
    }

    public static String getValue(JTextField text) {
        String s = text.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        PlainDocument doc = (PlainDocument)text.getDocument();
        RegexpDocumentFilter docfilter = (RegexpDocumentFilter)doc.getDocumentFilter();
        return docfilter.getValue();
    }

    public static boolean isValid(JTextField text) {
        String s = text.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return true;
        }
        PlainDocument doc = (PlainDocument)text.getDocument();
        RegexpDocumentFilter docfilter = (RegexpDocumentFilter)doc.getDocumentFilter();
        return docfilter.isValid();
    }

    public static boolean isEmpty(JTextField text) {
        String s = text.getText();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return true;
        }
        PlainDocument doc = (PlainDocument)text.getDocument();
        RegexpDocumentFilter docfilter = (RegexpDocumentFilter)doc.getDocumentFilter();
        String value = docfilter.getValue();
        return StringUtils.isEmpty((CharSequence)value);
    }

    private RegexpDocumentFilter(JTextField text, String pattern) {
        this.pattern = Pattern.compile(pattern);
        this.text = text;
        this.backgroundOk = text.getBackground();
        this.backgroundErr = ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor();
    }

    public static void setValue(JTextField text, double value) {
        text.setText(String.valueOf(value));
    }

    private boolean test(String text) {
        Matcher m = this.pattern.matcher(text);
        return m != null && m.matches();
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, offset, string, attr);
        String s = this.text.getText();
        if (this.test(s)) {
            this.text.setBackground(this.backgroundOk);
        } else {
            this.text.setBackground(this.backgroundErr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(fb, offset, length, text, attrs);
        String s = this.text.getText();
        if (this.test(s)) {
            this.text.setBackground(this.backgroundOk);
        } else {
            this.text.setBackground(this.backgroundErr);
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        super.remove(fb, offset, length);
        String s = this.text.getText();
        if (this.test(s)) {
            this.text.setBackground(this.backgroundOk);
        } else {
            this.text.setBackground(this.backgroundErr);
        }
    }

    private String getValue() {
        String s = this.text.getText();
        if (this.test(s)) {
            return s;
        }
        return null;
    }

    private boolean isValid() {
        String s = this.text.getText();
        return this.test(s);
    }
}

