/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.creation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePackageService;
import org.gvsig.installer.lib.api.creation.MakePackageServiceException;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.tools.service.Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMakePackageService
implements MakePackageService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMakePackageService.class);
    public static final String COPIED_FILES_DIRECTORY_NAME = "files";
    private final InstallerManager manager;
    protected File packageFolder;
    protected String antScript = null;
    private InstallPackageProviderServices installerProviderServices = null;
    private PackageInfo packageInfo;

    public DefaultMakePackageService(InstallerManager manager, File packageFolder, PackageInfo packageInfo) {
        this.manager = manager;
        this.packageFolder = packageFolder;
        this.packageInfo = packageInfo;
        this.installerProviderServices = InstallerProviderLocator.getProviderManager().createInstallerProviderServices();
    }

    public Manager getManager() {
        return this.manager;
    }

    public void preparePackage() throws MakePackageServiceException {
        LOG.debug("Preparing a package set of the package info: \n{0}", (Object)this.packageInfo);
        if (this.packageInfo.getAntScript() != null) {
            this.writeAntFile(this.packageInfo);
        }
    }

    public void createPackageSet(OutputStream packageStream) throws MakePackageServiceException {
        LOG.debug("Creating a package set of the package info: \n{0}", (Object)this.packageInfo);
        this.installerProviderServices.writePackageInfo(this.packageFolder, this.packageInfo);
        String pluginFileName = this.manager.getPackageFileName(this.packageInfo);
        this.installerProviderServices.compressPackageSet(this.packageFolder, pluginFileName, packageStream);
    }

    public void createPackageIndexSet(URL downloadurl, OutputStream packageStream) throws MakePackageServiceException {
        LOG.debug("Creating a package set of the package info: \n{0}", (Object)this.packageInfo);
        try {
            PackageInfo infoIndex = (PackageInfo)this.packageInfo.clone();
            infoIndex.setDownloadURL(downloadurl);
            this.installerProviderServices.writePackageInfo(this.packageFolder, this.packageInfo);
            String pluginFileName = this.manager.getPackageFileName(this.packageInfo);
            this.installerProviderServices.compressPackageSet(this.packageFolder, pluginFileName, packageStream);
        }
        catch (Exception e) {
            throw new MakePackageServiceException((Throwable)e);
        }
    }

    public void createPackage(OutputStream packageStream) throws MakePackageServiceException {
        LOG.debug("Creating package of the package info: \n{0}", (Object)this.packageInfo);
        this.installerProviderServices.writePackageInfo(this.packageFolder, this.packageInfo);
        this.installerProviderServices.compressPackage(this.packageFolder, packageStream);
    }

    public void createPackageIndex(URL downloadurl, OutputStream packageStream) throws MakePackageServiceException {
        LOG.debug("Creating package index of the package info: \n{0}", (Object)this.packageInfo);
        try {
            PackageInfo infoIndex = (PackageInfo)this.packageInfo.clone();
            infoIndex.setDownloadURL(downloadurl);
            this.installerProviderServices.writePackageInfo(this.packageFolder, infoIndex);
            this.installerProviderServices.compressPackageIndex(this.packageFolder, packageStream);
        }
        catch (Exception e) {
            throw new MakePackageServiceException((Throwable)e);
        }
    }

    protected void createInstallFolderInPackageFolder() {
        File installdir = new File(this.packageFolder, "install");
        installdir.mkdir();
    }

    private void writeAntFile(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        try {
            int len;
            this.createInstallFolderInPackageFolder();
            ByteArrayInputStream in = new ByteArrayInputStream(packageInfo.getAntScript().getBytes());
            FileOutputStream out = new FileOutputStream(this.getAntFile());
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Exception writing the ant file");
        }
    }

    private File getAntFile() {
        return new File(this.packageFolder.getAbsolutePath() + File.separator + "install" + File.separator + "install.xml");
    }

    public String getDefaultAntScript() throws MakePluginPackageServiceException {
        try {
            URL resource = this.getClass().getResource("install.xml");
            return this.readUrlAsString(resource);
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Impossible to read the default ant file", (Throwable)e);
        }
    }

    private String readUrlAsString(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer fileData = new StringBuffer(1000);
        String line = bufferedReader.readLine();
        while (line != null) {
            fileData.append(line + "\n");
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        return fileData.toString();
    }
}

