/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarDialog
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener {
    private static final SimpleDateFormat monthStringFormatter = new SimpleDateFormat("MMMM");
    private static final SimpleDateFormat monthFormatter = new SimpleDateFormat("MM");
    private static final SimpleDateFormat weekDayStringFormatter = new SimpleDateFormat("EEEE");
    private static final String[] monthNames = new String[12];
    private static final String[] weekDayNames = new String[7];
    private GregorianCalendar calendar;
    private JComboBox monthCombo;
    private JSpinner yearSpinner;
    private JButton okButton;
    private JPanel middlePanel;
    private JLabel[] numbers;

    public CalendarDialog(Frame frame) {
        super(frame, true);
        this.common();
    }

    private CalendarDialog() {
        this.common();
    }

    private void common() {
        int i;
        this.calendar = new GregorianCalendar();
        this.getContentPane().setLayout(new BorderLayout());
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(this.okButton);
        southPanel.setBorder(CalendarDialog.bigEtched());
        this.middlePanel = new JPanel();
        this.middlePanel.setLayout(new GridLayout(7, 7));
        this.middlePanel.setBorder(CalendarDialog.bigEtched());
        this.numbers = new JLabel[42];
        for (i = 0; i < 7; ++i) {
            JLabel letterLabel = new JLabel((weekDayNames[i].charAt(0) + "").toUpperCase());
            letterLabel.setHorizontalAlignment(0);
            this.middlePanel.add(letterLabel);
        }
        for (i = 0; i < 42; ++i) {
            this.numbers[i] = new JLabel();
            this.numbers[i].setOpaque(true);
            this.unselect(i);
            this.numbers[i].setHorizontalAlignment(0);
            this.numbers[i].addMouseListener(this);
            this.middlePanel.add(this.numbers[i]);
        }
        this.getContentPane().add((Component)this.middlePanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        this.monthCombo = new JComboBox<String>(monthNames);
        this.monthCombo.addActionListener(this);
        northPanel.add((Component)this.monthCombo, "Center");
        this.yearSpinner = new JSpinner(new SpinnerNumberModel());
        this.yearSpinner.addChangeListener(this);
        northPanel.add((Component)this.yearSpinner, "East");
        this.getContentPane().add((Component)northPanel, "North");
        this.pack();
    }

    public void show() {
        super.show();
    }

    private static Border bigEtched() {
        Border eBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border bBorder = BorderFactory.createEtchedBorder();
        return BorderFactory.createCompoundBorder(bBorder, eBorder);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.monthCombo) {
            this.calendar.set(2, this.monthCombo.getSelectedIndex());
            this.setDate(this.calendar.getTime());
        } else if (e.getSource() == this.okButton) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.yearSpinner) {
            this.calendar.set(1, Integer.parseInt(this.yearSpinner.getValue() + ""));
            this.setDate(this.calendar.getTime());
        }
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
        this.monthCombo.setSelectedIndex(this.calendar.get(2));
        this.yearSpinner.setValue(new Integer(this.calendar.get(1)));
        int dayOfMonth = this.calendar.get(5);
        int firstDayInWeek = this.calendar.getFirstDayOfWeek();
        GregorianCalendar testCalendar = new GregorianCalendar();
        testCalendar.setTime(this.calendar.getTime());
        testCalendar.set(5, 1);
        int dayStart = testCalendar.get(7);
        for (int i = 0; i < 42; ++i) {
            this.numbers[i].setText("");
            this.unselect(i);
        }
        int offSet = 0;
        if (dayStart - firstDayInWeek < 0) {
            offSet = 7;
        }
        for (int i = offSet + dayStart - firstDayInWeek; i < this.calendar.getActualMaximum(5) + dayStart - firstDayInWeek + offSet; ++i) {
            this.numbers[i].setText("" + (i - dayStart + 1 + firstDayInWeek - offSet));
            this.unselect(i);
        }
        this.select(dayOfMonth - (firstDayInWeek + 1) + dayStart);
    }

    private void unselect(int i) {
        if (i >= 0 && i < 42) {
            this.numbers[i].setForeground(Color.BLACK);
            this.numbers[i].setBackground(Color.WHITE);
        }
    }

    private void select(int i) {
        if (i >= 0 && i < 42) {
            this.numbers[i].setBackground(Color.BLACK);
            this.numbers[i].setForeground(Color.WHITE);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < 42; ++i) {
            if (source == this.numbers[i]) {
                this.select(i);
                GregorianCalendar testCalendar = new GregorianCalendar();
                testCalendar.setTime(this.calendar.getTime());
                testCalendar.set(5, 1);
                int dayStart = testCalendar.get(7);
                int firstDayInWeek = testCalendar.getFirstDayOfWeek();
                int offSet = 0;
                if (dayStart - firstDayInWeek < 0) {
                    offSet = 7;
                }
                int newDay = i + 1 - (dayStart - firstDayInWeek) - offSet;
                this.calendar.set(5, newDay);
                continue;
            }
            this.unselect(i);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public static void main(String[] args) {
        new CalendarDialog(new JFrame());
    }

    static {
        try {
            for (int i = 1; i <= 12; ++i) {
                CalendarDialog.monthNames[i - 1] = monthStringFormatter.format(monthFormatter.parse("" + i));
            }
            GregorianCalendar testCalendar = new GregorianCalendar();
            testCalendar.set(7, testCalendar.getFirstDayOfWeek());
            for (int i = 1; i <= 7; ++i) {
                CalendarDialog.weekDayNames[i - 1] = weekDayStringFormatter.format(testCalendar.getTime());
                testCalendar.roll(7, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

