/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.about.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.gvsig.about.AboutManager;
import org.gvsig.about.AboutParticipant;
import org.gvsig.about.AboutProject;
import org.gvsig.about.AboutSponsor;
import org.gvsig.about.impl.DefaultAboutManager;

public class JAboutBrowser
extends JPanel {
    public static final int DEFAULT_ACTION = 1;
    public static final int SELECTION_ACTION = 2;
    public static final int DROPDOWN_ACTION = 3;
    private static final long serialVersionUID = 1L;
    protected DefaultAboutManager manager;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    protected AboutProject root;
    protected ActionListener defaultActionlistener = null;
    protected ActionListener selectionActionlistener = null;
    protected ActionListener dropDownActionlistener = null;

    public JAboutBrowser(DefaultAboutManager manager, AboutProject root) {
        super(new GridLayout(1, 2));
        this.manager = manager;
        this.root = root;
        this.makeUI();
    }

    public AboutManager getManager() {
        return this.manager;
    }

    public void addDefaultActionListener(ActionListener actionlistener) {
        this.defaultActionlistener = actionlistener;
    }

    public void addSelectionActionListener(ActionListener actionlistener) {
        this.selectionActionlistener = actionlistener;
    }

    public void addDropDownActionListener(ActionListener actionlistener) {
        this.dropDownActionlistener = actionlistener;
    }

    private void makeUI() {
        ImageIcon icon = this.manager.getImageIcon(this.root.getIcon(), "gvSIG.png");
        this.rootNode = new DefaultMutableTreeNode(new NodeData(icon, icon, this.root));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.initializeTree();
        IconCellRenderer renderer = new IconCellRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.setEditable(false);
        this.expandAll();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JTree tree;
                if (arg0.getClickCount() == 1 && !(tree = (JTree)arg0.getSource()).isSelectionEmpty()) {
                    JAboutBrowser.this.throwEventElementSelected(tree.getSelectionPath());
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.tree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
        this.setPreferredSize(new Dimension(200, 300));
    }

    public Object getSelectedNode() {
        DefaultMutableTreeNode node = this.tree.getSelectionPath() != null ? (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent() : this.rootNode;
        NodeData nodeData = (NodeData)node.getUserObject();
        if (nodeData.getParticipant() != null) {
            return nodeData.getParticipant();
        }
        if (nodeData.getProject() != null) {
            return nodeData.getProject();
        }
        return null;
    }

    private void throwEventElementSelected(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        NodeData nodeData = (NodeData)node.getUserObject();
        if (nodeData.getParticipant() != null) {
            if (this.defaultActionlistener != null) {
                BrowserActionEvent event = new BrowserActionEvent((Object)this, 1, "default", nodeData.getParticipant());
                this.defaultActionlistener.actionPerformed(event);
            }
        } else if (nodeData.getProject() != null && this.defaultActionlistener != null) {
            BrowserActionEvent event = new BrowserActionEvent((Object)this, 1, "default", nodeData.getProject());
            this.defaultActionlistener.actionPerformed(event);
        }
    }

    private void initializeTree() {
        NodeData data;
        ImageIcon icon;
        AboutParticipant ap = null;
        NodeData sponsors = new NodeData(this.manager.getImageIcon("folder.png"), this.manager.getImageIcon("folder-drag-accept.png"), "Sponsors");
        DefaultMutableTreeNode sponsorsNode = this.addObject(this.rootNode, sponsors);
        List<AboutSponsor> participants = this.manager.getSponsors();
        for (int i = 0; i < participants.size(); ++i) {
            ap = (AboutParticipant)participants.get(i);
            icon = this.manager.getImageIcon(ap.getIcon(), "applications-internet.png");
            data = new NodeData(icon, icon, ap);
            this.addObject(sponsorsNode, data);
        }
        NodeData developers = new NodeData(this.manager.getImageIcon("edit.png"), this.manager.getImageIcon("edit.png"), "Developers");
        DefaultMutableTreeNode developersNode = this.addObject(this.rootNode, developers);
        participants = this.manager.getDevelopers();
        for (int i = 0; i < participants.size(); ++i) {
            ap = (AboutParticipant)participants.get(i);
            icon = this.manager.getImageIcon(ap.getIcon(), "preferences-system.png");
            data = new NodeData(icon, icon, ap);
            this.addObject(developersNode, data);
        }
        NodeData translators = new NodeData(this.manager.getImageIcon("system-users.png"), this.manager.getImageIcon("system-users.png"), "Contributors");
        DefaultMutableTreeNode translatorsNode = this.addObject(this.rootNode, translators);
        participants = this.manager.getTranslators();
        for (int i = 0; i < participants.size(); ++i) {
            ap = (AboutParticipant)participants.get(i);
            icon = this.manager.getImageIcon(ap.getIcon(), "people.png");
            data = new NodeData(icon, icon, ap);
            this.addObject(translatorsNode, data);
        }
    }

    public void expandAll() {
        for (int row = 0; row < this.tree.getRowCount(); ++row) {
            this.tree.expandRow(row);
        }
    }

    private DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    private DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    private class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        protected boolean m_selected;

        public IconCellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            this.setText(obj.toString());
            if (obj instanceof Boolean) {
                this.setText("Retrieving data...");
            }
            if (obj instanceof NodeData) {
                NodeData nodeData = (NodeData)obj;
                if (expanded) {
                    this.setIcon(nodeData.getExpandedIcon());
                } else {
                    this.setIcon(nodeData.getIcon());
                }
            } else {
                this.setIcon(null);
            }
            this.setFont(tree.getFont());
            this.setForeground(sel ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(sel ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = sel;
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            Color bColor = this.getBackground();
            Icon icon = this.getIcon();
            g.setColor(bColor);
            int offset = 0;
            if (icon != null && this.getText() != null) {
                offset = icon.getIconWidth() + this.getIconTextGap();
            }
            g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            if (this.m_selected) {
                g.setColor(this.m_borderSelectionColor);
                g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
            super.paintComponent(g);
        }
    }

    private static class NodeData {
        private Icon m_icon;
        private Icon m_expandedIcon;
        private Object m_data;

        public NodeData(Icon icon, Icon expandedIcon, Object data) {
            this.m_icon = icon;
            this.m_expandedIcon = expandedIcon;
            this.m_data = data;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public Icon getExpandedIcon() {
            return this.m_expandedIcon != null ? this.m_expandedIcon : this.m_icon;
        }

        public AboutParticipant getParticipant() {
            try {
                return (AboutParticipant)this.m_data;
            }
            catch (Exception e) {
                return null;
            }
        }

        public AboutProject getProject() {
            try {
                return (AboutProject)this.m_data;
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            return this.m_data.toString();
        }
    }

    public static class BrowserActionEvent
    extends ActionEvent {
        private static final long serialVersionUID = -1474410768278633364L;
        private Object participant;

        public BrowserActionEvent(Object source, int id, String command, Object participant) {
            super(source, id, command);
            this.participant = participant;
        }

        public Object getParticipant() {
            return this.participant;
        }
    }
}

