/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.controls.combobutton;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gvsig.gui.beans.controls.IControl;
import org.gvsig.gui.beans.controls.combobutton.ComboButtonEvent;
import org.gvsig.gui.beans.controls.combobutton.ComboButtonListener;

public class ComboButton
extends JButton
implements IControl,
MouseListener,
MouseMotionListener,
ActionListener {
    private static final long serialVersionUID = -1412453774004951410L;
    private JPopupMenu popMenu = new JPopupMenu();
    private static int BORDER = 6;
    private int offsetTrianglex = -4;
    private int offsetTriangley = -4;
    private int triangleWidth = 8;
    private int triangleHeight = 7;
    private boolean showToolTipText = true;
    private boolean showMenuAlways = true;
    private boolean alwaysMenuOnClick = false;
    private ArrayList<ComboButtonListener> actionCommandListeners = new ArrayList();
    private boolean nextSeparator = false;

    public ComboButton() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addActionListener(this);
    }

    public boolean selectMode(int mode) {
        String modeText = mode + "";
        for (int i = 0; i < this.popMenu.getSubElements().length; ++i) {
            JMenuItem mi = (JMenuItem)this.popMenu.getSubElements()[i];
            if (!mi.getActionCommand().equals(modeText)) continue;
            this.selectItem(mi);
            return true;
        }
        return false;
    }

    private void selectItem(JMenuItem mi) {
        this.setIcon(mi.getIcon());
        this.setToolTipText(mi.getText());
        this.setActionCommand(mi.getActionCommand());
    }

    public void setSelectedItem(String actionCommand) {
        for (int i = 0; i < this.popMenu.getSubElements().length; ++i) {
            if (!((JMenuItem)this.popMenu.getSubElements()[i].getComponent()).getActionCommand().equals(actionCommand)) continue;
            this.selectItem((JMenuItem)this.popMenu.getSubElements()[i].getComponent());
            break;
        }
    }

    public void clearButtons() {
        this.popMenu.removeAll();
    }

    public void addButton(JButton menu) {
        JMenuItem mi = new JMenuItem();
        mi.setText(menu.getText());
        mi.setIcon(menu.getIcon());
        mi.setEnabled(menu.isEnabled());
        mi.setActionCommand(menu.getActionCommand());
        mi.addActionListener(this);
        if (this.nextSeparator) {
            this.popMenu.addSeparator();
            this.nextSeparator = false;
        }
        this.popMenu.add(mi);
        if (this.popMenu.getSubElements().length == 1) {
            this.setIcon(menu.getIcon());
            this.setActionCommand(menu.getActionCommand());
            this.setToolTipText(menu.getText());
        }
    }

    public void addSeparator() {
        this.nextSeparator = true;
    }

    public void setPopupVisible(boolean flag) {
        if (flag) {
            if (this.popMenu.isShowing()) {
                return;
            }
            this.popMenu.show(this, 0, this.getHeight());
        } else {
            this.popMenu.setVisible(false);
        }
    }

    public void setAction(ActionEvent action) {
        for (int i = 0; i < this.popMenu.getSubElements().length; ++i) {
            if (!((JMenuItem)this.popMenu.getSubElements()[i].getComponent()).getActionCommand().equals(action.getActionCommand())) continue;
            ((JMenuItem)this.popMenu.getSubElements()[i].getComponent()).doClick();
        }
    }

    @Override
    public Object setValue(Object value) {
        return value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.popMenu.getSubElements().length; ++i) {
            if (!(e.getSource() instanceof JMenuItem) || this.popMenu.getSubElements()[i] != e.getSource()) continue;
            this.selectItem((JMenuItem)e.getSource());
            this.callComboButtonClickedListeners();
            return;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.showMenuAlways || this.popMenu.getSubElements().length > 1) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawTriangle(g2);
        }
    }

    private void drawTriangle(Graphics2D g2) {
        GeneralPath gp = new GeneralPath();
        int x = 0;
        x = this.offsetTrianglex < 0 ? this.getWidth() + this.offsetTrianglex - BORDER : this.offsetTrianglex + BORDER;
        int y = 0;
        y = this.offsetTriangley < 0 ? this.getHeight() + this.offsetTriangley - BORDER : this.offsetTriangley + BORDER;
        gp.moveTo(x, y);
        gp.lineTo(x + this.triangleWidth, y);
        gp.lineTo(x + this.triangleWidth / 2, y + this.triangleHeight);
        gp.closePath();
        g2.setColor(Color.white);
        g2.fill(gp);
        g2.setColor(new Color(0, 0, 0, 130));
        g2.draw(gp);
    }

    private boolean popupTriangleClicked(int x, int y) {
        if (this.alwaysMenuOnClick) {
            return true;
        }
        if (!this.showMenuAlways && this.popMenu.getSubElements().length <= 1) {
            return false;
        }
        if (this.offsetTrianglex < 0 ? x < this.getWidth() - BORDER + this.offsetTrianglex : x > BORDER + this.offsetTrianglex + this.triangleWidth) {
            return false;
        }
        return !(this.offsetTriangley < 0 ? y < this.getHeight() - BORDER + this.offsetTriangley : y > BORDER + this.offsetTriangley + this.triangleHeight);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean showPopup = this.popupTriangleClicked(e.getX(), e.getY());
        if (showPopup) {
            this.setPopupVisible(showPopup);
        } else {
            this.callComboButtonClickedListeners();
        }
    }

    public void addComboButtonClickedListener(ComboButtonListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeComboButtonClickedListener(ComboButtonListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callComboButtonClickedListeners() {
        for (ComboButtonListener listener : this.actionCommandListeners) {
            listener.actionComboButtonClicked(new ComboButtonEvent(this));
        }
    }

    @Override
    public String getToolTipText() {
        if (this.showToolTipText) {
            return super.getToolTipText();
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.popupTriangleClicked(e.getX(), e.getY())) {
            this.setPopupVisible(true);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.showToolTipText = !this.popMenu.isShowing();
    }

    public boolean isShowMenuAlways() {
        return this.showMenuAlways;
    }

    public void setShowMenuAlways(boolean showMenuAlways) {
        this.showMenuAlways = showMenuAlways;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public boolean isAlwaysMenuOnClick() {
        return this.alwaysMenuOnClick;
    }

    public void setAlwaysMenuOnClick(boolean alwaysMenuOnClick) {
        this.alwaysMenuOnClick = alwaysMenuOnClick;
    }

    @Override
    public Object getValue() {
        return null;
    }
}

