/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.ComponentConstraints;
import com.jeta.forms.gui.form.GridCellEvent;
import com.jeta.forms.gui.form.GridCellListener;
import com.jeta.forms.gui.form.GridComponentConstraints;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.handler.CellKeyboardHandler;
import com.jeta.forms.gui.handler.CellMouseHandler;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.StateRequest;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;

public abstract class GridComponent
extends JPanel {
    private JETABean m_jetabean;
    private boolean m_selected;
    private CellMouseHandler m_mousehandler;
    private CellKeyboardHandler m_keyboardhandler;
    private GridView m_gridview;
    private ComponentConstraints m_cc;
    private LinkedList m_listeners = new LinkedList();
    private boolean m_design_mode;
    private static final int MIN_WIDTH = 16;
    private static final int MIN_HEIGHT = 16;
    private Dimension m_min_size = new Dimension(16, 16);
    static final int EMPTY_CELL_WIDTH = 10;
    static final int EMPTY_CELL_HEIGHT = 10;

    public GridComponent() {
        this.m_design_mode = FormUtils.isDesignMode();
        this.setOpaque(false);
    }

    public GridComponent(GridView parentView) {
        this.m_design_mode = FormUtils.isDesignMode();
        this.setOpaque(false);
    }

    public GridComponent(JETABean jbean, GridView parent) {
        this.m_jetabean = jbean;
        this.m_gridview = parent;
        this.m_design_mode = FormUtils.isDesignMode();
        this.setOpaque(false);
    }

    public void addListener(GridCellListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void fireGridCellEvent(GridCellEvent evt) {
        Iterator iter = this.m_listeners.iterator();
        while (iter.hasNext()) {
            GridCellListener listener = (GridCellListener)iter.next();
            listener.cellChanged(evt);
        }
    }

    public JETABean getBean() {
        return this.m_jetabean;
    }

    Component getBeanChildComponent() {
        if (this.m_jetabean != null) {
            return this.m_jetabean.getBeanChildComponent();
        }
        return null;
    }

    public Component getBeanDelegate() {
        if (this.m_jetabean != null) {
            return this.m_jetabean.getDelegate();
        }
        return null;
    }

    public ComponentConstraints getConstraints() {
        if (this.m_cc == null) {
            this.m_cc = new GridComponentConstraints(this);
        }
        return this.m_cc;
    }

    public Dimension getMinimumSize() {
        if (this.m_design_mode) {
            return this.m_min_size;
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.m_design_mode) {
            Dimension d = super.getPreferredSize();
            if (d == null || d.width < 16 || d.height < 16) {
                if (d == null) {
                    d = this.m_min_size;
                }
                this.m_min_size.width = Math.max(d.width, 16);
                this.m_min_size.height = Math.max(d.height, 16);
                return this.m_min_size;
            }
            return d;
        }
        Dimension d = super.getPreferredSize();
        return d;
    }

    public String getBeanName() {
        if (this.m_jetabean == null) {
            return null;
        }
        return this.m_jetabean.getName();
    }

    public GridView getParentView() {
        Container parent = this.getParent();
        if (parent instanceof GridView) {
            return (GridView)parent;
        }
        if (parent != null) {
            if ((parent = parent.getParent()) instanceof GridView) {
                return (GridView)parent;
            }
            if (parent != null && (parent = parent.getParent()) instanceof GridView) {
                return (GridView)parent;
            }
        }
        return null;
    }

    public int getRow() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getRow();
    }

    public int getRowSpan() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getRowSpan();
    }

    public int getColumnSpan() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getColumnSpan();
    }

    public int getColumn() {
        if (this.getParentView() == null) {
            return 1;
        }
        return this.getConstraints().getColumn();
    }

    public CellMouseHandler getMouseHandler() {
        return this.m_mousehandler;
    }

    public int getCellWidth() {
        int colspan = this.getColumnSpan();
        int col = this.getColumn();
        int width = this.getParentView().getColumnWidth(col);
        for (int index = 1; index < colspan; ++index) {
            width += this.getParentView().getColumnWidth(col + index);
        }
        return width;
    }

    public int getCellHeight() {
        int rowspan = this.getRowSpan();
        int row = this.getRow();
        int height = this.getParentView().getRowHeight(row);
        for (int index = 1; index < rowspan; ++index) {
            height += this.getParentView().getRowHeight(row + index);
        }
        return height;
    }

    public int getCellX() {
        return this.getParentView().getColumnOrgX(this.getColumn());
    }

    public int getCellY() {
        return this.getParentView().getRowOrgY(this.getRow());
    }

    public String getId() {
        return this.getBeanName();
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void removeListener(GridCellListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setMouseHandler(CellMouseHandler handler) {
        this.m_mousehandler = handler;
    }

    public void setName(String name) {
        FormUtils.safeAssert(false);
    }

    protected void setBean(JETABean jbean) {
        this.m_jetabean = jbean;
    }

    public void setSelected(boolean sel) {
        boolean old_sel = this.m_selected;
        this.m_selected = sel;
        if (sel != old_sel && this.getParentView() != null) {
            this.getParentView().getOverlay().repaint(this);
        }
        if (sel) {
            this.fireGridCellEvent(new GridCellEvent(3, this));
        }
    }

    public CellKeyboardHandler getKeyboardHandler() {
        return this.m_keyboardhandler;
    }

    public void setKeyboardHandler(CellKeyboardHandler handler) {
        this.m_keyboardhandler = handler;
    }

    public void setParentView(GridView view) {
        FormUtils.safeAssert(this.getParentView() == null);
        this.m_gridview = view;
    }

    public void postInitialize(FormPanel panel) {
    }

    public abstract ComponentMemento getState(StateRequest var1) throws FormException;

    public abstract void setState(ComponentMemento var1) throws FormException;

    public boolean hasBean() {
        if (this.m_jetabean != null) {
            return this.m_jetabean.getDelegate() != null;
        }
        return false;
    }

    public boolean isShowing() {
        if (this.m_jetabean == null) {
            return true;
        }
        Component delegate = this.m_jetabean.getDelegate();
        if (delegate == null) {
            return true;
        }
        Dimension d = delegate.getSize();
        return d != null && d.width != 0 && d.height != 0;
    }

    public abstract void print();
}

