/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormGroupSet;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.support.Matrix;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class FormMemento
extends ComponentMemento {
    static final long serialVersionUID = -7808404997780438089L;
    public static final int VERSION = 5;
    private String m_row_specs;
    private String m_column_specs;
    private LinkedList m_components = new LinkedList();
    private PropertiesMemento m_properties_memento;
    private String m_path;
    private String m_id;
    private Matrix m_cell_painters;
    private FormGroupSet m_row_groups;
    private FormGroupSet m_column_groups;
    private FocusPolicyMemento m_focus_policy;
    private HashMap m_properties = new HashMap();

    public void addComponent(ComponentMemento memento) {
        this.m_components.add(memento);
    }

    public Matrix getCellPainters() {
        return this.m_cell_painters;
    }

    public FormGroupSet getColumnGroups() {
        return this.m_column_groups;
    }

    public String getColumnSpecs() {
        return this.m_column_specs;
    }

    public FocusPolicyMemento getFocusPolicy() {
        return this.m_focus_policy;
    }

    public String getId() {
        return this.m_id;
    }

    public PropertiesMemento getPropertiesMemento() {
        return this.m_properties_memento;
    }

    public HashMap getProperties() {
        return this.m_properties;
    }

    public String getRelativePath() {
        return this.m_path;
    }

    public FormGroupSet getRowGroups() {
        return this.m_row_groups;
    }

    public String getRowSpecs() {
        return this.m_row_specs;
    }

    public Iterator iterator() {
        return this.m_components.iterator();
    }

    public void print() {
        System.out.println(" >>>>>>>>>>>>>>>>>  FormMemento state >>>>>>>>>>>>>> ");
        System.out.println("rowSpecs: " + this.m_row_specs);
        System.out.println("colSpecs: " + this.m_column_specs);
        System.out.println(" ----------- comp mementos --------- ");
        Iterator iter = this.m_components.iterator();
        while (iter.hasNext()) {
            ComponentMemento cm = (ComponentMemento)iter.next();
            cm.print();
        }
    }

    public void setCellPainters(Matrix painters) {
        this.m_cell_painters = painters;
    }

    public void setColumnGroups(FormGroupSet colgrps) {
        this.m_column_groups = colgrps;
    }

    public void setColumnSpecs(String colSpecs) {
        this.m_column_specs = colSpecs;
    }

    public void setFocusPolicy(FocusPolicyMemento memento) {
        this.m_focus_policy = memento;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setRelativePath(String path) {
        this.m_path = path;
    }

    public void setRowGroups(FormGroupSet rowgrps) {
        this.m_row_groups = rowgrps;
    }

    public void setProperties(HashMap props) {
        this.m_properties = props;
    }

    public void setPropertiesMemento(PropertiesMemento pm) {
        this.m_properties_memento = pm;
    }

    public void setRowSpecs(String rowSpecs) {
        this.m_row_specs = rowSpecs;
    }

    public int size() {
        return this.m_components.size();
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_id = (String)in.readObject("id");
        this.m_path = (String)in.readObject("path");
        if (FormUtils.isDesignMode()) {
            this.m_path = FormUtils.fixPath(this.m_path);
        }
        this.m_row_specs = (String)in.readObject("rowspecs");
        this.m_column_specs = (String)in.readObject("colspecs");
        this.m_components = (LinkedList)in.readObject("components");
        if (version >= 5) {
            this.m_properties_memento = (PropertiesMemento)in.readObject("properties");
        } else {
            this.m_properties = (HashMap)in.readObject("properties");
        }
        if (version >= 2) {
            this.m_cell_painters = (Matrix)in.readObject("cellpainters");
        }
        if (version >= 3) {
            this.m_focus_policy = (FocusPolicyMemento)in.readObject("focuspolicy");
            this.m_focus_policy = null;
        }
        if (version >= 4) {
            this.m_row_groups = (FormGroupSet)in.readObject("rowgroups");
            this.m_column_groups = (FormGroupSet)in.readObject("colgroups");
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(ComponentMemento.class));
        out.writeVersion(5);
        out.writeObject("id", this.m_id);
        out.writeObject("path", this.m_path);
        out.writeObject("rowspecs", this.m_row_specs);
        out.writeObject("colspecs", this.m_column_specs);
        out.writeObject("components", this.m_components);
        out.writeObject("properties", this.m_properties_memento);
        out.writeObject("cellpainters", this.m_cell_painters);
        out.writeObject("focuspolicy", this.m_focus_policy);
        out.writeObject("rowgroups", this.m_row_groups);
        out.writeObject("colgroups", this.m_column_groups);
    }
}

